#ifndef XDKWRL_FONTSTYLE_H
#define XDKWRL_FONTSTYLE_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfstring.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfstring.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of FontStyle
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API FontStyle : public Node
  {
   public:
     FontStyle(const char* name="");
     virtual ~FontStyle();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       
        \endcode
       */
       MFString   family;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       horizontal = true;
        \endcode
       */
       SFBool     horizontal;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       
        \endcode
       */
       MFString   justify;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       language = string("");
        \endcode
       */
       SFString   language;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       leftToRight = true;
        \endcode
       */
       SFBool     leftToRight;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       size = 1.0f;
        \endcode
       */
       SFFloat    size;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       spacing = 1.0f;
        \endcode
       */
       SFFloat    spacing;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       style = string("PLAIN");
        \endcode
       */
       SFString   style;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       topToBottom = true;
        \endcode
       */
       SFBool     topToBottom;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
  //!@}
  };
};
//************************************************************
// Implementation of FontStyle
//************************************************************
/*!
 * Returns <code>"FontStyle"</code>. Useful for printing.
 */
inline const char*
wrl::FontStyle::typeName() const
{
  return "FontStyle";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::FontStyle::nbFields() const
{
   return 9;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::FontStyle::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::FontStyle::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_FONTSTYLE_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
