#ifndef XDKWRL_SFVEC3F_H
#define XDKWRL_SFVEC3F_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes.h>
#include <iostream>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  SFVec3f
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   *
   * Represents a 3 coordinates (X,Y,Z) vector. Below is included the
   * documentation for this field type from the ISO standard.   
   * \htmlinclude sfvec3f.html
   */
  class XDKWRL_API SFVec3f 
  {
  public:
    inline SFVec3f();
    inline SFVec3f(const float* c);
    inline SFVec3f(const float x,const float y,const float z);
    inline operator const float*() const;
    inline operator float*();
    inline float x() const;
    inline float y() const;
    inline float z() const;
    inline void setXYZ(const float x,const float y,const float z);
    inline void setX(const float);
    inline void setY(const float);
    inline void setZ(const float);
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    inline bool operator==(const SFVec3f& c) const;
    friend std::ostream& operator<<(std::ostream& s,const SFVec3f& f);
  protected:
  private:
    float x_;
    float y_;
    float z_;
  };
  //************************************************************
  // Implementation of SFVec3f
  //************************************************************
  inline
  SFVec3f::SFVec3f()
    : x_(0.0f),y_(0.0f),z_(0.0f)
  {
  }
  inline
  SFVec3f::SFVec3f(const float* c)
    : x_(c[0]),y_(c[1]),z_(c[2])    
  {    
  }
  inline
  SFVec3f::SFVec3f(const float x,const float y,const float z)
    : x_(x),y_(y),z_(z)    
  {    
  }    
  inline
  SFVec3f::operator const float*() const
  {
    return &x_;
  }
  inline
  SFVec3f::operator float*()
  {
    return &x_;
  }
  inline float
  SFVec3f::x() const
  {
    return x_;
  }
  inline float
  SFVec3f::y() const
  {
    return y_;
  }
  inline float
  SFVec3f::z() const
  {
    return z_;
  }
  inline void
  SFVec3f::setX(const float x)
  {
    x_ = x;
  }
  inline void
  SFVec3f::setY(const float y)
  {
    y_ = y;
  }
  inline void
  SFVec3f::setZ(const float z)
  {
    z_ = z;
  }  
  inline void
  SFVec3f::setXYZ(const float x,const float y,const float z)
  {
    x_ = x;
    y_ = y;
    z_ = z;
  }  
  inline bool
  SFVec3f::operator==(const SFVec3f& c) const
  {
    return x_ == c.x_ && y_ == c.y_ && z_ == c.z_;
  }
  inline const char*
  SFVec3f::typeName()
  {
    return "SFVec3f";
  }
  inline FieldTypeId
  SFVec3f::typeId()
  {
    return sfVec3f;
  }  
};

#endif // XDKWRL_SFVEC3F_H
