#ifndef XDKWRL_SFSTRING_H
#define XDKWRL_SFSTRING_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes.h>
#include <iostream>
#include <string>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  SFString
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   *
   * Represents a string value. Below is included the documentation for this
   * field type from the ISO standard.   
   * \htmlinclude sfstring.html
   */
  class XDKWRL_API SFString 
  {
  public:
    inline SFString();
    inline SFString(const char* c);
    inline SFString(const std::string& s);
    inline SFString& operator=(const char* b);
    inline SFString& operator=(const std::string& b);
    inline SFString& operator=(const SFString& b);
    inline operator const char*() const;
    inline operator std::string() const;
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    inline bool operator==(const SFString& s) const;
    friend std::ostream& operator<<(std::ostream& s,const SFString& f);
  protected:
  private:
    std::string value_;
  };
  //************************************************************
  // Implementation of SFString
  //************************************************************
  inline
  SFString::SFString()
    : value_()
  {
  }
  inline
  SFString::SFString(const char* c)
    : value_(c)
  {    
  }
  inline
  SFString::SFString(const std::string& s)
    : value_(s)
  {    
  }
  inline SFString&
  SFString::operator=(const char* b)
  {
    value_ = b;
    return *this;
  }
  inline SFString&
  SFString::operator=(const std::string& b)
  {
    value_ = b;
    return *this;
  }
  inline SFString&
  SFString::operator=(const SFString& b)
  {
    value_ = b.value_;
    return *this;
  }
  inline
  SFString::operator const char*() const
  {
    return value_.c_str();
  }
  inline
  SFString::operator std::string() const
  {
    return value_;
  }
  inline const char*
  SFString::typeName()
  {
    return "SFString";
  }
  inline FieldTypeId
  SFString::typeId()
  {
    return sfString;
  }  
  inline bool
  SFString::operator==(const SFString& s) const
  {
    return value_ == s.value_;
  }
};

#endif // XDKWRL_SFSTRING_H
