#ifndef XDKWRL_SFNODE_H
#define XDKWRL_SFNODE_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes.h>
#include <iostream>

namespace wrl
{
  class Node;
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of SFNode
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   *
   * Represents a pointer to a Node. Below is included the documentation for
   * this field type from the ISO standard.   
   * \htmlinclude sfnode.html
   */
  class XDKWRL_API SFNode 
  {
  public:
    inline SFNode();
    inline SFNode(Node* n);
    inline SFNode& operator=(Node* n);
    inline SFNode& operator=(const SFNode n);
    inline operator Node*() const;
    inline Node* node() const;
    inline Node* operator->() const;
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    friend std::ostream& operator<<(std::ostream& s,const SFNode& f);
  protected:
  private:
    Node* value_;
  };
  //************************************************************
  // Implementation of SFNode
  //************************************************************
  inline
  SFNode::SFNode()
    : value_(NULL)
  {
  }
  inline
  SFNode::SFNode(Node* n)
    : value_(n)
  {
  }
  inline SFNode&
  SFNode::operator=(Node* n)
  {
    value_ = n;
    return *this;
  }
  inline SFNode&
  SFNode::operator=(const SFNode n)
  {
    value_ = n.value_;
    return *this;
  }
  inline
  SFNode::operator Node*() const
  {
    return value_;
  }
  inline Node*
  SFNode::node() const
  {
    return value_;
  }
  inline Node*
  SFNode::operator->() const
  {
    return value_;
  }
  inline const char*
  SFNode::typeName()
  {
    return "SFNode";
  }
  inline FieldTypeId
  SFNode::typeId()
  {
    return sfNode;
  }  
};


#endif // XDKWRL_SFNODE_H
