#ifndef XDKWRL_SFINT32_H
#define XDKWRL_SFINT32_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes.h>
#include <iostream>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of SFInt32
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   *
   * Represents an integer value. Below is included the documentation for
   * this field type from the ISO standard.   
   * \htmlinclude sfint32.html
   */
  class XDKWRL_API SFInt32 
  {
  public:
    inline SFInt32();
    inline SFInt32(const int b);
    inline SFInt32& operator=(const int b);
    inline SFInt32& operator=(const SFInt32 b);
    inline operator int() const;
    inline int operator==(const SFInt32& b);
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    friend std::ostream& operator<<(std::ostream& s,const SFInt32& f);
  protected:
  private:
    int value_;
  };
  //************************************************************
  // Implementation of SFInt32
  //************************************************************
  /*!
   * Creates a SFInt32 with default value 0.0f. 
   */
  inline
  SFInt32::SFInt32()
    : value_(0)
  {
  }
  /*!
   * Creates a SFInt32 with value \p b.
   */
  inline
  SFInt32::SFInt32(const int b)
    : value_(b)
  {
  } 
  inline SFInt32&
  SFInt32::operator=(const int b)
  {
    value_ = b;
    return *this;
  }
  inline SFInt32&
  SFInt32::operator=(const SFInt32 b)
  {
    value_ = b.value_;
    return *this;
  }
  inline
  SFInt32::operator int() const
  {
    return value_;
  }
  inline int
  SFInt32::operator==(const SFInt32& b)
  {
    return value_ == b.value_;
  }
  inline const char*
  SFInt32::typeName()
  {
    return "SFInt32";
  }
  inline FieldTypeId
  SFInt32::typeId()
  {
    return sfInt32;
  }  
};

#endif // XDKWRL_SFINT32_H
