#ifndef XDKWRL_SFFLOAT_H
#define XDKWRL_SFFLOAT_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes.h>
#include <iostream>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of SFFloat
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   *
   * Represents a float value. Below is included the documentation for this
   * field type from the ISO standard.   
   * \htmlinclude sffloat.html
   */
  class XDKWRL_API SFFloat 
  {
  public:
    inline SFFloat();
    inline SFFloat(const float b);
    inline SFFloat& operator=(const float b);
    inline SFFloat& operator=(const SFFloat b);
    inline operator float() const;
    inline float operator==(const SFFloat& b);
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    friend std::ostream& operator<<(std::ostream& s,const SFFloat& f);
  protected:
  private:
    float value_;
  };
  //************************************************************
  // Implementation of SFFloat
  //************************************************************
  /*!
   * Creates a SFFloat with default value 0.0f. 
   */
  inline
  SFFloat::SFFloat()
    : value_(0.0f)
  {
  }
  /*!
   * Creates a SFFloat with value \p b.
   */
  inline
  SFFloat::SFFloat(const float b)
    : value_(b)
  {
  } 
  inline SFFloat&
  SFFloat::operator=(const float b)
  {
    value_ = b;
    return *this;
  }
  inline SFFloat&
  SFFloat::operator=(const SFFloat b)
  {
    value_ = b.value_;
    return *this;
  }
  inline
  SFFloat::operator float() const
  {
    return value_;
  }
  inline float
  SFFloat::operator==(const SFFloat& b)
  {
    return value_ == b.value_;
  }
  inline const char*
  SFFloat::typeName()
  {
    return "SFFloat";
  }
  inline FieldTypeId
  SFFloat::typeId()
  {
    return sfFloat;
  }  
};

#endif // XDKWRL_SFFLOAT_H
