#ifndef XDKWRL_MFSTRING_H
#define XDKWRL_MFSTRING_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes/sfstring.h>
#include <deque>
#include <algorithm>
#include <iterator>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  MFString
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   * 
   * A MFString is a container of SFString. It is implemented using a STL's
   * deque so you can benefit from its interface. Most common
   * functionnalities you would use are:
   \code
   MFString mf;
   mf.push_back(SFString("hello"));  // push_back("hello"); would fail since
   mf.push_front(SFString("world")); // constructor SFString(const char*) is explicit
   mf[0] = "Bye"; // Valid since SFString has operator=(const char*)
   \endcode
   * but since it uses STL principles, you have all useful concepts such as
   * iterator, algorithms, etc...
   *
   * Below is included the documentation for this field type from the ISO
   * standard.
   * \htmlinclude sfstring.html
   */
  class XDKWRL_API MFString : public std::deque<SFString>
  {
  public:
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    friend std::ostream& operator<<(std::ostream& s,const MFString& f);
  };
  //************************************************************
  // Implementation of MFString
  //************************************************************
  inline const char*
  MFString::typeName()
  {
    return "MFString";
  }
  inline FieldTypeId
  MFString::typeId()
  {
    return mfString;
  }  
}

#endif // XDKWRL_MFSTRING_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/fieldtypes")
// End:
