#ifndef XDKWRL_MFROTATION_H
#define XDKWRL_MFROTATION_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes/sfrotation.h>
#include <deque>
#include <algorithm>
#include <iterator>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  MFRotation
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   * 
   * A MFRotation is a container of SFRotation. It is implemented using a STL's
   * deque so you can benefit from its interface. Most common
   * functionnalities you would use are:
   \code
   MFRotation mf;
   mf.push_back(SFRotation(45.0f,0.0f,1.0f,0.0f));  
   mf.push_front(SFRotation(-45.0f,0.0f,1.0f,0.0f)); 
   mf[0].setAngle(60.0f);           
   \endcode
   * but since it uses STL principles, you have all useful concepts such as
   * iterator, algorithms, etc...
   *
   * Below is included the documentation for this field type from the ISO
   * standard.
   * \htmlinclude sfrotation.html
   */
  class XDKWRL_API MFRotation : public std::deque<SFRotation>
  {
  public:
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    friend std::ostream& operator<<(std::ostream& s,const MFRotation& f);
  };
  //************************************************************
  // Implementation of MFRotation
  //************************************************************
  inline const char*
  MFRotation::typeName()
  {
    return "MFRotation";
  }
  inline FieldTypeId
  MFRotation::typeId()
  {
    return mfRotation;
  }  
}

#endif // XDKWRL_MFROTATION_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/fieldtypes")
// End:
