#ifndef XDKWRL_MFNODE_H
#define XDKWRL_MFNODE_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes/sfnode.h>
#include <deque>
#include <algorithm>
#include <iterator>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  MFNode
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   * 
   * A MFNode is a container of SFNode. It is implemented using a STL's
   * deque so you can benefit from its interface. Most common
   * functionnalities you would use are:
   \code
   Transform* t = new Transform();
   // Transform has a field children of type MFNode
   Shape* s1 = new Shape();
   Shape* s2 = new Shape();
   t->children.push_back(SFNode(s1)); // push_back(s1); would fail since
   t->children.push_back(SFNode(s2)); // constructor SFNode(Node*) is explicit
   
   cout<<t->children[0]->typeName()<<endl; // echoes "Shape"
   \endcode
   * but since it uses STL principles, you have all useful concepts such as
   * iterator, algorithms, etc...
   *
   * Below is included the documentation for this field type from the ISO
   * standard.
   * \htmlinclude sfnode.html
   */
  class XDKWRL_API MFNode : public std::deque<SFNode>
  {
  public:
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    friend std::ostream& operator<<(std::ostream& s,const MFNode& f);
  };
  //************************************************************
  // Implementation of MFNode
  //************************************************************
  inline const char*
  MFNode::typeName()
  {
    return "MFNode";
  }
  inline FieldTypeId
  MFNode::typeId()
  {
    return mfNode;
  }  
}

#endif // XDKWRL_MFNODE_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/fieldtypes")
// End:
