#include <stdlib.h> 
#include "libut/ut.h"

#define MEM_TMR_INTERVAL 250
#define NUM_BUFS 1000

typedef struct ll_test_buf {
   char name[10];
   void *unused1,*unused2;

   UT_hash_handle hh;

   struct ll_test_buf *next;
} ll_test_buf;

ll_test_buf *head10=NULL,*head100=NULL,*head1000=NULL, *del100=NULL;

char names[NUM_BUFS][10];


int ll_cb( char *name, unsigned msec, char *pool) {
 int i,j;
 char *c;
 ll_test_buf *tmp,*del;

 /* lookup a random name in each of the three lists */
 j = (int)(10.0*rand()/(RAND_MAX+1.0));
 c = names[j];
 UT_prf_bgn("ll_perf","lookup-10");
 LL_FIND(head10, tmp, c);
 UT_prf_end("ll_perf","lookup-10");
 if (!tmp) UT_LOG(Error, "ll lookup failed");

 UT_prf_bgn("ll_perf","fast-lookup-10");
 HASH_FIND_STR(head10, tmp, name, c);
 UT_prf_end("ll_perf","fast-lookup-10");
 if (!tmp) UT_LOG(Error, "fast lookup failed");



 j = (int)(100.0*rand()/(RAND_MAX+1.0));
 c = names[j];
 UT_prf_bgn("ll_perf","lookup-100");
 LL_FIND(head100, tmp, c);
 UT_prf_end("ll_perf","lookup-100");
 if (!tmp) UT_LOG(Error, "ll lookup failed");

 UT_prf_bgn("ll_perf","fast-lookup-100");
 HASH_FIND_STR(head100, tmp, name, c);
 UT_prf_end("ll_perf","fast-lookup-100");
 if (!tmp) UT_LOG(Error, "fast lookup failed");



 j = (int)(1000.0*rand()/(RAND_MAX+1.0));
 c = names[j];
 UT_prf_bgn("ll_perf","lookup-1000");
 LL_FIND(head1000, tmp, c);
 UT_prf_end("ll_perf","lookup-1000");
 if (!tmp) UT_LOG(Error, "ll lookup failed");

 UT_prf_bgn("ll_perf","fast-lookup-1000");
 HASH_FIND_STR(head1000, tmp, name, c);
 UT_prf_end("ll_perf","fast-lookup-1000");
 if (!tmp) UT_LOG(Error, "ll lookup failed");

 if (del100) {
    del = del100;
    i=0;
    while (del) {
      /* UT_LOG(Debug, "Delete-list[%d]:%s",i,del->name); */
      i++;
      del=del->next; 
    } 
    /* UT_LOG(Debug, "Delete-test list has %d elements", i); */

    j = (int)(i*1.0*rand()/(RAND_MAX+1.0)); 
    /* UT_LOG(Debug, "Deleting element %d", j); */
    del = del100; 
    while (j--) del=del->next;  

    UT_prf_bgn("ll_perf","hl-del");
    HASH_DEL(del100,tmp,del); 
    UT_prf_end("ll_perf","hl-del");
 }

 return 0; /* auto-reschedule timer */
}

int main(int argc, char **argv) {
	int i,j,r;
	char scratch[5];
	ll_test_buf *tmp,*buf;

	UT_init(INIT_END);

	for(i=0;i<NUM_BUFS;i++) {
	   for (j=0;j<4;j++) {
              r = 1+(int)(25.0*rand()/(RAND_MAX+1.0));
	      scratch[j] = r + 'a';
	   }
	   scratch[j] = '\0';
	   strcpy( names[i], scratch);
	   /* UT_LOG(Debug,"Created name %s",names[i]); */
	}

	UT_mem_pool_create( "ll", sizeof(ll_test_buf), 10 );

	/* Make three linked lists: sizes 10, 100, and 1000 */
	/* To avoid cache locality alloc more than we use */
	for (i=0;i<10;i++) {
	   buf = (ll_test_buf*)UT_mem_alloc("ll", 7);
	   strcpy(buf->name,names[i]);
	   buf->next = NULL;
	   HASH_ADD_STR( head10, tmp, name, buf );
	}

	for (i=0;i<100;i++) {
	   buf = (ll_test_buf*)UT_mem_alloc("ll", 7);
	   strcpy(buf->name,names[i]);
	   buf->next = NULL;
	   HASH_ADD_STR( head100, tmp, name, buf );
	}

	for (i=0;i<1000;i++) {
	   buf = (ll_test_buf*)UT_mem_alloc("ll", 7);
	   strcpy(buf->name,names[i]);
	   buf->next = NULL;
	   HASH_ADD_STR( head1000, tmp, name, buf );
	}

	for (i=0;i<100;i++) {
	   buf = (ll_test_buf*)UT_mem_alloc("ll", 7);
	   strcpy(buf->name,names[i]);
	   buf->next = NULL;
	   HASH_ADD_STR( del100, tmp, name, buf );
	}

	UT_prf_create( "ll_perf", "Test of linked list byname-lookup", 
	            te_log_1u_10s);


	UT_tmr_set("ll_test" ,MEM_TMR_INTERVAL,(UT_tmr_cb*)ll_cb, NULL); 

	UT_event_loop();
}
