/*
Copyright (c) 2003-2005, Troy Hanson
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the copyright holder nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "config.h"

/* Mac OSX 10.2 among others lack strsignal() in the C library 
 * but does provide char*sys_siglist[] */
#if !HAVE_STRSIGNAL
#if HAVE_SYS_SIGLIST
#define strsignal(sig) sys_siglist[sig]
#else
#define strsignal(sig) "signal name unknown"
#endif
#endif

/* Mac OSX 10.2 has a sigaddset macro which shadows a function, but
 * the macro skips error checking, so we want to use the function. */
#if !SIGADDSET_DOES_ERRCHECK
#if SIGADDSET_IS_MACRO
#undef sigaddset
#endif
#endif

#define UT_JOB_DEFAULT "job1"
#define CONFIGFILE_DEFAULT "server.conf"
/* max filename length isn't easy to portably determine. See realpath(3). */
#define CONFIG_FILENAME_MAXLEN 100

int UT_first_loop_cb(void);
