/*
Copyright (c) 2003-2005, Troy Hanson
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the copyright holder nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/****************************************************************************
 * shl interface to coproc                                                  *
 * Copyright (c) 2005 Troy Hanson                                           *
 ***************************************************************************/

#include "libut/ut_internal.h"


extern UT_coprocess_global_type UT_coproc_global;


int UT_cops_shlcmd( int argc, char *argv[] ) {
   int days=0,hours=0,min=0,sec;
   UT_coprocess *coproc;
   time_t now;
   char *hdr[] = {"name                ", "pid       ", "time-elapsed ", 
                  "fd-std(i/o/e)", NULL };

   time(&now);
   UT_shl_hdr(hdr);

   for(coproc=UT_coproc_global.coprocs;coproc;coproc=coproc->next) {
      days=0,hours=0,min=0;

      sec = difftime(now,coproc->start_time);
      while (sec >= (60*60*24)) { days++;  sec -= (60*60*24); }
      while (sec >= (60*60))    { hours++; sec -= (60*60);    }
      while (sec >= (60))       { min++;   sec -= (60);       }

      UT_shlf("%-20s %-10d %3dd,%2d:%2.2d:%2.2d %5d %3d %3d\n", 
                      coproc->name, (int)coproc->pid, days, hours, min, sec, 
                      coproc->fds[0], coproc->fds[1], coproc->fds[2]);
   }
   return SHL_OK;
}

/******************************************************************************
 * UT_prf_show_usage()                                                        *
 * print usage help text                                                      *
 *****************************************************************************/
int UT_cops_show_usage(int argc,char*argv[]) {
        UT_shlf("Usage:\n");
        UT_shlf("cops                      -- view coprocesses\n");
}




int UT_coproc_init_shl(void ) {
    UT_shl_cmd_create( "cops", "List coprocesses", (UT_shlcmd *)UT_cops_shlcmd, 
                     (UT_helpcb*)UT_cops_show_usage );
    return 0;
}

