/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 * 
 * Filename:      utf8converter.cpp
 * Description:   implementation of the simple anything<->UTF-8
 *                converter based on libc's iconv
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/
#include "libtagedit/utf8converter.hpp"

int UTF8Converter::fromUTF8(const string& src, string& dest)
{
    size_t srclen = src.length();
    size_t destlen = src.length();
    dest.resize(destlen);
    string::const_iterator isrc = src.begin();
    string::iterator idest = dest.begin();
    size_t ret = iconv(_fromutf8, (char**)&isrc, &srclen, (char**)&idest, &destlen);
    if(-1 == ret)
        return -1;
    else {
        dest.resize((src.length()) - destlen);
        return 0;
    }
}

int UTF8Converter::toUTF8(const string& src, string& dest)
{
    size_t srclen = src.length();
    size_t destlen = src.length() * 3;
    dest.resize(destlen);
    string::const_iterator isrc = src.begin();
    string::iterator idest = dest.begin();
    size_t ret = iconv(_toutf8, (char**)&isrc, &srclen, (char**)&idest, &destlen);
    if(-1 == ret)
        return -1;
    else {
        dest.resize((src.length() * 3) - destlen);
        return 0;
    }
}
