/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 * 
 * Filename:      libtagedit.cpp
 * Description:   implementation external interface and
 *                the plugin loader
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/
#include "libtagedit/libtagedit.hpp"

#include <dlfcn.h>
#include <iostream>
#include <stdio.h>
#include <dirent.h>
#include <map>
#include <vector>
#include <algorithm>

map<string, TagEditor*(*)(const char*) > createFromExt;
vector<void*> handles;
string extensions;

static int getSO(const dirent *test)
{
	string e = test->d_name;
	int dot = e.find_last_of('.');
	string ext = e.substr(dot, 3);
	if(dot > -1 && e.substr(dot, 3) == ".so")
		return 1;
	else
		return 0;
}

class PluginLoader
{
public:
	PluginLoader();
	~PluginLoader();
};

// instance is created on library loading, thus we need no _init and _fini hacks
PluginLoader pl;

PluginLoader::PluginLoader()
{
    void *handle;
    PluginInterface* (*getInfo)(void);
    dirent **eps;
    int n;
        
    n = scandir(PLUGDIR, &eps, getSO, alphasort);
    if (n >= 0) {
        int cnt;
        for(cnt = 0; cnt < n; ++cnt) {
            string name = string(PLUGDIR) + string("/") + eps[cnt]->d_name;
			handle = dlopen(name.c_str(), RTLD_LAZY);
			if(!handle) {
				cerr << dlerror();
				exit(1);
			}
			getInfo = (PluginInterface*(*)(void))dlsym(handle, "getInfo");
            if(!getInfo)
                continue;
            PluginInterface* p = (*getInfo)();
			extensions += "*" + string(p->ext) + ";";
			createFromExt[string(p->ext)] = p->createClass;
			handles.push_back(handle);
            delete eps[cnt];
        }
        delete eps;
    }
}

PluginLoader::~PluginLoader()
{
    vector<void*>::iterator it = handles.begin();
    for(; it != handles.end(); ++it)
        dlclose(*it);
    
}

const string& supportedExtensions()
{
    return extensions;
}

TagEditor* createTagEditor(const char* f)
{
    string filename(f);
    int dot = filename.find_last_of('.');
    string ext = filename.substr(dot);
    transform(ext.begin(), ext.end(), ext.begin(), (int(*)(int)) tolower);
    if(dot == -1 || createFromExt.find(ext) == createFromExt.end())
        return 0;
    return (*createFromExt[ext])(f);
}
