#!/usr/bin/env python
import os
import sys
import locale
import optparse
from tageditor import createTagEditor, TagEditor, FilenameBuilder


def generateOptionParser(name, description, usagestr, versionstr):
    op = optparse.OptionParser(usage=usagestr + "\n" + description, version="%s v%s\n\n%s" % (name, versionstr, description))
    return op


format = "%Artist - %Title"
dorename = 0
locale.setlocale(locale.LC_ALL, "")

op = generateOptionParser("renbytag.py",
                          "Renaming media files by tag content",
                          "%prog [OPTIONS] file1 [file2 ...]", "0.8")
op.add_option('-r', '--rename',
              action='store_true', help='really rename files', dest="rename")
op.add_option('-f', '--format',
              action='store', help=
              """generate filenames from FORMAT, where FORMAT can 
              contain the specifiers %Artist, %Title, %Track
              %Album, %Year, %Genre und %Comment, which will
              be substitutereally rename files""",
              dest="format")

options, args = op.parse_args(sys.argv[1:])

if options.format:
    format = options.format


if not args:
    print "Error: no files given"
    sys.exit(-1)

enc = sys.getfilesystemencoding()

builder = FilenameBuilder(format)
for a in args:
    tag = createTagEditor(a)
    if not tag or not tag.isOK():
        continue
    new = builder.fromTag(tag)
    try:
        print "\"%s\" --> \"%s\"" % (a, new)
    except:
        pass
    if options.rename:
        os.rename(a, new.encode(enc))
if not options.rename:
    print "\n\n   ***no files were renamed (use -r)***"
