#!/usr/bin/env python
import sys
import locale
from tageditor import *


if len(sys.argv) == 1:
    print "missing arguments!"
    sys.exit(-1)

locale.setlocale(locale.LC_ALL, "")
for i in sys.argv[1:]:
    tag = createTagEditor(i)
    if not tag or not tag.isOK():
        continue
    ff = tag.fieldnames()
    print "File    : %s" % tag.filename()
    for f in ff:
        print "%-8s: %s" % (f, tag[f])
    print "Length  : %i:%02i" % divmod(tag.length(), 60)
    print "Bitrate : %i\n" % tag.bitrate()
    
    
