#!/usr/bin/env python
##   createm3u.py -- create m3u playlists from media files
##   Copyright (C) 2002 Torsten Marek <shlomme@gmx.net>
##  
##   This program is free software; you can redistribute it and/or modify
##   it under the terms of the GNU General Public License as published by
##   the Free Software Foundation; either version 2 of the License, or
##   (at your option) any later version.
##  
##   This program is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY; without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##   GNU General Public License for more details.
##   You should have received a copy of the GNU General Public License
##   along with this program; if not, write to the Free Software
##   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
import os
import sys
import optparse
from tageditor import createM3U

def generateOptionParser(name, description, usagestr, versionstr):
    op = optparse.OptionParser(usage=usagestr + "\n" + description,
                               version="%s v%s\n\n%s" % (name, versionstr,
                                                         description))
    return op

op = generateOptionParser(sys.argv[0],
                          "create m3u playlists from music songs",
                          "%prog dir1 [dir2 ...]",
                          "0.1")
options, args = op.parse_args(sys.argv[1:])
if not len(args):
    print "Error: no dirs given"
    sys.exit(-1)
for p in args:
    path = os.path.abspath(p)
    files = []
    if os.path.isdir(path):
        files += [os.path.join(path, f) for f in os.listdir(path)]
    createM3U(files, "playlist")
