#!/usr/bin/env python
import os
import sys
import shutil
import py_compile
import optparse

try:
    import sipconfig
except ImportError:
    print "Could not determine the configuration of sip. Please install it."
    sys.exit()


def generate_code(mname, imports=None, extra_cflags=None, extra_cxxflags=None, extra_define=None, extra_include_dir=None, extra_lflags=None, extra_lib_dir=None, extra_lib=None, sip_flags=None):
    """Generate the code for a module.

    mname is the name of the module.
    imports is the list of PyQt modules that this one %Imports.
    extra_cflags is a string containing additional C compiler flags.
    extra_cxxflags is a string containing additional C++ compiler flags.
    extra_define is a name to add to the list of preprocessor defines.
    extra_include_dir is the name of a directory to add to the list of include
    directories.
    extra_lflags is a string containing additional linker flags.
    extra_lib_dir is the name of a directory to add to the list of library
    directories.
    extra_lib is the name of an extra library to add to the list of libraries.
    sip_flags is the list of sip flags to use instead of the defaults.
    """
    global options
    sipconfig.inform("Generating the C++ source for the %s module..." % mname)

    try:
        shutil.rmtree(mname)
    except OSError, e:
        pass

    try:
        os.mkdir(mname)
    except IOError, e:
        sipconfig.error("Unable to create directory %s." % mname)

    # Build the SIP command line.
    argv = [options.sip_bin]

    #argv.append("-r")
    argv.append("-c")
    argv.append(mname)

    buildfile = os.path.join(mname, mname + ".sbf")
    argv.append("-b")
    argv.append(buildfile)

    argv.append("-I")
    argv.append("sip")

    # SIP assumes POSIX style path separators.
    argv.append(mname + ".sip")

    os.system(" ".join(argv))

    # Check the result.
    if not os.access(buildfile, os.F_OK):
        sipconfig.error("Unable to create the C++ code.")

    # Generate the Makefile.
    sipconfig.inform("Creating the Makefile for the %s module..." % mname)


    warnings = 1

    makefile = sipconfig.SIPModuleMakefile(
        configuration=sipcfg,
        build_file=mname + ".sbf",
        dir=mname,
        install_dir=options.site_dir,
        warnings=warnings,
    )
    makefile.extra_libs.append("tagedit")

    if not os.access("../include/libtagedit/libtagedit.hpp", os.F_OK):
        print \
"""Could not locate libtagedit sources. If building the sources fails, please specify
the position of the library and the headers."""
    else:
        makefile.extra_lib_dirs.append("../../src/.libs")
        makefile.extra_include_dirs.append("../../include")

    if extra_cxxflags:
        makefile.extra_cxxflags.append(extra_cxxflags)

    if extra_define:
        makefile.extra_defines.append(extra_define)

    if extra_include_dir:
        makefile.extra_include_dirs.append(extra_include_dir)

    if extra_lflags:
        makefile.extra_lflags.append(extra_lflags)

    if extra_lib_dir:
        makefile.extra_lib_dirs.append(extra_lib_dir)

    if extra_lib:
        makefile.extra_libs.append(extra_lib)

    makefile.generate()


sipcfg = sipconfig.Configuration()

cmdline = optparse.OptionParser(usage="test\n")

cmdline.add_option("-d", "--site", dest="site_dir",
                   help="the directory for Python extension modules",
                   default=sipcfg.default_mod_dir)
cmdline.add_option("-s", "--sip", dest="sip_bin",
                   help="the location of the sip binary",
                   default=sipcfg.sip_bin)
cmdline.add_option("-l", "--libdir", dest="libdir",
                   help="directory where libtagedit is installed")
cmdline.add_option("-i", "--include", dest="incdir",
                   help="directory where libtagedit headers are installed")

options, args = cmdline.parse_args()

libdir = []
incdir = []
if options.libdir:
    libdir.append(options.libdir)
if options.incdir:
    incdir.append(options.incdir)

generate_code("_tageditor", extra_lib_dir=libdir, extra_include_dir=incdir)
sipconfig.inform("Creating top level Makefile...")

# compile python module
py_compile.compile(os.path.abspath("tageditor.py"), os.path.abspath("tageditor.pyc"))

mkfile = sipconfig.ParentMakefile(
    configuration = sipcfg,
    subdirs = ["_tageditor"],
    installs = (["tageditor.py", "tageditor.pyc"], options.site_dir))
mkfile.generate()

