/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 * 
 * Filename:      oggtag.hpp
 * Description:   definition of the Ogg Vorbis tageditor class
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/

#ifndef OGGTAG_HPP
#define OGGTAG_HPP

#include <stdio.h>
#include <ogg/ogg.h>
#include <vorbis/codec.h>

#include "vorbisComment/vcomment.hpp"

class oggTag: public vorbisComment
{
public:
	oggTag(const char*);
	~oggTag();
    // get extension
    string extension() const 
    {
        return string("ogg");
    }
	int writeTag();
private:
    int _blocksize(ogg_packet*);
	int _fetch_next_packet(ogg_packet*);
	void clearInternals();
	int readOggTag();
	int writeOggTag();
    
	ogg_sync_state		*oy;
	ogg_stream_state	*os;

	vorbis_comment		*vc;
	vorbis_info          vi;

	FILE *in, *out;
	int prevW;
	ogg_stream_state streamout;
};

#define CHUNKSIZE 4096

#endif // OGGTAG_HPP

