/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 * 
 * Filename:      vcomment.hpp
 * Description:   definition of vorbisComment, base class for both
 *                oggTag and flacTag. Inherits TagEditor interface
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/
#ifndef VCOMMENT_HPP
#define VCOMMENT_HPP

#include "libtagedit/tageditor.hpp"
#include <string>
#include <map>

class vorbisComment: public TagEditor
{
public:
	vorbisComment(const char*);
	virtual ~vorbisComment();
    int setField(FieldID, const string&);
    string getField(FieldID) const;
	int removeField(FieldID);
	bool fieldExists(FieldID ID) const;
protected:
	string translateID(FieldID) const;
	map<string, string> comments;
    static string empty;
};

#endif //VCOMMENT_HPP
