/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 *	 Parts of the code are taken from the xmms mgp123-Plugin by Espen Skoglund
 *   
 * 
 * Filename:      id3frames.hpp
 * Description:   definition of the frame classes used in the id3Tag class
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/

#ifndef ID3FRAMES_HPP
#define ID3FRAMES_HPP

#include <map>
#include <string>
#include "id3base.hpp"
#include "libtagedit/utf8converter.hpp"
#include "framedesc.hpp"

// Frameheader-Flags
enum framehdrFlags {	
	ID3_FHFLAG_TAGALT   = 0x8000,
	ID3_FHFLAG_FILEALT  = 0x4000,
	ID3_FHFLAG_RO       = 0x2000,
	ID3_FHFLAG_COMPRESS	= 0x0080,
	ID3_FHFLAG_ENCRYPT  = 0x0040,
	ID3_FHFLAG_GROUP    = 0x0020
};

class id3Frame 
{
public:
	id3Frame(ID3FrameID);
	id3Frame(ID3FrameID, id3_framehdr_t*);
	virtual ~id3Frame()
	{
	}
	void fillHeader(id3_framehdr_t*);
	size_t getSizeInFile()
	{
		return fr_size;
	}
    // getSize should do any necessary mods to fr_data, so that 
	virtual size_t getSize();
    // getData can savely return fr_data.c_str()
	virtual const char* getData();
	virtual void setData(const char*);
	virtual const string& getContent();
	virtual void setContent(const string& s)
    {
        fr_content = s;
    }
	const id3Framedesc* getDescr()
	{
		return fr_desc;
	}
    static void setConverter(UTF8Converter*);
    unsigned char encoding() const
    {
        return fr_encoding;
    }
protected:
    virtual void prepareData()
    {
        fr_data.assign(fr_content);
    }
	unsigned int offset;
    // data for use with writeTag
    string fr_data;
    // data for use with application
    string fr_content;
    string fr_converted;
	const id3Framedesc* fr_desc;
    static UTF8Converter* uniconv;
	short unsigned int fr_flags;
	unsigned int fr_size;
	unsigned char fr_encoding;
};


class commentFrame: public id3Frame
{
public:
	commentFrame():  id3Frame(ID3_COMM)
	{
		offset = 5;
	}
	commentFrame(id3_framehdr_t* hdr): id3Frame(ID3_COMM, hdr)
	{
		offset = 5;
	}
};

class contentFrame: public id3Frame 
{
public:
	contentFrame(): id3Frame(ID3_TCON)
	{
	}
	contentFrame(id3_framehdr_t* hdr): id3Frame(ID3_TCON, hdr)
	{
	}
    void setData(const char*);
	void setContent(const string& s)
	{
        fr_content = expandContent(s);
	}
    void prepareData();
	string expandContent(const string&);
};

typedef map<ID3FrameID, id3Frame*> FRAMEMAP;

#endif //ID3FRAMES_HPP
