/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 *	 Parts of the code are taken from the xmms mgp123-Plugin by Espen Skoglund
 *   
 * 
 * Filename:      framedesc.cpp
 * Description:   implementation of the frame descriptor class
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/
#include "libtagedit/tageditor.hpp"
#include "framedesc.hpp"

frameDesc frdesc;

char* frameDesc::id3Genres[] =	{
	"Blues", "Classic Rock", "Country", "Dance",
	"Disco", "Funk", "Grunge", "Hip-Hop",
	"Jazz", "Metal", "New Age", "Oldies",
	"Other", "Pop", "R&B", "Rap", "Reggae",
	"Rock", "Techno", "Industrial", "Alternative",
	"Ska", "Death Metal", "Pranks", "Soundtrack",
	"Euro-Techno", "Ambient", "Trip-Hop", "Vocal",
	"Jazz+Funk", "Fusion", "Trance", "Classical",
	"Instrumental", "Acid", "House", "Game",
	"Sound Clip", "Gospel", "Noise", "Alt",
	"Bass", "Soul", "Punk", "Space",
	"Meditative", "Instrumental Pop",
	"Instrumental Rock", "Ethnic", "Gothic",
	"Darkwave", "Techno-Industrial", "Electronic",
	"Pop-Folk", "Eurodance", "Dream",
	"Southern Rock", "Comedy", "Cult",
	"Gangsta Rap", "Top 40", "Christian Rap",
	"Pop/Funk", "Jungle", "Native American",
	"Cabaret", "New Wave", "Psychedelic", "Rave",
	"Showtunes", "Trailer", "Lo-Fi", "Tribal",
	"Acid Punk", "Acid Jazz", "Polka", "Retro",
	"Musical", "Rock & Roll", "Hard Rock", "Folk",
	"Folk/Rock", "National Folk", "Swing",
	"Fast-Fusion", "Bebob", "Latin", "Revival",
	"Celtic", "Bluegrass", "Avantgarde",
	"Gothic Rock", "Progressive Rock",
	"Psychedelic Rock", "Symphonic Rock", "Slow Rock",
	"Big Band", "Chorus", "Easy Listening",
	"Acoustic", "Humour", "Speech", "Chanson",
	"Opera", "Chamber Music", "Sonata", "Symphony",
	"Booty Bass", "Primus", "Porn Groove",
	"Satire", "Slow Jam", "Club", "Tango",
	"Samba", "Folklore", "Ballad", "Power Ballad",
	"Rhythmic Soul", "Freestyle", "Duet",
	"Punk Rock", "Drum Solo", "A Cappella",
	"Euro-House", "Dance Hall", "Goa",
	"Drum & Bass", "Club-House", "Hardcore",
	"Terror", "Indie", "BritPop", "Negerpunk",
	"Polsk Punk", "Beat", "Christian Gangsta Rap",
	"Heavy Metal", "Black Metal", "Crossover",
	"Contemporary Christian", "Christian Rock",
	"Merengue", "Salsa", "Thrash Metal",
	"Anime", "JPop", "Synthpop"
};

frameDesc::frameDesc()
{
	f(ID3_AENC, "AENC", "Audio encryption");
    f(ID3_APIC, "APIC", "Attached picture");

    f(ID3_COMM, "COMM", "Comments" );
    f(ID3_COMR, "COMR", "Commercial frame" );

    f(ID3_ENCR, "ENCR", "Encryption method registration" );
    f(ID3_EQUA, "EQUA", "Equalization" );
    f(ID3_ETCO, "ETCO", "Event timing codes" );

    f(ID3_GEOB, "GEOB", "General encapsulated object" );
    f(ID3_GRID, "GRID", "Group identification registration" );

    f(ID3_IPLS, "IPLS", "Involved people list" );

    f(ID3_LINK, "LINK", "Linked information" );

    f(ID3_MCDI, "MCDI", "Music CD identifier" );
    f(ID3_MLLT, "MLLT", "MPEG location lookup table" );

    f(ID3_OWNE, "OWNE", "Ownership frame" );

    f(ID3_PRIV, "PRIV", "Private frame" );
    f(ID3_PCNT, "PCNT", "Play counter" );
    f(ID3_POPM, "POPM", "Popularimeter" );
    f(ID3_POSS, "POSS", "Position synchronisation frame" );

    f(ID3_RBUF, "RBUF", "Recommended buffer size" );
    f(ID3_RVAD, "RVAD", "Relative volume adjustment" );
    f(ID3_RVRB, "RVRB", "Reverb" );

    f(ID3_SYLT, "SYLT", "Synchronized lyric/text" );
    f(ID3_SYTC, "SYTC", "Synchronized tempo codes" );

    f(ID3_TALB, "TALB", "Album/Movie/Show title" );
    f(ID3_TBPM, "TBPM", "BPM (beats per minute)" );
    f(ID3_TCOM, "TCOM", "Composer" );
    f(ID3_TCON, "TCON", "Content type" );
    f(ID3_TCOP, "TCOP", "Copyright message" );
    f(ID3_TDAT, "TDAT", "Date" );
    f(ID3_TDLY, "TDLY", "Playlist delay" );
    f(ID3_TENC, "TENC", "Encoded by" );
    f(ID3_TEXT, "TEXT", "Lyricist/Text writer" );
    f(ID3_TFLT, "TFLT", "File type" );
    f(ID3_TIME, "TIME", "Time" );
    f(ID3_TIT1, "TIT1", "Content group description" );
    f(ID3_TIT2, "TIT2", "Title/songname/content description" );
    f(ID3_TIT3, "TIT3", "Subtitle/Description refinement" );
    f(ID3_TKEY, "TKEY", "Initial key" );
    f(ID3_TLAN, "TLAN", "Language(s)" );
    f(ID3_TLEN, "TLEN", "Length" );
    f(ID3_TMED, "TMED", "Media type" );
    f(ID3_TOAL, "TOAL", "Original album/movie/show title" );
    f(ID3_TOFN, "TOFN", "Original filename" );
    f(ID3_TOLY, "TOLY", "Original lyricist(s)/text writer(s)" );
    f(ID3_TOPE, "TOPE", "Original artist(s)/performer(s)" );
    f(ID3_TORY, "TORY", "Original release year" );
    f(ID3_TOWN, "TOWN", "File owner/licensee" );
    f(ID3_TPE1, "TPE1", "Lead performer(s)/Soloist(s)" );
    f(ID3_TPE2, "TPE2", "Band/orchestra/accompaniment" );
    f(ID3_TPE3, "TPE3", "Conductor/performer refinement" );
    f(ID3_TPE4, "TPE4", "Interpreted, remixed, or otherwise modified by" );
    f(ID3_TPOS, "TPOS", "Part of a set" );
    f(ID3_TPUB, "TPUB", "Publisher" );
    f(ID3_TRCK, "TRCK", "Track number/Position in set" );
    f(ID3_TRDA, "TRDA", "Recording dates" );
    f(ID3_TRSN, "TRSN", "Internet radio station name" );
    f(ID3_TRSO, "TRSO", "Internet radio station owner" );
    f(ID3_TSIZ, "TSIZ", "Size" );
    f(ID3_TSRC, "TSRC", "ISRC (international standard recording code)" );
    f(ID3_TSSE, "TSSE", "Software/Hardware and settings used for encoding" );
    f(ID3_TYER, "TYER", "Year");
    f(ID3_TXXX, "TXXX", "User defined text information frame" );

    f(ID3_UFID, "UFID", "Unique file identifier" );
    f(ID3_USER, "USER", "Terms of use" );
    f(ID3_USLT, "USLT", "Unsychronized lyric/text transcription" );

    f(ID3_WCOM, "WCOM", "Commercial information" );
    f(ID3_WCOP, "WCOP", "Copyright/Legal information" );
    f(ID3_WOAF, "WOAF", "Official audio file webpage" );
    f(ID3_WOAR, "WOAR", "Official artist/performer webpage" );
    f(ID3_WOAS, "WOAS", "Official audio source webpage");
    f(ID3_WORS, "WORS", "Official internet radio station homepage");
    f(ID3_WPAY, "WPAY", "Payment" );
    f(ID3_WPUB, "WPUB", "Publishers official webpage");
    f(ID3_WXXX, "WXXX", "User defined URL link frame");

    f(ID3_ASPI, "ASPI", "");
    f(ID3_EQU2, "EQU2", "");
    f(ID3_RVA2, "RVA2", "");
    f(ID3_SEEK, "SEEK", "");
    f(ID3_SIGN, "SIGN", "");
    f(ID3_TDEN, "TDEN", "");
    f(ID3_TDOR, "TDOR", "");
    f(ID3_TDRC, "TDRC", "");
    f(ID3_TDRL, "TDRL", "");
    f(ID3_TDTG, "TDTG", "");
    f(ID3_TIPL, "TIPL", "");
    f(ID3_TMCL, "TMCL", "");
    f(ID3_TMOO, "TMOO", "");
    f(ID3_TPRO, "TPRO", "");
    f(ID3_TSOA, "TSOA", "");
    f(ID3_TSOP, "TSOP", "");
    f(ID3_TSOT, "TSOT", "");
    f(ID3_TSST, "TSST", "");
}

void frameDesc::f(ID3FrameID ID, char* abbr, char* descr) 
{
    descmap[ID].fd_id = ID;
	descmap[ID].fd_description = descr;
    strncpy(descmap[ID].fd_idstr, abbr, 4);
}

size_t frameDesc::numGenres() 
{
	return sizeof(id3Genres) / sizeof(char*);
}

ID3FrameID frameDesc::translateField(FieldID ID)
{
	switch(ID) {
	case Artist:
		return ID3_TPE1;
	case Title:
		return ID3_TIT2;
	case Album:
		return ID3_TALB;
	case Year:
		return ID3_TDRC;
	case Track:
		return ID3_TRCK;
	case Genre:
		return ID3_TCON;
	case Comment:
		return ID3_COMM;
	}
	return (ID3FrameID)0;
}
