/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 * 
 * Filename:      flac_if.cpp
 * Description:   libtagedit plugin interface for FLAC
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/
#include "flactag.hpp"
#include "libtagedit/libtagedit.hpp"

extern "C" {
	static TagEditor* createFlacEditor(const char*);
	PluginInterface flac = {
		".flac",
		createFlacEditor
	};

	PluginInterface* getInfo() 
	{
		return &flac;
	}
	static TagEditor* createFlacEditor(const char* filename)
	{
		return new flacTag(filename);
	}
}
