/* sock.h
 * - General Socket Function Headers
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __LIBSHOUT_SOCK_H
#define __LIBSHOUT_SOCK_H

#ifdef _WIN32
#include <winsock.h>
#else
typedef int SOCKET;
#endif

#ifndef _WIN32
#define INVALID_SOCKET -1
#define SOCKET_ERROR -1
#endif

#define SOCK_BLOCK 0
#define SOCK_NONBLOCK 1

/* sock connect macro */
#define sock_connect(h, p) sock_connect_wto(h, p, 0)

/* Misc socket functions */
int sock_recoverable(int error);
int sock_valid_socket(SOCKET sock);
int sock_set_blocking(SOCKET sockfd, const int block);
int sock_close(SOCKET sockfd);

/* Connection related socket functions */
SOCKET sock_connect_wto(const char *hostname, const int port, const int timeout);

/* Socket write functions */
int sock_write_bytes(SOCKET sockfd, const char *buff, const int len);
int sock_write(SOCKET sockfd, const char *fmt, ...);
int sock_write_string(SOCKET sokfd, const char *buff);

/* Socket read functions */
int sock_read_line(SOCKET sockfd, char *string, const int len);

#ifdef _WIN32
int inet_aton(const char *s, struct in_addr *a);
#endif

#endif
