///  @file    TestValidASTNode.cs
///  @brief   Test the isWellFormedASTNode function
///  @author  Frank Bergmann (Csharp conversion)
///  @author  Akiya Jouraku (Csharp conversion)
///  @author  Sarah Keating 
///  
///  ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
/// 
///  DO NOT EDIT THIS FILE.
/// 
///  This file was generated automatically by converting the file located at
///  src/sbml/test/TestValidASTNode.cpp
///  using the conversion program dev/utilities/translateTests/translateTests.pl.
///  Any changes made here will be lost the next time the file is regenerated.
/// 
///  -----------------------------------------------------------------------------
///  This file is part of libSBML.  Please visit http://sbml.org for more
///  information about SBML, and the latest version of libSBML.
/// 
///  Copyright 2005-2010 California Institute of Technology.
///  Copyright 2002-2005 California Institute of Technology and
///                      Japan Science and Technology Corporation.
///  
///  This library is free software; you can redistribute it and/or modify it
///  under the terms of the GNU Lesser General Public License as published by
///  the Free Software Foundation.  A copy of the license agreement is provided
///  in the file named "LICENSE.txt" included with this software distribution
///  and also available online as http://sbml.org/software/libsbml/license.html
///  -----------------------------------------------------------------------------


namespace LibSBMLCSTest.math {

  using libsbmlcs;

  using System;

  using System.IO;

  public class TestValidASTNode {
    public class AssertionError : System.Exception 
    {
      public AssertionError() : base()
      {
        
      }
    }


    static void assertTrue(bool condition)
    {
      if (condition == true)
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertEquals(object a, object b)
    {
      if ( (a == null) && (b == null) )
      {
        return;
      }
      else if ( (a == null) || (b == null) )
      {
        throw new AssertionError();
      }
      else if (a.Equals(b))
      {
        return;
      }
  
      throw new AssertionError();
    }

    static void assertNotEquals(object a, object b)
    {
      if ( (a == null) && (b == null) )
      {
        throw new AssertionError();
      }
      else if ( (a == null) || (b == null) )
      {
        return;
      }
      else if (a.Equals(b))
      {
        throw new AssertionError();
      }
    }

    static void assertEquals(bool a, bool b)
    {
      if ( a == b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertNotEquals(bool a, bool b)
    {
      if ( a != b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertEquals(int a, int b)
    {
      if ( a == b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertNotEquals(int a, int b)
    {
      if ( a != b )
      {
        return;
      }
      throw new AssertionError();
    }


    public void test_ValidASTNode_Name()
    {
      ASTNode n = libsbml.parseFormula("c");
      assertEquals( true, n.isWellFormedASTNode() );
      ASTNode d = libsbml.parseFormula("d");
      n.addChild(d);
      assertEquals( false, (n.isWellFormedASTNode()) );
      n = null;
    }

    public void test_ValidASTNode_Number()
    {
      ASTNode n = libsbml.parseFormula("1.2");
      assertEquals( true, n.isWellFormedASTNode() );
      ASTNode d = libsbml.parseFormula("d");
      n.addChild(d);
      assertEquals( false, (n.isWellFormedASTNode()) );
      n = null;
    }

    public void test_ValidASTNode_binary()
    {
      ASTNode n = new ASTNode(libsbml.AST_DIVIDE);
      assertEquals( false, (n.isWellFormedASTNode()) );
      ASTNode c = libsbml.parseFormula("c");
      n.addChild(c);
      assertEquals( false, (n.isWellFormedASTNode()) );
      ASTNode d = libsbml.parseFormula("d");
      n.addChild(d);
      assertEquals( true, n.isWellFormedASTNode() );
      n = null;
    }

    public void test_ValidASTNode_infix_nary_plus0()
    {
      ASTNode n = libsbml.readMathMLFromString("<math xmlns='http://www.w3.org/1998/Math/MathML'>" + 
    "  <apply>" + 
    "    <plus/>" + 
    "  </apply>" + 
    "</math>");
      assertTrue( n != null );
      string formula = libsbml.formulaToString(n);
      ASTNode node = libsbml.parseFormula(formula);
      assertTrue( node != null );
      n = null;
      node = null;
    }

    public void test_ValidASTNode_infix_nary_plus1()
    {
      ASTNode n = libsbml.readMathMLFromString("<math xmlns='http://www.w3.org/1998/Math/MathML'>" + 
    "  <apply>" + 
    "    <plus/>" + 
    "    <cn> 0 </cn>" + 
    "  </apply>" + 
    "</math>");
      assertTrue( n != null );
      string formula = libsbml.formulaToString(n);
      ASTNode node = libsbml.parseFormula(formula);
      assertTrue( node != null );
      n = null;
      node = null;
    }

    public void test_ValidASTNode_infix_nary_times0()
    {
      ASTNode n = libsbml.readMathMLFromString("<math xmlns='http://www.w3.org/1998/Math/MathML'>" + 
    "  <apply>" + 
    "    <times/>" + 
    "  </apply>" + 
    "</math>");
      assertTrue( n != null );
      string formula = libsbml.formulaToString(n);
      ASTNode node = libsbml.parseFormula(formula);
      assertTrue( node != null );
      n = null;
      node = null;
    }

    public void test_ValidASTNode_infix_nary_times1()
    {
      ASTNode n = libsbml.readMathMLFromString("<math xmlns='http://www.w3.org/1998/Math/MathML'>" + 
    "  <apply>" + 
    "    <times/>" + 
    "    <cn> 0 </cn>" + 
    "  </apply>" + 
    "</math>");
      assertTrue( n != null );
      string formula = libsbml.formulaToString(n);
      ASTNode node = libsbml.parseFormula(formula);
      assertTrue( node != null );
      n = null;
      node = null;
    }

    public void test_ValidASTNode_lambda()
    {
      ASTNode n = new ASTNode(libsbml.AST_LAMBDA);
      assertEquals( false, (n.isWellFormedASTNode()) );
      ASTNode c = libsbml.parseFormula("c");
      n.addChild(c);
      assertEquals( true, n.isWellFormedASTNode() );
      ASTNode d = libsbml.parseFormula("d");
      n.addChild(d);
      assertEquals( true, n.isWellFormedASTNode() );
      ASTNode e = libsbml.parseFormula("e");
      n.addChild(e);
      assertEquals( true, n.isWellFormedASTNode() );
      n = null;
    }

    public void test_ValidASTNode_nary()
    {
      ASTNode n = new ASTNode(libsbml.AST_DIVIDE);
      assertEquals( false, (n.isWellFormedASTNode()) );
      ASTNode c = libsbml.parseFormula("c");
      n.addChild(c.deepCopy());
      assertEquals( false, (n.isWellFormedASTNode()) );
      n.addChild(c.deepCopy());
      assertEquals( true, (n.isWellFormedASTNode()) );
      n.addChild(c.deepCopy());
      assertEquals( false, (n.isWellFormedASTNode()) );
      n = new ASTNode(libsbml.AST_TIMES);
      assertEquals( true, (n.isWellFormedASTNode()) );
      n.addChild(c);
      assertEquals( true, (n.isWellFormedASTNode()) );
      ASTNode d = libsbml.parseFormula("d");
      n.addChild(d);
      assertEquals( true, n.isWellFormedASTNode() );
      ASTNode e = libsbml.parseFormula("e");
      n.addChild(e);
      assertEquals( true, n.isWellFormedASTNode() );
      n = null;
    }

    public void test_ValidASTNode_returnsBoolean()
    {
      ASTNode node = new ASTNode ( libsbml.AST_LOGICAL_AND );
      assertEquals( true, node.returnsBoolean() );
      node.setType(libsbml.AST_LOGICAL_NOT);
      assertEquals( true, node.returnsBoolean() );
      node.setType(libsbml.AST_LOGICAL_OR);
      assertEquals( true, node.returnsBoolean() );
      node.setType(libsbml.AST_LOGICAL_XOR);
      assertEquals( true, node.returnsBoolean() );
      node.setType(libsbml.AST_FUNCTION_PIECEWISE);
      assertEquals( true, node.returnsBoolean() );
      node.setType(libsbml.AST_RELATIONAL_EQ);
      assertEquals( true, node.returnsBoolean() );
      node.setType(libsbml.AST_RELATIONAL_GEQ);
      assertEquals( true, node.returnsBoolean() );
      node.setType(libsbml.AST_RELATIONAL_GT);
      assertEquals( true, node.returnsBoolean() );
      node.setType(libsbml.AST_RELATIONAL_LEQ);
      assertEquals( true, node.returnsBoolean() );
      node.setType(libsbml.AST_RELATIONAL_LT);
      assertEquals( true, node.returnsBoolean() );
      node.setType(libsbml.AST_RELATIONAL_NEQ);
      assertEquals( true, node.returnsBoolean() );
      node.setType(libsbml.AST_CONSTANT_TRUE);
      assertEquals( true, node.returnsBoolean() );
      node.setType(libsbml.AST_CONSTANT_FALSE);
      assertEquals( true, node.returnsBoolean() );
    }

    public void test_ValidASTNode_root()
    {
      ASTNode n = new ASTNode(libsbml.AST_FUNCTION_ROOT);
      assertEquals( false, (n.isWellFormedASTNode()) );
      ASTNode c = libsbml.parseFormula("c");
      n.addChild(c);
      assertEquals( true, n.isWellFormedASTNode() );
      ASTNode d = libsbml.parseFormula("3");
      n.addChild(d);
      assertEquals( true, n.isWellFormedASTNode() );
      ASTNode e = libsbml.parseFormula("3");
      n.addChild(e);
      assertEquals( false, (n.isWellFormedASTNode()) );
      n = null;
    }

    public void test_ValidASTNode_setType()
    {
      ASTNode n = new ASTNode();
      int i = n.setType(libsbml.AST_REAL);
      assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
      assertTrue( n.getType() == libsbml.AST_REAL );
      i = n.setType(libsbml.AST_PLUS);
      assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
      assertTrue( n.getType() == libsbml.AST_PLUS );
      assertTrue( n.getCharacter() ==  '+'  );
      i = n.setType(libsbml.AST_FUNCTION_ARCCOSH);
      assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
      assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCCOSH );
      i = n.setType(libsbml.AST_UNKNOWN);
      assertTrue( i == libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE );
      assertTrue( n.getType() == libsbml.AST_UNKNOWN );
      n = null;
    }

    public void test_ValidASTNode_unary()
    {
      ASTNode n = new ASTNode(libsbml.AST_FUNCTION_ABS);
      assertEquals( false, (n.isWellFormedASTNode()) );
      ASTNode c = libsbml.parseFormula("c");
      n.addChild(c);
      assertEquals( true, n.isWellFormedASTNode() );
      ASTNode d = libsbml.parseFormula("d");
      n.addChild(d);
      assertEquals( false, (n.isWellFormedASTNode()) );
      n = null;
    }

  }
}
