/*
 * stdinc.h: useful includes and debugging utilities
 * Copyright (c) Peter Bozarov, peter@bozz.demon.nl
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Peter Bozarov.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * $Id: stdinc.h,v 1.12 2002/10/03 06:24:54 kingofgib Exp $
 */

/*
 * Include this file and get the following:
 *	. STDWin32 is defined on Windows.
 *	. STDLinux is define on Linux
 *	. STDFreeBSD is defined on FreeBSD
 * 	. STDOpenBSD is defined on OpenBSD
 * 	. STDNetBSD is defined on NetBSD
 *	. STDBSDClone is defined on *BSD
 *	. STDSunOS is defined on Generic SunOS
 *	. STDAix is defined on AIX,
 * 	. STDOsf is defined on OSF (Tru64),
 *	. STDUnix is defined on any UNIX
 *
 *	If USING_GLUT is defined prior to loading this file, then
 *	the appropriate GLUT header files are also included.
 *
 *	Logging of variables, which can be useful is supported through
 *	the use of the *LOG macros below:
 *	e.g. a line like LLOG(t) in a "main.c" and on line 179
 *	results in the following output:
 *	    main.c,179: (long)t = 2
 *	This is assuming that t is a long. Else results can be undefined.
 *	There's a similar macro for most data types.
 *
 *	The logging macros are only enabled if the following is in the
 *	code:
 *	# define DBG(x)		x
 *
 *	The macros are empty if the following is found in the code
 *	# define DBG(x)
 *
 *	It is therefore possible to enable and disable the macros on the 
 *	fly in any file by setting DBG(x) in certain sections of the code
 *	only, and turning it off in other sections. Alternatively, use 
 * 	the two accompanying files, dbgon.h and dbgoff.h: any code found
 *	between a matching <dbgon.h>-<dbgoff.h> pair, will have the debug
 *	macros enabled. A missing dbgoff.h will mean that the rest of the
 *	file is in debug ON mode.
 *	
 *	Three memory allocation macros are also defined:
 *	STDMALLOC(p,size,ret_val)	will try to allocate size bytes
 *	to pointer p, and if that fails, will call "return ret_val;"
 *	STDREALLOC(p,size,ret_val)	guess it
 *	STDFREE(p)			same as free( (void*) p)
 *
 *	Have fun with this. Let me know if this is of any use to anyone
 *
 *	Fri Dec 21 18:19:22 CET 2001
 */
# ifndef _StandardInclude_	/** { **/
# define _StandardInclude_



/* Platform specific stuff */
# if defined _WIN32 		/** { **/

# 	define STDWin32
/* # 	include <windows.h> */
# 	ifdef __inline__
# 	undef __inline__
# 	endif
#	define __inline__	__inline
# elif defined __linux__
# 	define STDLinux
# 	define STDUnix
# elif defined __FreeBSD__
# 	define STDFreeBSD
#	define STDBSDClone
# 	define STDUnix
# elif defined __OpenBSD__
# 	define STDOpenBSD
#	define STDBSDClone
# 	define STDUnix
# elif defined __NetBSD__
# 	define STDNetBSD
#	define STDBSDClone
# 	define STDUnix
# elif defined sun
# 	define STDSunOS
# 	define STDUnix
# elif defined _AIX
# 	define STDAix
# 	define STDUnix
# elif defined (__OSF__) || defined (__osf__)
# 	define STDOsf
# 	define STDUnix

# endif /* WIN32 } */

# if defined (__unix__)
# 	define STDUnix
# elif ! defined __NetBSD__
#  if defined (unix)
#       define STDUnix
#  endif
# endif

# ifdef WIN32
/* # 	include <windows.h> */
# endif

# ifdef USING_GLUT
# 	include <GL/gl.h>
# 	include <GL/glu.h>
# 	include <GL/glut.h>
# endif

/* Standard include files which we might need */
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <math.h>

# include <errno.h>
# define SYSERR()	strerror(errno)

# define DBG(x)

/* Argument processing */
# ifdef XP
# undef XP
# endif

# ifdef __STDC__
#	define XP(x)		x
# else
#	define XP(x)		()
# endif	/* __STDC__ */

/*----------------------------------------------------------------------*/
/* Complex logging support						*/
/*									*/
/* If you want to use a specific logging function (the standard one is	*/
/* fprintf(stdout,...), then define STDLogFunc and STDLogStream to	*/
/* their appropriate values before including this file.			*/
/* The logging function must have the type of fprintf...		*/
/*----------------------------------------------------------------------*/
# ifndef STDLogFunc
# 	define STDLogFunc	fprintf
# endif
# ifndef STDLogStream
# 	define STDLogStream	stdout
# endif

# define STDFID	  __FILE__,__LINE__

# define LLOG(v)  DBG(STDLogFunc(STDLogStream,"%s,%i: (long)%s = %li\n",\
		  STDFID,#v,(long)(v)))
# define ULLOG(v) DBG(STDLogFunc(STDLogStream,"%s,%i: (ulong)%s = %lu\n",\
		  __FILE__,__LINE__,#v,(unsigned long)(v)))
# define DLOG(v)  DBG(STDLogFunc(STDLogStream,"%s,%i: (double)%s = %f\n",\
		  __FILE__,__LINE__,#v,(double)(v)))
# define DDLOG(v) DBG(STDLogFunc(STDLogStream,"%s,%i: (double)%s = %.12f\n",\
		  __FILE__,__LINE__,#v,(double)(v)))
# define XDLOG(v) DBG(STDLogFunc(STDLogStream, \
		  "%s,%i: (double)%s = %.8X %.8X\n",__FILE__,__LINE__,#v,\
		  *(unsigned*)&(v),*((unsigned*)&(v)) + 1))
# define OLOG(v)  DBG(STDLogFunc(STDLogStream,"%s,%i: (long)%s = 0%lO\n",\
		  __FILE__,__LINE__,#v,(long)(v)))
# define XLOG(v)  DBG(STDLogFunc(STDLogStream,"%s,%i: (long)%s = 0x%0*lX\n",\
		  __FILE__,__LINE__,#v,(int)sizeof(long),(long)(v)))
# define CLOG(v)  DBG(STDLogFunc(STDLogStream,"%s,%i: (char)%s = '%c'\n",\
		  __FILE__,__LINE__,#v,(char)(v)))
# define BLOG(v)  DBG(STDLogFunc(STDLogStream,"%s,%i: (byte)%s = 0x%.2X\n",\
		  __FILE__,__LINE__,#v,(unsigned)(v&0xFF)))
# define UCLOG(v) DBG(STDLogFunc(STDLogStream,"%s,%i: (uchar)%s = 0x%.2X\n",\
		  __FILE__,__LINE__,#v,(unsigned char)(v&0xFF)))
# define SLOG(v)  DBG(STDLogFunc(STDLogStream,"%s,%i: (char*)%s = \"%s\"\n",\
		  __FILE__,__LINE__,#v,(char*)(v)))
# define VLOG(v)  DBG(STDLogFunc(STDLogStream,\
			"%s,%i: (Vector) %s = '%.3f %.3f %.3f'\n",\
			__FILE__,__LINE__,#v,(v)->x,(v)->y,(v)->z))


# define STDMALLOC(p,s,r)	do {	\
				    if (! ( (p) = malloc((s)) ) ) \
					return (r);		\
				    else			\
					memset((p),0,(s)) ;	\
				} while ( 0 )

# define STDREALLOC(p,s,r)	\
	do { if (!((p)=realloc((p),(s)))) return (r) } while ( 0 )

# define STDFREE(p)		free((void*)(p))

# include <assert.h>
# define STDASSERT(expr)	DBG( assert( (expr ) ) )

# endif /* ! _StandardInclude_	 } */
