/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if HAVE_STDLIB_H
# include <stdlib.h>
#endif
#if HAVE_STRING_H
# include <string.h>
#endif
#if HAVE_UNISTD_H
# include <unistd.h>
#endif
#if HAVE_STDIO_H
# include <stdio.h>
#endif
#if HAVE_INTTYPES_H
# include <inttypes.h>
#endif

#include <pftp_settings.h>

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

#include "str.h"
#include "sethosts.h"
#include "editconf.h"
#include "set_utils.h"
#include "util.h"
#include "b64.h"

int sethost(const char *site, int save_pass, int clr_pass, pftp_settings_t conf)
{
#ifdef WIN32
    const char *homedrive = getenv("HOMEDRIVE"); 
    const char *homepath = getenv("HOMEPATH"); 
#else
    const char *home = getenv("HOME"); 
#endif
    char *conffile = NULL, *tmpstr = NULL, *tmpstr2 = NULL;  
    size_t h, len;
    int err = 0;
    edit_conf_t fh;
#ifdef WIN32
    if (homedrive != NULL && homepath != NULL) { 
    	conffile = alloc_strcpy(homedrive);                                   
        conffile = realloc_strcat(conffile, homepath);
        conffile = realloc_strcat(conffile, "\\.pftphosts");
#else
    if (home != NULL) { 
	conffile = alloc_strcpy(home);                                   
        conffile = realloc_strcat(conffile, "/.pftphosts");
#endif
    } else {
	util_error("No home directory, please get one.");
	return 0;
    }             

    err = 1;
    
    for (;;) {
	if (!(fh = open_conffile(conffile, "[pftp-hosts]"))) 
	    break;
	tmpstr = alloc_strcpy("");
	for (h = 0; h < conf->hosts; h++) {
	    if (!conf->hostname[h])
		continue;
	    len = strlen(conf->hostname[h]);
	    tmpstr2 = realloc(tmpstr2, len + 25);
	    snprintf(tmpstr2, len + 25, "%s:%u ", conf->hostname[h],
		     (conf->port[h] == 0) ? 21 : conf->port[h]);
	    tmpstr = realloc_strcat(tmpstr, tmpstr2);
	}
	if (tmpstr[0])
	    tmpstr[strlen(tmpstr)-1] = '\0';
	if (update_confvalue(fh, site, "SERVERS", tmpstr))
	    break;
	if (update_confvalue(fh, site, "USERNAME", 
			     conf->username ? conf->username : ""))
	    break;
	if (save_pass || clr_pass) {
	    char *enc_pass;
	    size_t enc_pass_len;
	    enc_pass = NULL;
	    if (!clr_pass) {
		b64_encode(conf->password ? conf->password : "",
			   conf->password ? strlen(conf->password) : 0,
			   &enc_pass, &enc_pass_len);	    
		enc_pass = realloc(enc_pass, enc_pass_len + 1);
		enc_pass[enc_pass_len] = '\0';
	    } else {
		enc_pass = strdup("");
	    }

	    if (update_confvalue(fh, site, "PASSWORD", enc_pass)) {
		free(enc_pass);
		break;
	    }

	    free(enc_pass);
	}
	if (conf->pasv != -1 && update_confvalue(fh, site, "PASV", 
						 yesno(conf->pasv)))
	    break;
	if (conf->port_start) {
	    longval(&tmpstr, conf->port_start);
	    if (update_confvalue(fh, site, "PORT_START", tmpstr))
		break;
	    longval(&tmpstr, conf->port_stop);
	    if (update_confvalue(fh, site, "PORT_STOP", tmpstr))
		break;
	}
	if (conf->bind_to && update_confvalue(fh, site, "IF", conf->bind_to))
	    break;
	if (conf->myaddr && update_confvalue(fh, site, "OUTWARD_IP", 
					     conf->myaddr))
	    break;
	if (conf->use_secure != -1 && 
	    update_confvalue(fh, site, "USE_SECURE", yesno(conf->use_secure)))
	    break;
	if (conf->secure_list != -1 &&
	    update_confvalue(fh, site, "SECURE_LIST",yesno(conf->secure_list)))
            break;
	if (conf->secure_data != -1 &&
	    update_confvalue(fh, site, "SECURE_DATA",yesno(conf->secure_data)))
	    break;
	if (conf->implicid_ssl != -1 &&
	    update_confvalue(fh, site, "IMPLICIT_SSL",
			     yesno(conf->implicid_ssl)))
	    break;
	if (conf->account && update_confvalue(fh, site, "ACCOUNT", 
					      conf->account))
	    break;
	if (update_confvalue(fh, site, "INCLUDE_GLOBAL_PRIO",
			     yesno(conf->include_global_prio)))
	    break;
	if (update_confvalue(fh, site, "INCLUDE_GLOBAL_IGNORE",
			     yesno(conf->include_global_ignore)))
	    break;
	if (conf->prio_list) {
	    if (tmpstr) free(tmpstr);
	    tmpstr = unsplit((const char **)conf->prio_list, 
			     conf->prio_list_len, " ");
	    if (update_confvalue(fh, site, "PRIO_LIST", tmpstr))
		break;
	}
	if (conf->ignore_list) {
	    if (tmpstr) free(tmpstr);
	    tmpstr = unsplit((const char **)conf->ignore_list, 
			     conf->ignore_list_len, " ");     
	    if (update_confvalue(fh, site, "IGNORE_LIST", tmpstr))
		break; 
	}
	err = 0;
	break;
    }

    if (err) {
	util_error("Hosts file not updated.");
    }

    if (fh)
	close_conffile(fh);

    if (tmpstr)
	free(tmpstr);
    if (tmpstr2)
	free(tmpstr2);

    free(conffile);

    if (err)
	return -1;
    else
	return 0;
}
