/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if HAVE_STDLIB_H
# include <stdlib.h>
#endif
#if HAVE_STRING_H
# include <string.h>
#endif
#if HAVE_UNISTD_H
# include <unistd.h>
#endif
#if HAVE_STDIO_H
# include <stdio.h>
#endif
#if HAVE_INTTYPES_H
# include <inttypes.h>
#endif
#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

#include "str.h"
#include "setconf.h"
#include "pftp_getconf.h"
#include "editconf.h"
#include "set_utils.h"
#include "util.h"

int setconf(pftp_conf_t conf)
{
#ifdef WIN32
    const char *homedrive = getenv("HOMEDRIVE");
    const char *homepath = getenv("HOMEPATH");
#else
    const char *home = getenv("HOME");
#endif
    char *conffile = NULL, *tmpstr = NULL;  
    int err = 0;
    edit_conf_t fh;
#ifdef WIN32
    if (homedrive != NULL && homepath != NULL) { 
	conffile = alloc_strcpy(homedrive);                                 
        conffile = realloc_strcat(conffile, homepath);
        conffile = realloc_strcat(conffile, "\\.pftprc");                    
#else
    if (home != NULL) { 
	conffile = alloc_strcpy(home);                                   
        conffile = realloc_strcat(conffile, "/.pftprc");                    
#endif
    } else {
	util_error("No home directory, please get one.");
	return 0;
    }             

    err = 1;
    
    for (;;) {
	if (!(fh = open_conffile(conffile, "[pftp]"))) 
	    break;
	if (update_confvalue(fh, NULL, "PASV", yesno(conf->ftp->pasv)))
	    break;
	longval(&tmpstr, conf->ftp->port_start);
	if (update_confvalue(fh, NULL, "PORT_START", tmpstr))
	    break;
	longval(&tmpstr, conf->ftp->port_stop);
	if (update_confvalue(fh, NULL, "PORT_STOP", tmpstr))
	    break;
	if (update_confvalue(fh, NULL, "IF", 
			     conf->ftp->bind_to ? conf->ftp->bind_to : ""))
	    break;
	if (update_confvalue(fh, NULL, "OUTWARD_IP",
			     conf->ftp->myaddr ? conf->ftp->myaddr : ""))
	    break;
	if (update_confvalue(fh, NULL, "USE_SECURE", 
			     yesno(conf->ftp->use_secure)))
	    break;
	if (update_confvalue(fh, NULL, "SECURE_LIST",
			     yesno(conf->ftp->secure_list)))
            break;
	if (update_confvalue(fh, NULL, "SECURE_DATA",
			     yesno(conf->ftp->secure_data)))             
	    break;
	if (update_confvalue(fh, NULL, "IMPLICIT_SSL",
			     yesno(conf->ftp->implicid_ssl)))                  
	    break;
	if (tmpstr) free(tmpstr);
	tmpstr = unsplit((const char **)conf->ftp->prio_list, 
			 conf->ftp->prio_list_len, " ");
	if (update_confvalue(fh, NULL, "PRIO_LIST", tmpstr ? tmpstr : ""))
	    break;
	if (tmpstr) free(tmpstr);
	tmpstr = unsplit((const char **)conf->ftp->ignore_list, 
			 conf->ftp->ignore_list_len, " ");     
        if (update_confvalue(fh, NULL, "IGNORE_LIST", tmpstr ? tmpstr : ""))
            break; 
	ulongval(&tmpstr, conf->gui_width);
	if (update_confvalue(fh, NULL, "GUI_WIDTH", tmpstr))
	    break;
	ulongval(&tmpstr, conf->gui_height);
	if (update_confvalue(fh, NULL, "GUI_HEIGHT", tmpstr))
	    break;
	ulongval(&tmpstr, conf->horzpan1);
	if (update_confvalue(fh, NULL, "HORIZONTAL_PANEL1_POS", tmpstr))
	    break;
	ulongval(&tmpstr, conf->horzpan2);
	if (update_confvalue(fh, NULL, "HORIZONTAL_PANEL2_POS", tmpstr))
	    break;
	err = 0;
	break;
    }

    if (err) {
	util_error("Config file not written.");
    }

    if (fh)
	close_conffile(fh);

    if (tmpstr)
	free(tmpstr);

    free(conffile);

    if (err)
	return -1;
    else
	return 0;
}

