/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if HAVE_STDLIB_H
# include <stdlib.h>
#endif
#if HAVE_UNISTD_H
# include <unistd.h>
#endif
#if HAVE_STRING_H
# include <string.h>
#endif
#if HAVE_INTTYPES_H
# include <inttypes.h>
#endif

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

#include <pftp_default.h>
#include "str.h"

pftp_default_t newDefault(void)
{
    pftp_default_t ret = malloc(sizeof(struct pftp_default_s));
    memset(ret, 0, sizeof(struct pftp_default_s));

    return ret;
}

void freeDefault(pftp_default_t *ret)
{
    if (ret && (*ret)) {
	size_t i;
	if ((*ret)->bind_to) free((*ret)->bind_to);
	if ((*ret)->myaddr) free((*ret)->myaddr);
	for (i = 0; i < (*ret)->prio_list_len; i++)
	    free((*ret)->prio_list[i]);	
	for (i = 0; i < (*ret)->ignore_list_len; i++)
	    free((*ret)->ignore_list[i]);	
	if ((*ret)->prio_list) free((*ret)->prio_list);
	if ((*ret)->ignore_list) free((*ret)->ignore_list);
	free((*ret));
	(*ret) = NULL;
    }
}

void cpyDefault(pftp_default_t DEST, pftp_default_t SOURCE)
{
    size_t i;
    memcpy(DEST, SOURCE, (sizeof(struct pftp_default_s)));
    DEST->bind_to = alloc_strcpy(SOURCE->bind_to);
    DEST->myaddr = alloc_strcpy(SOURCE->myaddr);
    if (SOURCE->prio_list_len)
	DEST->prio_list = malloc(SOURCE->prio_list_len * sizeof(char *));
    if (SOURCE->ignore_list_len)
	DEST->ignore_list = malloc(SOURCE->ignore_list_len * sizeof(char *));
    for (i = 0; i < SOURCE->prio_list_len; i++)
	DEST->prio_list[i] = alloc_strcpy(SOURCE->prio_list[i]);
    for (i = 0; i < SOURCE->ignore_list_len; i++)
	DEST->ignore_list[i] = alloc_strcpy(SOURCE->ignore_list[i]);
}

