/* -*- pftp-c -*- */
#ifndef PFTP_QUE_H
#define PFTP_QUE_H

#ifndef LIBPFTPUTIL_API
# ifdef WIN32
#  include "w32-libpftputil.h"
# else
#  define LIBPFTPUTIL_API 
# endif
#endif

LIBPFTPUTIL_API typedef struct pftp_que_s* pftp_que_t;
LIBPFTPUTIL_API pftp_que_t pftp_CreateQue(void);
LIBPFTPUTIL_API void pftp_FreeQue(pftp_que_t q);

LIBPFTPUTIL_API size_t pftp_queLength(pftp_que_t Q);
LIBPFTPUTIL_API void* pftp_deque(pftp_que_t Q);
LIBPFTPUTIL_API void* pftp_peek(pftp_que_t Q, size_t pos);
LIBPFTPUTIL_API void pftp_addFirst(void *Item, pftp_que_t Q);
LIBPFTPUTIL_API void pftp_addLast(void *Item, pftp_que_t Q);
LIBPFTPUTIL_API void pftp_moveUp(int index, pftp_que_t Q);
LIBPFTPUTIL_API void pftp_moveDown(int index, pftp_que_t Q);
LIBPFTPUTIL_API void* pftp_delete(int index, pftp_que_t Q);

#endif /* PFTP_QUE_H */


