/* -*- pftp-c -*- */
#ifndef PFTP_ITEM_H
#define PFTP_ITEM_H

#ifndef LIBPFTPUTIL_API
# ifdef WIN32
#  include "w32-libpftputil.h"
# else
#  define LIBPFTPUTIL_API 
# endif
#endif

#include <pftp_directory.h>
#include <pftp_settings.h>
#include "pftp_que.h"

LIBPFTPUTIL_API typedef struct pftp_item_s *pftp_item_t;

LIBPFTPUTIL_API typedef enum { PFTP_COPY, PFTP_MOVE, PFTP_DELETE_FROM,
			       PFTP_DELETE_FROM_DIR } pftp_item_action_t;

#define PFTP_PRESERVE_NONE 0x0
#define PFTP_PRESERVE_ACCESS 0x1
#define PFTP_PRESERVE_TIME 0x2
/* Warn if above preserves didn\'t work */
#define PFTP_PRESERVE_FORCE 0x4

#define PFTP_MODE_NORMAL 0x0
#define PFTP_MODE_OVERWRITE_OK 0x1

LIBPFTPUTIL_API struct pftp_item_s {
    char *ftp_from, *ftp_to;
    uint64_t size;
    int dir;
    char *filename, *changed, *target;
    char *srcpath, *destpath;

    unsigned short access;
    pftp_item_action_t action;
    unsigned int preserve;
    unsigned int mode;
};

LIBPFTPUTIL_API pftp_item_t pftp_get_next(pftp_que_t Q);
LIBPFTPUTIL_API pftp_item_t pftp_que_peek(pftp_que_t Q, size_t pos);
LIBPFTPUTIL_API void pftp_que_add_first(pftp_item_t Item, pftp_que_t Q);
LIBPFTPUTIL_API void pftp_que_add_last(pftp_item_t Item, pftp_que_t Q);
LIBPFTPUTIL_API pftp_item_t pftp_remove_item(int index, pftp_que_t Q);
LIBPFTPUTIL_API void pftp_free_queitem(pftp_item_t *item);
LIBPFTPUTIL_API void pftp_clear_que(pftp_que_t Q);
LIBPFTPUTIL_API int pftp_que_add_dir(const char *srcftp,  const char *destftp,
				     const char *srcpath, const char *destpath,
				     const pftp_directory_t *dir, 
				     pftp_que_t que, int last,
				     unsigned int preserve, 
				     pftp_item_action_t action,
				     unsigned int mode);

#endif /* PFTP_ITEM */
