/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <inttypes.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

#include <pftp_settings.h>
#include "hosts_settings.h"
#include "str.h"

pftp_settings_t newFTPSettings(const char *name, pftp_default_t global)
{
    pftp_settings_t ret = malloc(sizeof(struct pftp_settings_s));
    memset(ret, 0, sizeof(struct pftp_settings_s));

    ret->name = alloc_strcpy(name);
    ret->pasv = -1;
    ret->secure_list = -1;
    ret->secure_data = -1;
    ret->use_secure = -1;
    ret->implicid_ssl = -1;    
    ret->global = global;

    return ret;
}

void freeFTPSettings(pftp_settings_t *ret)

{
    if (ret && (*ret)) {
	size_t i;
	for (i = 0; i< (*ret)->hosts; i++)
	    free((*ret)->hostname[i]);
	if ((*ret)->hostname) free((*ret)->hostname);
	if ((*ret)->port) free((*ret)->port);
	if ((*ret)->username) free((*ret)->username);
	if ((*ret)->password) free((*ret)->password);
	if ((*ret)->account) free((*ret)->account);
	if ((*ret)->name) free((*ret)->name);
	if ((*ret)->bind_to) free((*ret)->bind_to);
	if ((*ret)->myaddr) free((*ret)->myaddr);
	for (i = 0; i < (*ret)->prio_list_len; i++)
	    free((*ret)->prio_list[i]);	
	for (i = 0; i < (*ret)->ignore_list_len; i++)
	    free((*ret)->ignore_list[i]);	
	if ((*ret)->prio_list) free((*ret)->prio_list);
	if ((*ret)->ignore_list) free((*ret)->ignore_list);	
	free((*ret));
	(*ret) = NULL;
    }
}

void copyFTPSettings(pftp_settings_t dest, const pftp_settings_t src)
{
    size_t i;

    dest->pasv = src->pasv;
    dest->secure_list = src->secure_list;
    dest->secure_data = src->secure_data;
    dest->use_secure = src->use_secure;
    dest->implicid_ssl = src->implicid_ssl;
    dest->port_start = src->port_start;
    dest->port_stop = src->port_stop;
    dest->include_global_prio = src->include_global_prio;
    dest->include_global_ignore = src->include_global_ignore;
    dest->global = src->global;
    
    dest->username = realloc_strcpy(dest->username, src->username);
    dest->password = realloc_strcpy(dest->password, src->password);
    dest->account = realloc_strcpy(dest->account, src->account);
    dest->name = realloc_strcpy(dest->name, src->name);
    dest->bind_to = realloc_strcpy(dest->bind_to, src->bind_to);
    dest->myaddr = realloc_strcpy(dest->myaddr, src->myaddr);
    
    for (i = 0; i< dest->hosts; i++)
	free(dest->hostname[i]);

    if (dest->hostname) {
	free(dest->hostname);
	dest->hostname = NULL;
    }
    if (dest->port) {
	free(dest->port);
	dest->port = NULL;
    }

    dest->hosts = src->hosts;

    if (dest->hosts > 0) {
	dest->hostname = malloc(dest->hosts * sizeof(char *));
	dest->port = malloc(dest->hosts * sizeof(uint16_t));

	for (i = 0; i < dest->hosts; i++) {
	    dest->hostname[i] = alloc_strcpy(src->hostname[i]);
	    dest->port[i] = src->port[i];
	}
    }

    for (i = 0; i < dest->prio_list_len; i++)
	free(dest->prio_list[i]);
    for (i = 0; i<  dest->ignore_list_len; i++)
	free(dest->ignore_list[i]);

    if (dest->prio_list) {
	free(dest->prio_list);
	dest->prio_list = NULL;
    }
    if (dest->ignore_list) {
	free(dest->ignore_list);
	dest->ignore_list = NULL;
    }

    dest->prio_list_len = src->prio_list_len;
    
    if (dest->prio_list_len > 0) {
	dest->prio_list = malloc(dest->prio_list_len * sizeof(char *));

	for (i = 0; i < dest->prio_list_len; i++) 
	    dest->prio_list[i] = alloc_strcpy(src->prio_list[i]);	
    }

    dest->ignore_list_len = src->ignore_list_len;

    if (dest->ignore_list_len > 0) {
	dest->ignore_list = malloc(dest->ignore_list_len * sizeof(char *));

	for (i = 0; i < dest->ignore_list_len; i++) 
	    dest->ignore_list[i] = alloc_strcpy(src->ignore_list[i]);	
    }
}
