/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <arpa/inet.h>
#include <netdb.h>

#include "str.h"

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

void rm_head_ws(const char *line, char **clean_line)
{
    size_t pos = 0;
    while (xisspace(line[pos])) {
	pos++;
    }
    (*clean_line) = realloc((*clean_line), strlen(line + pos) + 1);
    strcpy(*clean_line, (line + pos));
}

int only_ws(const char *line)
{
    int pos = 0;
    while (xisspace(line[pos]))
	pos++;
    if (line[pos] == '\0')
	return 1;
    return 0;
}

long parse_port(const char *line, int *valid)
{
    long ret;
    char *err;
    char *clean_line = NULL;    
    rm_head_ws(line, &clean_line);
    ret = strtol(clean_line, &err, 10);

    if (err == clean_line) {
	free(clean_line);
	if (valid) (*valid) = 0;
	return 0;
    }
    if (ret < 0 || ret > 0xFFFE) {
	if (valid) (*valid) = 0;
	free(clean_line);
	return 0;
    }
    if (only_ws(err)) {
	if (valid) (*valid) = 1;
	free(clean_line);  
	return ret;
    } else {
	if (valid) (*valid) = 0;
	free(clean_line);    
	return 0;
    }
}

unsigned long parse_ulong(const char *line, int *valid)
{
    unsigned long ret;
    char *err;
    char *clean_line = NULL;    
    rm_head_ws(line, &clean_line);
    ret = strtoul(clean_line, &err, 10);

    if (err == clean_line) {
	free(clean_line);
	if (valid) (*valid) = 0;
	return 0;
    }
    if (only_ws(err)) {
	if (valid) (*valid) = 1;
	free(clean_line);  
	return ret;
    } else {
	if (valid) (*valid) = 0;
	free(clean_line);    
	return 0;
    }
}

int yes_or_no(const char *line)
{
    if (tolower(line[0]) == 'n') {
	return 0;
    } else if (tolower(line[0]) == 'y') {
	return 1;
    }
    return -1;
}

int set_yes_or_no(char *line, int *set)
{
    char *clean_line = NULL;
    int loc_set;
    rm_head_ws(line, &clean_line);
    loc_set = yes_or_no(clean_line);
    free(clean_line);
    if (loc_set == 0 || loc_set == 1) {
	*set = loc_set;
	return 0;
    }
    return -1;
}

int check_interface(const char *interface)
{
    struct in_addr addr;

    if (!interface || !interface[0])
	return 0;

    if (!inet_aton(interface, &addr)) {
	struct hostent *host = gethostbyname(interface);
	
	if (!host) 
	    return -1;
    }

    return 0;
}

int check_ip(const char *ip)
{
    return check_interface(ip);
}

int check_list(const char **list, size_t len)
{
    /* What exactly am I supposed to check here? */
    return 0;
}

int set_servers(const char *line, char ***hostname, uint16_t **port, 
		size_t *hosts)
{
    size_t h, len;
    int valid;
    char *pos, *end;
    unsigned long tmplong;
    (*hosts) = split(line, " ", hostname, NULL);
    (*port) = NULL;
    if ((*hosts) == 0)
	return -1;
    (*port) = malloc(sizeof(uint16_t) * (*hosts));
    h = 0;
    while (h < (*hosts)) {
	valid = 1;
	len = strlen((*hostname)[h]);
	if (len == 0) {
	    valid = 0;
	} else {
	    if (!(pos = strchr((*hostname)[h], ':'))) {
		(*port)[h] = 21;
	    } else {
		tmplong = strtoul(pos + 1, &end, 10);
		if (!end || end[0] || tmplong == 0 || tmplong >= 0xFFFF) {
		    valid = 0;
		} else {
		    (*port)[h] = (uint16_t)tmplong;
		    pos[0] = '\0';
		}
	    }
	}

	if (!valid) {
	    free((*hostname)[h]);
	    (*hosts)--;
	    memmove((*hostname) + h, (*hostname) + h + 1,
		    ((*hosts) - h) * sizeof(char *));
	} else {
	    h++;
	}
    }
    if ((*hosts) == 0) {
	free((*hostname));
	free((*port));
	(*hostname) = NULL;
	(*port) = NULL;
	return -1;
    }
    return 0;
}
