/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

#if !HAVE_GETLINE

ssize_t rpl_getline(char **line, size_t *line_len, FILE *stream)
{
    size_t _line_len = 0;
    char *_line = malloc(_line_len + 2);
    int ret;
    
    for (;;) {
	ret = fgetc(stream);
	if (ret == EOF) {
	    free(_line);
	    return -1;
	}
	_line[_line_len] = (char)(ret & 0xFF);
	if (_line[_line_len] == '\n') {
	    _line[++_line_len] = '\0';
	    (*line_len) = _line_len + 1;
	    (*line) = realloc((*line), (*line_len));
	    memcpy((*line), _line, (*line_len));
	    free(_line);
	    return _line_len;
	}	
	_line_len++;
	_line = realloc(_line, _line_len + 2);
    }
}

#endif
