from arybo.lib import MBA, simplify_inplace, simplify
from pytanque import Vector

import base64

## Helpers
def flatten_vec(V):
    n = 8*len(V)
    ret = Vector(n)
    for i in range(len(V)):
        for j in range(8):
            ret[i*8+j] = V[i][j].copy()
    return ret
##

mba8 = MBA(8)
mba128 = MBA(128)

S = [
    0xa5, 0xc6, 0x62, 0x01, 0x49, 0x2a, 0x8e, 0xed, 0x1f, 0x7c, 0xd8, 0xbb, 0xf3, 0x90, 0x34, 0x57,
    0xb3, 0xd0, 0x74, 0x17, 0x5f, 0x3c, 0x98, 0xfb, 0x09, 0x6a, 0xce, 0xad, 0xe5, 0x86, 0x22, 0x41,
    0x89, 0xea, 0x4e, 0x2d, 0x65, 0x06, 0xa2, 0xc1, 0x33, 0x50, 0xf4, 0x97, 0xdf, 0xbc, 0x18, 0x7b,
    0x9f, 0xfc, 0x58, 0x3b, 0x73, 0x10, 0xb4, 0xd7, 0x25, 0x46, 0xe2, 0x81, 0xc9, 0xaa, 0x0e, 0x6d,
    0xfd, 0x9e, 0x3a, 0x59, 0x11, 0x72, 0xd6, 0xb5, 0x47, 0x24, 0x80, 0xe3, 0xab, 0xc8, 0x6c, 0x0f,
    0xeb, 0x88, 0x2c, 0x4f, 0x07, 0x64, 0xc0, 0xa3, 0x51, 0x32, 0x96, 0xf5, 0xbd, 0xde, 0x7a, 0x19,
    0xd1, 0xb2, 0x16, 0x75, 0x3d, 0x5e, 0xfa, 0x99, 0x6b, 0x08, 0xac, 0xcf, 0x87, 0xe4, 0x40, 0x23,
    0xc7, 0xa4, 0x00, 0x63, 0x2b, 0x48, 0xec, 0x8f, 0x7d, 0x1e, 0xba, 0xd9, 0x91, 0xf2, 0x56, 0x35,
    0x14, 0x77, 0xd3, 0xb0, 0xf8, 0x9b, 0x3f, 0x5c, 0xae, 0xcd, 0x69, 0x0a, 0x42, 0x21, 0x85, 0xe6,
    0x02, 0x61, 0xc5, 0xa6, 0xee, 0x8d, 0x29, 0x4a, 0xb8, 0xdb, 0x7f, 0x1c, 0x54, 0x37, 0x93, 0xf0,
    0x38, 0x5b, 0xff, 0x9c, 0xd4, 0xb7, 0x13, 0x70, 0x82, 0xe1, 0x45, 0x26, 0x6e, 0x0d, 0xa9, 0xca,
    0x2e, 0x4d, 0xe9, 0x8a, 0xc2, 0xa1, 0x05, 0x66, 0x94, 0xf7, 0x53, 0x30, 0x78, 0x1b, 0xbf, 0xdc,
    0x4c, 0x2f, 0x8b, 0xe8, 0xa0, 0xc3, 0x67, 0x04, 0xf6, 0x95, 0x31, 0x52, 0x1a, 0x79, 0xdd, 0xbe,
    0x5a, 0x39, 0x9d, 0xfe, 0xb6, 0xd5, 0x71, 0x12, 0xe0, 0x83, 0x27, 0x44, 0x0c, 0x6f, 0xcb, 0xa8,
    0x60, 0x03, 0xa7, 0xc4, 0x8c, 0xef, 0x4b, 0x28, 0xda, 0xb9, 0x1d, 0x7e, 0x36, 0x55, 0xf1, 0x92,
    0x76, 0x15, 0xb1, 0xd2, 0x9a, 0xf9, 0x5d, 0x3e, 0xcc, 0xaf, 0x0b, 0x68, 0x20, 0x43, 0xe7, 0x84
]

S,X = mba8.permut2expr(S)
S = S.vectorial_decomp([X])

def step(b):
    new = S((b[10]^b[12]^b[13]^b[15]).vec)
    new = mba8.from_vec(simplify_inplace(new))
    return [new] + b[:15]

def f(b):
    for i in range(64):
        b = step(b)
    return b

def xor(a,b):
    return [a[i]^b[i] for i in range(16)]

def even_mansour(block, key):
    block = xor(block, key[:16])
    block = f(block)
    block = xor(block, key[16:])
    return block

block    = [mba8.var('b%d' % i) for i in range(16)]
key_zero = [mba8.from_cst(0)]*32
cipher   = even_mansour(block,key_zero)
cipher   = flatten_vec(cipher)

CZ = mba128.from_vec(cipher).vectorial_decomp(block)
Minv = CZ.matrix().inverse()

def recover(plaintext, cipher_plaintext, cipher_unk):
    plaintext = mba128.from_bytes(plaintext)
    cipher_plaintext = mba128.from_bytes(cipher_plaintext)
    cipher_unk = mba128.from_bytes(cipher_unk)

    tmp = mba128.from_vec(simplify(Minv*((cipher_plaintext ^ cipher_unk).vec)))
    return (plaintext ^ tmp).to_bytes()

def recover_ascii(*args, **kwargs):
    return recover(*args, **kwargs).decode("ascii")

clear = b"apofkjezjgoiezgjioegzezg"[:16]
clear_ciphered = base64.b64decode("B6D36+weKdCm/9O8nPrG8QyVZ3NaBiqo0G6yPZzi79o=")[:16]
flag_ciphered = base64.b64decode("QwpzZX8sAHwaKLMTRFb79/E2nZt8k0J6Sry65nBxQd8CVGCYxj/MJa2Fe9jQK8eL")

s = ""
for i in range(0, len(flag_ciphered), 16):
    s += recover_ascii(clear, clear_ciphered, flag_ciphered[i:i+16])
print(s)
