
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#include "tmpl_internal.h"

/*
 * Free an array of parse elements.
 */
void
_tmpl_free_elems(const char *mtype, void *eblock,
	struct tmpl_elem *elems, int num)
{
	int i;

	if (eblock != NULL) {
		FREE(mtype, eblock);
		return;
	}
	for (i = 0; i < num; i++) {
		if ((elems[i].flags & TMPL_ELEM_MMAP_TEXT) == 0)
			FREE(mtype, elems[i].text);
		_tmpl_free_call(mtype, &elems[i].call);
	}
	FREE(mtype, elems);
}

/*
 * Free a run-time function structure.
 */
void
_tmpl_free_func(struct tmpl_ctx *ctx, struct exec_func *func)
{
	/* Free name */
	FREE(ctx->mtype, func->name);

	/* Free elements */
	_tmpl_free_elems(ctx->mtype, func->eblock, func->elems, func->num_elems);
}

/*
 * Free a parsed function call structure.
 */
void
_tmpl_free_call(const char *mtype, struct func_call *call)
{
	int i;

	for (i = 0; i < call->nargs; i++)
		_tmpl_free_arg(mtype, &call->args[i]);
	FREE(mtype, call->args);
	FREE(mtype, call->funcname);
	memset(call, 0, sizeof(*call));
}

/*
 * Free a parsed function argument.
 */
void
_tmpl_free_arg(const char *mtype, struct func_arg *arg)
{
	if (arg->is_literal) {
		FREE(mtype, arg->u.literal);
		arg->u.literal = NULL;
	} else
		_tmpl_free_call(mtype, &arg->u.call);
	memset(arg, 0, sizeof(*arg));
}

