
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/mount.h>

#include <ufs/ufs/ufsmount.h>

#include <stdio.h>
#include <stddef.h>
#include <string.h>
#include <syslog.h>
#include <errno.h>
#include <fstab.h>

#include <openssl/ssl.h>

#include "sys/fs_mount.h"

/*
 * Mount a filesystem.
 */
int
fs_mount(const char *where, int flags)
{
	struct fstab *fstab;
	struct ufs_args ufs_args;
	void *mnt_args;
	int errno_save;
	int rtn = -1;

	/* Get /etc/fstab entry for mount point */
	fstab = getfsfile(where);

	/* Check for error */
	if ((fstab = getfsfile(where)) == NULL) {
		errno = ENOENT;
		goto done;
	}

	/* Set up args */
	memset(&ufs_args, 0, sizeof(ufs_args));
	ufs_args.fspec = fstab->fs_spec;
	mnt_args = &ufs_args;

	/* Try to mount */
	if (mount(fstab->fs_vfstype, where, flags, mnt_args) == 0)
		rtn = 0;

done:
	/* Clean up */
	errno_save = errno;
	endfsent();
	errno = errno_save;
	return (rtn);
}

/*
 * Unmount a filesystem.
 */
int
fs_unmount(const char *where, int flags)
{
	if (unmount(where, flags) == -1)
		return (-1);
	return (0);
}


