
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#include "xmlrpc_test.h"

DEFINE_STRUCTS_ARRAY(three_stooges_array, struct three_stooges);

static const struct structs_field three_stooges_fields[] = {
	STRUCTS_STRUCT_FIELD(three_stooges, moe, &structs_type_int32),
	STRUCTS_STRUCT_FIELD(three_stooges, larry, &structs_type_int32),
	STRUCTS_STRUCT_FIELD(three_stooges, curly, &structs_type_int32),
	STRUCTS_STRUCT_FIELD_END
};
const struct structs_type three_stooges_type
	= STRUCTS_STRUCT_TYPE(three_stooges, three_stooges_fields);
static const struct structs_type three_stooges_array_type
	= STRUCTS_ARRAY_TYPE(&three_stooges_type, MEM_TYPE, "element");

static const struct structs_type *arrayOfStructsTest_ptypes[] = {
	&three_stooges_array_type,
};

static http_servlet_xmlrpc_handler_t	arrayOfStructsTest_handler;

const struct	http_servlet_xmlrpc_method arrayOfStructsTest_method = {
	"validator1.arrayOfStructsTest",
	arrayOfStructsTest_handler,
	arrayOfStructsTest_ptypes,
	1, 1
};

static void *
arrayOfStructsTest_handler(void *arg, const char *method,
	struct http_request *req, u_int nparams, const void **params,
	const char *mtype, const struct structs_type **rtypep, int *faulted)
{
	const struct three_stooges_array *const array = params[0];
	int32_t *sum;
	int i;

	alog(LOG_INFO, "method \"%s\" invoked", method);
	if ((sum = MALLOC(mtype, sizeof(*sum))) == NULL)
		return (NULL);
	for (*sum = i = 0; i < array->length; i++)
		*sum += array->elems[i].curly;
	*rtypep = &structs_type_int32;
	return (sum);
}


