
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <err.h>

#include <pdel/structs/structs.h>
#include <pdel/structs/type/array.h>
#include <pdel/util/typed_mem.h>
#include <pdel/net/if_util.h>

int
main(int ac, char **av)
{
	struct in_addr *iplist;
	struct in_addr *nmlist;
	char **ifnames;
	int nif;
	int val;
	int ch;
	int i;

	while ((ch = getopt(ac, av, "")) != -1) {
		switch (ch) {
		default:
			goto usage;
		}
	}
	ac -= optind;
	av += optind;

	if ((nif = if_get_list(&ifnames, TYPED_MEM_TEMP)) == NULL)
		err(1, "if_list");
	for (i = 0; i < nif; i++) {
		printf("interface \"%s\":\n", ifnames[i]);
		printf("     type=");
		if ((val = if_get_type(ifnames[i])) != -1)
			printf("%d\n", val);
		else
			printf("%s\n", strerror(errno));
		printf("    flags=");
		if ((val = if_get_flags(ifnames[i])) != -1)
			printf("0x%x\n", val);
		else
			printf("%s\n", strerror(errno));
		printf("      mtu=");
		if ((val = if_get_mtu(ifnames[i])) != -1)
			printf("%d\n", val);
		else
			printf("%s\n", strerror(errno));
		if ((val = if_get_ip_addrs(ifnames[i],
		    &iplist, &nmlist, TYPED_MEM_TEMP)) == -1)
			printf("  ipaddrs=%s\n", strerror(errno));
		else {
			int j;

			printf("  ipaddrs=[%d]:", val);
			for (j = 0; j < val; j++) {
				printf(" %s/0x%08x", inet_ntoa(iplist[j]),
				    (u_int32_t)ntohl(nmlist[j].s_addr));
			}
			printf("\n");
			FREE(TYPED_MEM_TEMP, iplist);
			FREE(TYPED_MEM_TEMP, nmlist);
		}
	}
	if (ac > 0) {
		int flags;

		if ((flags = if_get_flags(av[0])) == -1)
			err(1, "if_get_flags(%s)", av[0]);
		if (if_set_flags(av[0], flags | IFF_UP) == -1)
			err(1, "if_set_flags(%s)", av[0]);
	}
	while (nif > 0)
		FREE(TYPED_MEM_TEMP, ifnames[--nif]);
	FREE(TYPED_MEM_TEMP, ifnames);
	return (0);

usage:
	fprintf(stderr, "usage: iftest [interface-to-mark-up]\n");
	return (1);
}

