
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#ifndef _PDEL_HTTP_XML_H_
#define _PDEL_HTTP_XML_H_

struct http_client;
struct structs_type;
struct xmlrpc_compact_fault;

__BEGIN_DECLS

/*
 * Send structured message, wait for a reply, and return the reply.
 * If there was an error, NULL is returned and errno is set.
 *
 * Parameters:
 *
 *	client		HTTP client
 *	ip, port	Remote HTTP server
 *	https		Non-zero for SSL
 *	urlpath		Remote URL path (must begin with '/')
 *	username	HTTP auth username (or NULL)
 *	password	HTTP auth password (or NULL)
 *	ptag		XML document element tag for payload
 *	pattrs		Attributes for ptag tag, or NULL for none
 *	ptype		Payload type
 *	payload		Payload (or NULL to do a GET instead of a POST)
 *	pflags		Flags to structs_xml_output()
 *	rtag		XML document element tag for reply
 *	rattrsp		Pointer to string to hold reply attributes (if != NULL)
 *	rattrs_mtype	Allocation type for *rattrsp.
 *	rtype		Reply type
 *	reply		Reply data
 *	rflags		Flags to structs_xml_input()
 *	rlogger		XML logger
 *
 * This function returns zero on success, -1 on error.
 */
extern int	http_xml_send(struct http_client *client, struct in_addr ip,
			u_int16_t port, int https, const char *urlpath,
			const char *username, const char *password,
			const char *ptag, const char *pattrs,
			const struct structs_type *ptype, const void *payload,
			int pflags, const char *rtag, char **rattrsp,
			const char *rattrs_mtype,
			const struct structs_type *rtype, void *reply,
			int rflags, structs_xmllog_t *rlogger);

/*
 * Send XML-RPC message, wait for a reply, and return the reply.
 * If there was an error, NULL is returned and errno is set.
 *
 * Parameters:
 *
 *	client		HTTP client
 *	ip, port	Remote HTTP server
 *	https		Non-zero for SSL
 *	username	HTTP auth username (or NULL)
 *	password	HTTP auth password (or NULL)
 *	methodName	Name of XML-RPC method
 *	nparams		Number of parameters
 *	ptypes		Array of pointers to parameter types
 *	pdatas		Array of pointers to parameter structures
 *	rtype		Reply type (or NULL)
 *	reply		Uninitialized reply (or NULL)
 *	faultp		Set to non-NULL to indicate a fault
 *	rlogger		XML logger
 *
 * This function returns zero on success, -1 on a system error, or -2
 * if an XML-RPC fault was returned (in which case *fault, if not NULL, will
 * be initialized and filled in (so *fault should never be pre-initialized
 * but it should be freed via structs_free() if -2 is returned)).
 */
extern int	http_xml_send_xmlrpc(struct http_client *client,
			struct in_addr ip, u_int16_t port, int https,
			const char *username, const char *password,
			const char *methodName, u_int nparams,
			const struct structs_type **ptypes, const void **pdatas,
			const struct structs_type *rtype, void *reply,
			struct xmlrpc_compact_fault *faultp,
			structs_xmllog_t *rlogger);

__END_DECLS

#endif	/* _PDEL_HTTP_XML_H_ */
