
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#ifndef _PDEL_HTTP_SERVLET_FILE_H_
#define _PDEL_HTTP_SERVLET_FILE_H_

struct http_servlet_file_info;

/*
 * Optional 'screener' function that tells whether a file in
 * the hierarchy should be visible or not. If not supplied,
 * all normal (and symlinked to normal) files will be visible.
 *
 * The "path" is the filesystem pathname to the file.
 *
 * Returns non-zero to hide the file, else zero to publish.
 */
typedef int	http_servlet_file_hide_t(
			const struct http_servlet_file_info *info,
			struct http_request *req, struct http_response *resp,
			const char *path);

/* Info required for this servlet */
struct http_servlet_file_info {
	const char	*docroot;	/* document root, or NULL for cwd */
	u_char		allow_escape;	/* allow url to escape docroot */
	const char	*filename;	/* filename, or NULL to use url */
	const char	*prefix;	/* url prefix to strip, or NULL */
	const char	*mime_type;	/* mime type, or NULL to guess */
	const char	*mime_encoding;	/* mime encoding (only if mime_type) */
	http_logger_t	*logger;	/* http error logger */

	/* Set this to hide certain files */
	http_servlet_file_hide_t	*hide;

	/* Fill in this struct to enable processing of '*.tmpl' as templates */
	struct http_servlet_tmpl_tinfo	tinfo;
};

__BEGIN_DECLS

/*
 * Create a new file servlet.
 *
 * NOTE: the 'info' structure is not copied; it must remain
 * usable as long as the servlet exists.
 */
extern struct	http_servlet *http_servlet_file_create(
			const struct http_servlet_file_info *info);

/*
 * General purpose function for pushing out the contents of a file
 * into an HTTP response.
 */
extern void	http_servlet_file_serve(const char *path, http_logger_t *logger,
			struct http_request *req, struct http_response *resp);

__END_DECLS

#endif	/* _PDEL_HTTP_SERVLET_FILE_H_ */
