/* Evil evil evil hack to get OSS apps to cooperate with esd
* Copyright (C) 1998, 1999 Manish Singh <yosh@gimp.org>
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Library General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public
* License along with this library; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*/

#ifdef DEBUG
#define DSP_DEBUG
#endif

#ifdef DSP_DEBUG
#define DPRINTF(format, args...)	printf(format, ## args)
#else
#define DPRINTF(format, args...)
#endif

#include "config.h"

#include <dlfcn.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <sys/errno.h>
#ifdef HAVE_SYSCALLS
#include <sys/syscall.h>
#endif

#include "liboss/soundcard.h"
#include "liboss/audioio.h"

#include <esd.h>

#ifndef HAVE_SYSCALLS
#define REAL_LIBC libSystem_handle
#endif

typedef unsigned long request_t;

static int sndfd = -1, mixfd = -1;
static int settings = 0, done = 0;

static char *ident = NULL, *mixer = NULL;
static int use_mixer = 1;

#ifndef HAVE_SYSCALLS
static void *libSystem_handle = NULL;
static int acquired_handle = 0;
#endif

#define OSS_VOLUME_BASE 50

#define ESD_VOL_TO_OSS(left, right) (short int)			\
(((OSS_VOLUME_BASE * (right) / ESD_VOLUME_BASE) << 8) |	\
 (OSS_VOLUME_BASE * (left)  / ESD_VOLUME_BASE))

#define OSS_VOL_TO_ESD_LEFT(vol) 				\
(ESD_VOLUME_BASE * (vol & 0xff) / OSS_VOLUME_BASE)
#define OSS_VOL_TO_ESD_RIGHT(vol) 				\
(ESD_VOLUME_BASE * ((vol >> 8) & 0xff) / OSS_VOLUME_BASE)

static int real_write(int play, const void *buf, size_t sz)
{
    static int (*func) (int,const void*,size_t) = NULL;

#ifndef HAVE_SYSCALLS
    if (!func)
        func = (int (*) (int)) dlsym (REAL_LIBC, "_write");
#endif

#ifndef HAVE_SYSCALLS
    return (*func) (play,buf,sz);
#else
    return syscall(SYS_write,play,buf,sz);
#endif
}

static void
get_volume (int *left, int *right)
{
    int vol;

    if (read (mixfd, &vol, sizeof (vol)) != sizeof (vol))
        *left = *right = ESD_VOLUME_BASE;
    else
    {
        *left  = OSS_VOL_TO_ESD_LEFT  (vol);
        *right = OSS_VOL_TO_ESD_RIGHT (vol);
    }
}

static void
set_volume (int left, int right)
{
    int vol = ESD_VOL_TO_OSS (left, right);

    real_write (mixfd, &vol, sizeof (vol));
}


static void
dsp_init (void)
{
    if (!ident)
    {
        char *str = getenv ("ESDDSP_NAME");
        ident = malloc (ESD_NAME_MAX);
        strncpy (ident, (str ? str : "esddsp"), ESD_NAME_MAX);

        str = getenv ("HOME");

        use_mixer = 1;

        if (str)
        {
            mixer = malloc (strlen (str) + strlen (ident) + 20);
            sprintf (mixer, "%s/.esddsp_%s", str, ident);
        }
    }
}

static void
mix_init (int *esd, int *player)
{
    esd_info_t *all_info;
    esd_player_info_t *player_info;

    if (*esd < 0 && (*esd = esd_open_sound (NULL)) < 0)
        return;

    if (*player < 0)
    {
        all_info = esd_get_all_info (*esd);
        if (all_info)
        {
            for (player_info = all_info->player_list; player_info;
                 player_info = player_info->next)
                if (!strcmp(player_info->name, ident))
                {
                    *player = player_info->source_id;
                    break;
                }

                    esd_free_all_info (all_info);
        }
    }
}

static void liboss_init(void)
{
#ifndef HAVE_SYSCALLS
    if (!acquired_handle)
    {
        libSystem_handle = dlopen(SYSTEM_LIB,RTLD_LAZY);
        acquired_handle = 1;
    }
#endif

    dsp_init();
}

int liboss_open (const char *pathname, int flags, va_list args)
{
    static int (*func) (const char *, int, mode_t) = NULL;
    mode_t mode;

    liboss_init ();
#ifndef HAVE_SYSCALLS
    if (!func)
        func = (int (*) (const char *, int, mode_t)) dlsym (REAL_LIBC, "_open");
#endif

    mode = va_arg (args, int);

    if (!strcmp (pathname, "/dev/dsp") || !strcmp(pathname,"/dev/dspW") ||
        !strcmp(pathname,"/dev/sound/dsp"))
    {
        if (!getenv ("ESPEAKER"))
        {
            int ret;

            flags |= O_NONBLOCK;
#ifndef HAVE_SYSCALLS
            if ((ret = (*func) (pathname, flags, mode)) >= 0)
#else
	    if ((ret = syscall(SYS_open,pathname,flags,mode)) >= 0)
#endif
                return ret;
        }

        DPRINTF ("hijacking /dev/dsp open, and taking it to esd...\n");
        settings = done = 0;
        return (sndfd = esd_open_sound (NULL));
    }
    else if (use_mixer && !strcmp (pathname, "/dev/mixer"))
    {
        DPRINTF ("hijacking /dev/mixer open, and taking it to esd...\n");
        return (mixfd = (*func) (mixer, O_RDWR | O_CREAT, S_IRUSR | S_IWUSR));
    }
    else
#ifndef HAVE_SYSCALLS
        return (*func) (pathname, flags, mode);
#else
    return syscall(SYS_open,pathname,flags,mode);
#endif
}

static int
dspctl (int fd, request_t request, void *argp)
{
    struct audio_info tmpinfo;

    static esd_format_t fmt = ESD_BITS16 | ESD_STEREO | ESD_STREAM | ESD_PLAY;
    static int speed;

    int *arg = (int *) argp;

    switch (request)
    {
        case SNDCTL_DSP_RESET:
        case SNDCTL_DSP_POST:
            break;

        case SNDCTL_DSP_SETFMT:
            fmt |= (*arg & 0x30) ? ESD_BITS16 : ESD_BITS8;
            settings |= 1;
            break;

        case SNDCTL_DSP_SPEED:
            speed = *arg;
            settings |= 2;
            break;

        case SNDCTL_DSP_STEREO:
            fmt &= ~ESD_MONO;
            fmt |= (*arg) ? ESD_STEREO : ESD_MONO;
            break;

        case SNDCTL_DSP_GETBLKSIZE:
            *arg = ESD_BUF_SIZE;
            break;

        case SNDCTL_DSP_SETFRAGMENT:
        {
            audio_buf_info *bufinfo = (audio_buf_info *) argp;
            bufinfo->bytes = ESD_BUF_SIZE;
            printf("Setting Fragment to: %d, %d\n", *arg, bufinfo->bytes);
        }
            break;

        case SNDCTL_DSP_GETFMTS:
            *arg = 0x38;
            break;

        case SNDCTL_DSP_GETCAPS:
            *arg = 0;
            break;

        case SNDCTL_DSP_GETISPACE:
        {
            audio_buf_info *bufinfo = (audio_buf_info *) argp;
            bufinfo->bytes = ESD_BUF_SIZE;
            printf("Setting ISpace to: %d, %d\n", *arg, bufinfo->bytes);
        }
            break;

        case SNDCTL_DSP_GETOSPACE:
        {
            audio_buf_info *bufinfo = (audio_buf_info *) argp;
            bufinfo->bytes = ESD_BUF_SIZE;
            printf("Setting OSpace to: %d, %d\n", *arg, bufinfo->bytes);
        }
            break;

        case SNDCTL_DSP_GETTRIGGER:
        case SNDCTL_DSP_SETTRIGGER:
            /* XXX Do nothing for now. */
            *arg = PCM_ENABLE_OUTPUT;
            break;


        default:
            DPRINTF ("unhandled /dev/dsp ioctl (%x - %p)\n", request, argp);
            break;
    }

    if (settings == 3 && !done)
    {
        int proto = ESD_PROTO_STREAM_PLAY;

        done = 1;

        if (real_write(sndfd, &proto, sizeof (proto)) != sizeof (proto))
            return -1;
        if (real_write(sndfd, &fmt, sizeof (fmt)) != sizeof (fmt))
            return -1;
        if (real_write(sndfd, &speed, sizeof (speed)) != sizeof (speed))
            return -1;
        if (real_write(sndfd, ident, ESD_NAME_MAX) != ESD_NAME_MAX)
            return -1;

        fmt = ESD_BITS16 | ESD_STEREO | ESD_STREAM | ESD_PLAY;
        speed = 0;

        if (use_mixer)
        {
            int esd = -1, player = -1;
            int left, right;

            while (player < 0)
                mix_init (&esd, &player);

            get_volume (&left, &right);

            DPRINTF ("panning %d - %d %d\n", player, left, right);
            esd_set_stream_pan (esd, player, left, right);
        }
    }

    return 0;
}

static int
mixctl (int fd, request_t request, void *argp)
{
    static int esd = -1, player = -1;
    static int left, right;

    int *arg = (int *) argp;

    switch (request)
    {
        case SOUND_MIXER_READ_DEVMASK:
            *arg = 5113;
            break;

        case SOUND_MIXER_READ_PCM:
            mix_init (&esd, &player);

            if (player > 0)
            {
                esd_info_t *all_info;

                all_info  = esd_get_all_info (esd);
                if (all_info)
                {
                    esd_player_info_t *player_info;

                    for (player_info = all_info->player_list; player_info;
                         player_info = player_info->next)
                        if (player_info->source_id == player)
                        {
                            *arg = ESD_VOL_TO_OSS (player_info->left_vol_scale,
                                                   player_info->right_vol_scale);
                        }

                            esd_free_all_info (all_info);
                }
                else
                    return -1;
            }
                else
                {
                    get_volume (&left, &right);
                    *arg = ESD_VOL_TO_OSS (left, right);
                }

                break;

        case SOUND_MIXER_WRITE_PCM:
            mix_init (&esd, &player);

            left  = OSS_VOL_TO_ESD_LEFT  (*arg);
            right = OSS_VOL_TO_ESD_RIGHT (*arg);

            set_volume (left, right);

            if (player > 0)
            {
                DPRINTF ("panning %d - %d %d\n", player, left, right);
                esd_set_stream_pan (esd, player, left, right);
            }

                break;

        default:
            DPRINTF ("unhandled /dev/mixer ioctl (%x - %p)\n", request, argp);
            break;
    }

    return 0;
}

int
liboss_ioctl (int fd, request_t request, va_list args)
{
    static int (*func) (int, request_t, void *) = NULL;
    void *argp;

    liboss_init ();
#ifndef HAVE_SYSCALLS
    if (!func)
        func = (int (*) (int, request_t, void *)) dlsym (REAL_LIBC, "_ioctl");
#endif
    
    argp = va_arg (args, void *);

    if (fd == sndfd)
        return dspctl (fd, request, argp);
    else if (fd == mixfd) {
        if(use_mixer)
            return mixctl (fd, request, argp);
    } else { /* (fd != sndfd && fd != mixfd) */
#ifndef HAVE_SYSCALLS
        return (*func) (fd, request, argp);
#else
        return syscall(SYS_ioctl,fd,request,argp);
#endif
    }
    return 0;
}

int
liboss_close (int fd)
{
    static int (*func) (int) = NULL;
#ifndef HAVE_SYSCALLS
    if (!func)
        func = (int (*) (int)) dlsym (REAL_LIBC, "_close");
#endif
    if (fd == sndfd)
        sndfd = -1;
    else if (fd == mixfd)
        mixfd = -1;
#ifndef HAVE_SYSCALLS
    return (*func) (fd);
#else
    return syscall(SYS_close,fd);
#endif
}

int
liboss_write (int play, const void *buf, size_t sz)
{
#if 0
    short* i;    
    for (i = (short*)buf; i < (short*)(buf + sz); ++i)
        *i = NXSwapShort(*i);
#endif
    return real_write(play,buf,sz);
}
