# !/bin/bash
# Override default values here
#CC=
#CXX=
#FC=
#CFLAGS=
#CXXFLAGS
#FFLAGS=

# Default build parameters
: ${BUILD_DIR:=`pwd`/build}
: ${INSTALL_DIR:=`pwd`/install}
: ${BUILD_TYPE:="RelWithDebInfo"}

: ${CC:="gcc"}
: ${CXX:="g++"}
: ${FC:="gfortran"}

: ${OCCA_ENABLE_DPCPP:="ON"}
: ${OCCA_ENABLE_OPENCL:="ON"}
: ${OCCA_ENABLE_CUDA:="ON"}
: ${OCCA_ENABLE_HIP="ON"}
: ${OCCA_ENABLE_OPENMP="ON"}
: ${OCCA_ENABLE_METAL="ON"}
: ${OCCA_ENABLE_FORTRAN="OFF"}
: ${OCCA_ENABLE_TESTS="ON"}
: ${OCCA_ENABLE_EXAMPLES="ON"}

cmake -S . -B ${BUILD_DIR} \
  -DCMAKE_BUILD_TYPE=${BUILD_TYPE} \
  -DCMAKE_INSTALL_PREFIX=${INSTALL_DIR} \
  -DCMAKE_C_COMPILER=${CC} \
  -DCMAKE_CXX_COMPILER=${CXX} \
  -DCMAKE_Fortran_COMPILER=${FC} \
  -DCMAKE_CXX_FLAGS="${CXXFLAGS}" \
  -DCMAKE_C_FLAGS="${CFLAGS}" \
  -DCMAKE_Fortran_FLAGS="${FFLAGS}" \
  -DOCCA_ENABLE_OPENMP=${OCCA_ENABLE_OPENMP} \
  -DOCCA_ENABLE_OPENCL=${OCCA_ENABLE_OPENCL} \
  -DOCCA_ENABLE_DPCPP=${OCCA_ENABLE_DPCPP} \
  -DOCCA_ENABLE_CUDA=${OCCA_ENABLE_CUDA} \
  -DOCCA_ENABLE_HIP=${OCCA_ENABLE_HIP} \
  -DOCCA_ENABLE_METAL=${OCCA_ENABLE_METAL} \
  -DOCCA_ENABLE_FORTRAN=${OCCA_ENABLE_FORTRAN} \
  -DOCCA_ENABLE_TESTS=${OCCA_ENABLE_TESTS} \
  -DOCCA_ENABLE_EXAMPLES=${OCCA_ENABLE_EXAMPLES}
