/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libnd_sll.h>


static LND_Protocol *sll;

static gboolean
sll_header_complete(const LND_Packet *packet, guchar *data)
{
  if (!data)
    return FALSE;

  return (data + SLL_HEADER_LEN <= libnd_packet_get_end(packet));
}


/* Plugin hook implementations: ---------------------------------------- */

const char *
name(void)
{
  return ("Linux SLL Plugin");
}


const char *
description(void)
{
  return ("A plugin providing support for the Linux sll "
	   "protocol for cooked packets.\n");
}


const char *
author(void)
{
  return ("Christian Kreibich, <christian@whoop.org>");
}


const char *
version(void)
{
  return VERSION;
}


LND_Protocol *
init(void)
{
  sll = libnd_proto_new("SLL", LND_PROTO_LAYER_LINK, DLT_LINUX_SLL);
			     		
  sll->init_packet     = libnd_sll_init_packet;
  sll->header_complete = libnd_sll_header_complete;
  
  return sll;
}


/* Protocol method implementations: ------------------------------------ */

guchar *
libnd_sll_init_packet(LND_Packet *packet, guchar *data, guchar *data_end)
{
  struct sll_header *sllhdr;
  LND_Protocol *payload_proto;
  
  D_ENTER;

  sllhdr = (struct sll_header *) data;
  
  if (!sll_header_complete(packet, data))
    {
      libnd_raw_proto_get()->init_packet(packet, data, data_end);
      D_RETURN_(data_end);
    }

  libnd_packet_add_proto_data(packet, sll, data, data_end);  
  
  /* Check the appriopriate header field value to demultiplex
     packet initialization up to the next correct protocol: */
  
  if (! (payload_proto = libnd_proto_registry_find(LND_PROTO_LAYER_LINK | LND_PROTO_LAYER_NET,
						   ntohs(sllhdr->sll_protocol))))
    payload_proto = libnd_raw_proto_get();
  
  payload_proto->init_packet(packet,
			     data + SLL_HEADER_LEN,
			     data_end);
  D_RETURN_(data_end);
}


gboolean
libnd_sll_header_complete(const LND_Packet *packet, guint nesting)
{
  guchar      *data;

  if (!packet)
    return FALSE;

  data = libnd_packet_get_data(packet, sll, 0);
  
  return sll_header_complete(packet, data);
  TOUCH(nesting);
}


LND_Protocol *
libnd_sll_get(void)
{
  return sll;
}

