/* lhtml_callback.c: callback interface
   Mooneer Salem <mooneer@translator.cx> */

/* includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "lhtml.h"

/* functions */

lhtml_callback_list *lhtml_add_callback(lhtml_callback_list *temp, enum lhtml_tag tag,
	char *other_tag, int end, enum lhtml_type type, 
	int (*func)(lhtml_tree *entry, void *data), void *data) {

	lhtml_callback_list *list, *tmp;

	list = (lhtml_callback_list*)malloc((size_t)sizeof(lhtml_callback_list));
	if (list == NULL) {
		/* Stop the presses! */
		return NULL;
	}

	list->func = func;
	list->tag = tag;
	list->other_tag = other_tag; /* if tag = TAG_OTHER and other_tag = NULL,
						then it is the default handler */
	list->end = end; /* end tags only? */
	list->type = type; /* tag type */
	list->data = data;
	list->next = NULL;

	if (temp == NULL) {
		return list;
	} else {
		tmp = temp;
		while(tmp->next != NULL) {
			tmp = tmp->next;
		}

		tmp->next = list;
	}

	return temp;
}

void lhtml_parse_tree (lhtml_tree *tree, lhtml_callback_list *list) {
	int retval;
	lhtml_callback_list *temp;

	while(tree != NULL) {
		temp = list;
		while(temp != NULL) {
			if (temp->tag == TAG_OTHER && temp->other_tag == NULL) {
				/* default handler */
				retval = (*temp->func)(tree, temp->data);
				if (retval == LHTML_CB_REJECTED) {
					temp = temp->next;
					continue;
				} else if (retval == LHTML_CB_CONTINUE) {
					break;
				} else if (retval == LHTML_CB_DONE) {
					return;
				}
			}

			if (tree->type == temp->type && tree->tag == temp->tag &&
				(tree->other_tag && temp->other_tag && 
				!lhtml_strcasecmp(tree->other_tag, temp->other_tag))
				&& tree->end == temp->end) {
				retval = (*temp->func)(tree, temp->data);
				if (retval == LHTML_CB_REJECTED) {
					temp = temp->next;
					continue;
				} else if (retval == LHTML_CB_CONTINUE) {
					break;
				} else if (retval == LHTML_CB_DONE) {
					return;
				}
			}

			temp = temp->next;
		}
		if (tree->children != NULL) lhtml_parse_tree (tree->children, list);
		tree = tree->next;
	}
}

void lhtml_callback_free (lhtml_callback_list *list) {
	lhtml_callback_list *temp;

	while(list != NULL) {
		temp = list;
		list = list->next;
		free(temp);
	}
}
