/* This file is part of HSPlasma.
 *
 * HSPlasma is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * HSPlasma is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HSPlasma.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "plNodeRegionModifier.h"

plNodeRegionModifier::plNodeRegionModifier() : fEnabled(true) { }

void plNodeRegionModifier::read(hsStream* S, plResManager* mgr) {
    plSingleModifier::read(S, mgr);
    fEnabled = S->readBool();
}

void plNodeRegionModifier::write(hsStream* S, plResManager* mgr) {
    plSingleModifier::write(S, mgr);
    S->writeBool(fEnabled);
}

void plNodeRegionModifier::IPrcWrite(pfPrcHelper* prc) {
    plSingleModifier::IPrcWrite(prc);

    prc->startTag("NodeRegionParams");
    prc->writeParam("Enabled", fEnabled);
    prc->endTag(true);
}

void plNodeRegionModifier::IPrcParse(const pfPrcTag* tag, plResManager* mgr) {
    if (tag->getName() == "NodeRegionParams") {
        fEnabled = tag->getParam("Enabled", "true").toBool();
    } else {
        plSingleModifier::IPrcParse(tag, mgr);
    }
}
