/* This file is part of HSPlasma.
 *
 * HSPlasma is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * HSPlasma is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HSPlasma.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <PyPlasma.h>
#include <PRP/KeyedObject/hsKeyedObject.h>
#include "pyKeyedObject.h"
#include "pyKey.h"
#include "PRP/pyCreatable.h"

extern "C" {

static int pyKeyedObjectStub___init__(pyKeyedObjectStub* self, PyObject* args, PyObject* kwds) {
    const char* name = "";
    if (!PyArg_ParseTuple(args, "|s", &name)) {
        PyErr_SetString(PyExc_TypeError, "__init__ expects an optional string");
        return -1;
    }

    self->fThis->init(name);
    return 0;
}

static PyObject* pyKeyedObjectStub_new(PyTypeObject* type, PyObject* args, PyObject* kwds) {
    pyKeyedObjectStub* self = (pyKeyedObjectStub*)type->tp_alloc(type, 0);
    if (self != NULL)
        self->fThis = new hsKeyedObjectStub();
    return (PyObject*)self;
}

static PyObject* pyKeyedObjectStub_getStub(pyKeyedObjectStub* self, void*) {
    if (self->fThis->getStub() != NULL) {
        return pyCreatableStub_FromCreatableStub(self->fThis->getStub());
    } else {
        Py_INCREF(Py_None);
        return Py_None;
    }
}

static int pyKeyedObjectStub_setStub(pyKeyedObjectStub* self, PyObject* value, void*) {
    PyErr_SetString(PyExc_RuntimeError, "stub is read-only");
    return -1;
}

static PyMethodDef pyKeyedObjectStub_Methods[] = {
    { NULL, NULL, 0, NULL }
};

static PyGetSetDef pyKeyedObjectStub_GetSet[] = {
    { "stub", (getter)pyKeyedObjectStub_getStub,
              (setter)pyKeyedObjectStub_setStub,
      "The plCreatableStub for this object", NULL },
    { NULL, NULL, NULL, NULL, NULL }
};

PyTypeObject pyKeyedObjectStub_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    "PyPlasma.hsKeyedObjectStub",       /* tp_name */
    sizeof(pyKeyedObjectStub),          /* tp_basicsize */
    0,                                  /* tp_itemsize */

    NULL,                               /* tp_dealloc */
    NULL,                               /* tp_print */
    NULL,                               /* tp_getattr */
    NULL,                               /* tp_setattr */
    NULL,                               /* tp_compare */
    NULL,                               /* tp_repr */
    NULL,                               /* tp_as_number */
    NULL,                               /* tp_as_sequence */
    NULL,                               /* tp_as_mapping */
    NULL,                               /* tp_hash */
    NULL,                               /* tp_call */
    NULL,                               /* tp_str */
    NULL,                               /* tp_getattro */
    NULL,                               /* tp_setattro */
    NULL,                               /* tp_as_buffer */

    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    "hsKeyedObjectStub wrapper",            /* tp_doc */

    NULL,                               /* tp_traverse */
    NULL,                               /* tp_clear */
    NULL,                               /* tp_richcompare */
    0,                                  /* tp_weaklistoffset */
    NULL,                               /* tp_iter */
    NULL,                               /* tp_iternext */

    pyKeyedObjectStub_Methods,          /* tp_methods */
    NULL,                               /* tp_members */
    pyKeyedObjectStub_GetSet,           /* tp_getset */
    NULL,                               /* tp_base */
    NULL,                               /* tp_dict */
    NULL,                               /* tp_descr_get */
    NULL,                               /* tp_descr_set */
    0,                                  /* tp_dictoffset */

    (initproc)pyKeyedObjectStub___init__,   /* tp_init */
    NULL,                               /* tp_alloc */
    pyKeyedObjectStub_new,              /* tp_new */
    NULL,                               /* tp_free */
    NULL,                               /* tp_is_gc */

    NULL,                               /* tp_bases */
    NULL,                               /* tp_mro */
    NULL,                               /* tp_cache */
    NULL,                               /* tp_subclasses */
    NULL,                               /* tp_weaklist */

    NULL,                               /* tp_del */
    TP_VERSION_TAG_INIT                 /* tp_version_tag */
};

PyObject* Init_pyKeyedObjectStub_Type() {
    pyKeyedObjectStub_Type.tp_base = &pyCreatable_Type;
    if (PyType_Ready(&pyKeyedObjectStub_Type) < 0)
        return NULL;

    Py_INCREF(&pyKeyedObjectStub_Type);
    return (PyObject*)&pyKeyedObjectStub_Type;
}

int pyKeyedObjectStub_Check(PyObject* obj) {
    if (obj->ob_type == &pyKeyedObjectStub_Type
        || PyType_IsSubtype(obj->ob_type, &pyKeyedObjectStub_Type))
        return 1;
    return 0;
}

PyObject* pyKeyedObjectStub_FromKeyedObjectStub(class hsKeyedObjectStub* obj) {
    if (obj == NULL) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    pyKeyedObjectStub* ko = PyObject_New(pyKeyedObjectStub, &pyKeyedObjectStub_Type);
    ko->fThis = obj;
    ko->fPyOwned = false;
    return (PyObject*)ko;
}

}
