// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_CONNECTION_H
#define _LIBGDAMM_CONNECTION_H

#include <glibmm.h>

/* $Id: connection.hg,v 1.18 2004/11/28 15:07:16 murrayc Exp $ */
// -*- C++ -*- // 

/* connection.h
 * 
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/transaction.h>
#include <libgdamm/error.h>
#include <libgdamm/command.h>
#include <libgdamm/datamodel.h>
#include <libgdamm/parameterlist.h>
#include <libgda/gda-connection.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaConnection GdaConnection;
typedef struct _GdaConnectionClass GdaConnectionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Connection_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class Client;

/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum ConnectionFeature
{
  CONNECTION_FEATURE_AGGREGATES,
  CONNECTION_FEATURE_INDEXES,
  CONNECTION_FEATURE_INHERITANCE,
  CONNECTION_FEATURE_NAMESPACES,
  CONNECTION_FEATURE_PROCEDURES,
  CONNECTION_FEATURE_SEQUENCES,
  CONNECTION_FEATURE_SQL,
  CONNECTION_FEATURE_TRANSACTIONS,
  CONNECTION_FEATURE_TRIGGERS,
  CONNECTION_FEATURE_USERS,
  CONNECTION_FEATURE_VIEWS,
  CONNECTION_FEATURE_XML_QUERIES,
  CONNECTION_FEATURE_BLOBS
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConnectionFeature> : public Glib::Value_Enum<Gnome::Gda::ConnectionFeature>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 */
enum ConnectionSchema
{
  CONNECTION_SCHEMA_AGGREGATES,
  CONNECTION_SCHEMA_DATABASES,
  CONNECTION_SCHEMA_FIELDS,
  CONNECTION_SCHEMA_INDEXES,
  CONNECTION_SCHEMA_LANGUAGES,
  CONNECTION_SCHEMA_NAMESPACES,
  CONNECTION_SCHEMA_PARENT_TABLES,
  CONNECTION_SCHEMA_PROCEDURES,
  CONNECTION_SCHEMA_SEQUENCES,
  CONNECTION_SCHEMA_TABLES,
  CONNECTION_SCHEMA_TRIGGERS,
  CONNECTION_SCHEMA_TYPES,
  CONNECTION_SCHEMA_USERS,
  CONNECTION_SCHEMA_VIEWS
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConnectionSchema> : public Glib::Value_Enum<Gnome::Gda::ConnectionSchema>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 * @par Bitwise operators:
 * <tt>%ConnectionOptions operator|(ConnectionOptions, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions operator&(ConnectionOptions, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions operator^(ConnectionOptions, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions operator~(ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions& operator|=(ConnectionOptions&, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions& operator&=(ConnectionOptions&, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions& operator^=(ConnectionOptions&, ConnectionOptions)</tt><br>
 */
enum ConnectionOptions
{
  CONNECTION_OPTIONS_READ_ONLY = 1 << 0
};

/** @ingroup libgdammEnums */
inline ConnectionOptions operator|(ConnectionOptions lhs, ConnectionOptions rhs)
  { return static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline ConnectionOptions operator&(ConnectionOptions lhs, ConnectionOptions rhs)
  { return static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline ConnectionOptions operator^(ConnectionOptions lhs, ConnectionOptions rhs)
  { return static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline ConnectionOptions operator~(ConnectionOptions flags)
  { return static_cast<ConnectionOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgdammEnums */
inline ConnectionOptions& operator|=(ConnectionOptions& lhs, ConnectionOptions rhs)
  { return (lhs = static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline ConnectionOptions& operator&=(ConnectionOptions& lhs, ConnectionOptions rhs)
  { return (lhs = static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline ConnectionOptions& operator^=(ConnectionOptions& lhs, ConnectionOptions rhs)
  { return (lhs = static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConnectionOptions> : public Glib::Value_Flags<Gnome::Gda::ConnectionOptions>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


class Connection : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Connection CppObjectType;
  typedef Connection_Class CppClassType;
  typedef GdaConnection BaseObjectType;
  typedef GdaConnectionClass BaseClassType;

private:  friend class Connection_Class;
  static CppClassType connection_class_;

private:
  // noncopyable
  Connection(const Connection&);
  Connection& operator=(const Connection&);

protected:
  explicit Connection(const Glib::ConstructParams& construct_params);
  explicit Connection(GdaConnection* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Connection();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaConnection*       gobj()       { return reinterpret_cast<GdaConnection*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaConnection* gobj() const { return reinterpret_cast<GdaConnection*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaConnection* gobj_copy();

private:

protected:

  Connection();
  

public:
  
  static Glib::RefPtr<Connection> create();


  bool close();
  
  
  bool is_open() const;

  
  Glib::RefPtr<Client> get_client();
  
  Glib::RefPtr<const Client> get_client() const;
    
  
  void set_client(const Glib::RefPtr<Client>& client);

  
  ConnectionOptions get_options() const;
  
  Glib::ustring get_server_version() const;

  
  Glib::ustring get_database() const;
  
  Glib::ustring get_dsn() const;
  
  Glib::ustring get_cnc_string() const;
  
  Glib::ustring get_provider() const;
  
  Glib::ustring get_username() const;
  
  Glib::ustring get_password() const;

  
  void add_error(const Glib::RefPtr<Error>& error);
  
  void add_error(const Glib::ustring& error);
  //TODO: Use ListHandle:
  
  void add_error_list(GList *error_list);

  
  bool change_database(const Glib::ustring& name);
  
  bool create_database(const Glib::ustring& name);
  
  bool drop_database(const Glib::ustring& name);

  //TODO:

   //Use deep ownership because we own both the list and its elements;
   

  Glib::ListHandle< Glib::RefPtr<DataModel> > execute_command(const Command& cmd, const ParameterList& params);
  Glib::ListHandle< Glib::RefPtr<DataModel> > execute_command(const Command& cmd);
  
  
  Glib::RefPtr<DataModel> execute_single_command(const Command& cmd, const ParameterList& params);
  Glib::RefPtr<DataModel> execute_single_command(const Command& cmd);
  Glib::RefPtr<DataModel> execute_single_command(const Glib::ustring& cmd);
    
  
  int execute_non_query(const Command& cmd, const ParameterList& params);
  int execute_non_query(const Command& cmd);
  
  
  bool begin_transaction(const Glib::RefPtr<Transaction>& transaction);
  
  bool commit_transaction(const Glib::RefPtr<Transaction>& transaction);
  
  bool rollback_transaction(const Glib::RefPtr<Transaction>& transaction);

   //Use a special conversion here, because we should not own any part of the returned GList, and because we need to unconst the GList.:
    

  Glib::ListHandle< Glib::RefPtr<Error> > get_errors();
  
  Glib::ListHandle< Glib::RefPtr<const Error> > get_errors() const;

  //TODO: Use C++ type:
  
  bool create_blob(GdaBlob* blob);

  
  bool supports(ConnectionFeature feature) const;

  
  Glib::RefPtr<DataModel> get_schema(ConnectionSchema schema, const ParameterList& params);
  
  Glib::RefPtr<const DataModel> get_schema(ConnectionSchema schema, const ParameterList& params) const;

  Glib::RefPtr<DataModel> get_schema(ConnectionSchema schema);
  Glib::RefPtr<const DataModel> get_schema(ConnectionSchema schema) const;

  
  Glib::ustring get_last_insert_id(const Glib::RefPtr<DataModel>& recset) const; 
  
  
  Glib::SignalProxy1< void,GList* > signal_error();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_error(GList* error_list);


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::Connection
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::Connection> wrap(GdaConnection* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_CONNECTION_H */

