/* CheckTable.c generated by valac 0.40.8.18-c87af, the Vala compiler
 * generated from CheckTable.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata Unit Tests
 * Copyright (C) Daniel Espinosa Ortiz 2012 <esodan@gmail.com>
 *
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <libgda/data/libgdadata.h>
#include <libgda/libgda.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define CHECK_TYPE_TESTS (check_tests_get_type ())
#define CHECK_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECK_TYPE_TESTS, CheckTests))
#define CHECK_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECK_TYPE_TESTS, CheckTestsClass))
#define CHECK_IS_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECK_TYPE_TESTS))
#define CHECK_IS_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECK_TYPE_TESTS))
#define CHECK_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECK_TYPE_TESTS, CheckTestsClass))

typedef struct _CheckTests CheckTests;
typedef struct _CheckTestsClass CheckTestsClass;
typedef struct _CheckTestsPrivate CheckTestsPrivate;
enum  {
	CHECK_TESTS_0_PROPERTY,
	CHECK_TESTS_CONNECTION_PROPERTY,
	CHECK_TESTS_NUM_PROPERTIES
};
static GParamSpec* check_tests_properties[CHECK_TESTS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _gda_data_db_field_info_foreign_key_unref0(var) ((var == NULL) ? NULL : (var = (gda_data_db_field_info_foreign_key_unref (var), NULL)))

struct _CheckTests {
	GObject parent_instance;
	CheckTestsPrivate * priv;
	GdaDataDbTable* table;
};

struct _CheckTestsClass {
	GObjectClass parent_class;
};

struct _CheckTestsPrivate {
	GdaConnection* _connection;
};


static gpointer check_tests_parent_class = NULL;

GType check_tests_get_type (void) G_GNUC_CONST;
#define CHECK_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHECK_TYPE_TESTS, CheckTestsPrivate))
static CheckTests* check_tests_new (void);
static CheckTests* check_tests_construct (GType object_type);
void check_tests_set_connection (CheckTests* self,
                                 GdaConnection* value);
GdaConnection* check_tests_get_connection (CheckTests* self);
static void check_tests_Init_sqlite (CheckTests* self,
                              GError** error);
static void check_tests_init_pg (CheckTests* self,
                          GError** error);
void check_tests_init (CheckTests* self,
                       GError** error);
gint check_tests_update (CheckTests* self,
                         GError** error);
gint check_tests_fields (CheckTests* self,
                         GError** error);
gint check_tests_records (CheckTests* self,
                          GError** error);
static void check_tests_create_table_definition (CheckTests* self,
                                          GdaDataDbTable* t,
                                          GError** error);
static void _vala_GValue_free (GValue* self);
gint check_tests_equivalent (CheckTests* self,
                             GError** error);
gint check_tests_compatible (CheckTests* self,
                             GError** error);
gint check_tests_append (CheckTests* self,
                         GError** error);
gint check_tests_drop (CheckTests* self,
                       GError** error);
gint check_tests_save (CheckTests* self,
                       GError** error);
gint check_tests_main (gchar** args,
                       int args_length1);
static void check_tests_finalize (GObject * obj);
static void _vala_check_tests_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_check_tests_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);


static CheckTests*
check_tests_construct (GType object_type)
{
	CheckTests * self = NULL;
	GError * _inner_error_ = NULL;
	self = (CheckTests*) g_object_new (object_type, NULL);
	{
		g_unlink ("table.db");
		{
			GdaConnection* _tmp0_ = NULL;
			GdaConnection* _tmp1_;
			GdaConnection* _tmp2_;
			_tmp1_ = gda_connection_open_from_string ("SQLite", "DB_DIR=.;DB_NAME=table", NULL, GDA_CONNECTION_OPTIONS_NONE, &_inner_error_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
			check_tests_set_connection (self, _tmp0_);
			_tmp2_ = self->priv->_connection;
			if (gda_connection_is_opened (_tmp2_)) {
				FILE* _tmp3_;
				_tmp3_ = stdout;
				fprintf (_tmp3_, "%s", "Using SQLite provider. " "Creating Database...\n");
				check_tests_Init_sqlite (self, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (_tmp0_);
					goto __catch1_g_error;
				}
			}
			_g_object_unref0 (_tmp0_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_strconcat ("Couln't initalize database...\nERROR: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "\n", NULL);
		_tmp9_ = _tmp8_;
		g_warning ("CheckTable.vala:49: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static CheckTests*
check_tests_new (void)
{
	return check_tests_construct (CHECK_TYPE_TESTS);
}


static void
check_tests_init_pg (CheckTests* self,
                     GError** error)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		FILE* _tmp8_;
		GdaConnection* _tmp9_;
		GdaConnection* _tmp10_;
		GdaConnection* _tmp11_;
		{
			GdaConnection* _tmp0_;
			_tmp0_ = self->priv->_connection;
			gda_connection_execute_non_select_command (_tmp0_, "DROP TABLE IF EXISTS company CASCADE", &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			FILE* _tmp1_;
			GError* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp1_ = stdout;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			_tmp4_ = g_strconcat ("Error on dopping table company: ", _tmp3_, NULL);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strconcat (_tmp5_, "\n", NULL);
			_tmp7_ = _tmp6_;
			fprintf (_tmp1_, "%s", _tmp7_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
			_g_error_free0 (e);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp8_ = stdout;
		fprintf (_tmp8_, "Creating table 'company'...\n");
		_tmp9_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp9_, "CREATE TABLE company (id serial PRIMARY KEY, " "name text, responsability text)", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp10_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp10_, "INSERT INTO company (name, responsability) " "VALUES (\'Telcsa\', \'Programing\')", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp11_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp11_, "INSERT INTO company (name, responsability) " "VALUES (\'Viasa\', \'Accessories\')", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stdout;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = g_strconcat ("Error on Create company table: ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "\n", NULL);
		_tmp18_ = _tmp17_;
		fprintf (_tmp12_, "%s", _tmp18_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	{
		FILE* _tmp27_;
		GdaConnection* _tmp28_;
		GdaConnection* _tmp29_;
		GdaConnection* _tmp30_;
		GdaConnection* _tmp31_;
		{
			GdaConnection* _tmp19_;
			_tmp19_ = self->priv->_connection;
			gda_connection_execute_non_select_command (_tmp19_, "DROP TABLE IF EXISTS customer CASCADE", &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch5_g_error;
			}
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* e = NULL;
			FILE* _tmp20_;
			GError* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp20_ = stdout;
			_tmp21_ = e;
			_tmp22_ = _tmp21_->message;
			_tmp23_ = g_strconcat ("Error on dopping table customer: ", _tmp22_, NULL);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat (_tmp24_, "\n", NULL);
			_tmp26_ = _tmp25_;
			fprintf (_tmp20_, "%s", _tmp26_);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp24_);
			_g_error_free0 (e);
		}
		__finally5:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp27_ = stdout;
		fprintf (_tmp27_, "Creating table 'customer'...\n");
		_tmp28_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp28_, "CREATE TABLE customer (id serial PRIMARY KEY, " "name text UNIQUE," " city text DEFAULT \'New Yield\'," " company integer REFERENCES company (id) " "ON DELETE SET NULL ON UPDATE CASCADE)", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp29_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp29_, "INSERT INTO customer (name, city, company) " "VALUES (\'Daniel\', \'Mexico\', 1)", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp30_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp30_, "INSERT INTO customer (name, city) VALUES " "(\'Jhon\', \'Springfield\')", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp31_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp31_, "INSERT INTO customer (name) VALUES (\'Jack\')", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		FILE* _tmp32_;
		GError* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp32_ = stdout;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		_tmp35_ = g_strconcat ("Error on Create customer table: ", _tmp34_, NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat (_tmp36_, "\n", NULL);
		_tmp38_ = _tmp37_;
		fprintf (_tmp32_, "%s", _tmp38_);
		_g_free0 (_tmp38_);
		_g_free0 (_tmp36_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	{
		FILE* _tmp47_;
		GdaConnection* _tmp48_;
		GdaConnection* _tmp49_;
		GdaConnection* _tmp50_;
		GdaConnection* _tmp51_;
		{
			GdaConnection* _tmp39_;
			_tmp39_ = self->priv->_connection;
			gda_connection_execute_non_select_command (_tmp39_, "DROP TABLE IF EXISTS salary CASCADE", &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch7_g_error;
			}
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* e = NULL;
			FILE* _tmp40_;
			GError* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp40_ = stdout;
			_tmp41_ = e;
			_tmp42_ = _tmp41_->message;
			_tmp43_ = g_strconcat ("Error on dopping table salary: ", _tmp42_, NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_strconcat (_tmp44_, "\n", NULL);
			_tmp46_ = _tmp45_;
			fprintf (_tmp40_, "%s", _tmp46_);
			_g_free0 (_tmp46_);
			_g_free0 (_tmp44_);
			_g_error_free0 (e);
		}
		__finally7:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp47_ = stdout;
		fprintf (_tmp47_, "Creating table 'salary'...\n");
		_tmp48_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp48_, "CREATE TABLE salary (id serial PRIMARY KEY," " customer integer REFERENCES customer (id) " " ON DELETE CASCADE ON UPDATE CASCADE," " income float DEFAULT 10.0)", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp49_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp49_, "INSERT INTO salary (customer, income) VALUES " " (1,55.0)", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp50_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp50_, "INSERT INTO salary (customer, income) VALUES " " (2,65.0)", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp51_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp51_, "INSERT INTO salary (customer) VALUES (3)", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp52_;
		GError* _tmp53_;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp52_ = stdout;
		_tmp53_ = e;
		_tmp54_ = _tmp53_->message;
		_tmp55_ = g_strconcat ("Error on Create company table: ", _tmp54_, NULL);
		_tmp56_ = _tmp55_;
		_tmp57_ = g_strconcat (_tmp56_, "\n", NULL);
		_tmp58_ = _tmp57_;
		fprintf (_tmp52_, "%s", _tmp58_);
		_g_free0 (_tmp58_);
		_g_free0 (_tmp56_);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void
check_tests_Init_sqlite (CheckTests* self,
                         GError** error)
{
	GdaConnection* _tmp0_;
	GdaConnection* _tmp1_;
	GdaConnection* _tmp2_;
	FILE* _tmp3_;
	GdaConnection* _tmp4_;
	GdaConnection* _tmp5_;
	GdaConnection* _tmp6_;
	GdaConnection* _tmp7_;
	FILE* _tmp8_;
	GdaConnection* _tmp9_;
	GdaConnection* _tmp10_;
	GdaConnection* _tmp11_;
	GdaConnection* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp0_, "CREATE TABLE company (id int PRIMARY KEY, " "name string, responsability string)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp1_, "INSERT INTO company (id, name, responsability) " "VALUES (1, \"Telcsa\", \"Programing\")", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp2_, "INSERT INTO company (id, name, responsability) " "VALUES (2, \"Viasa\", \"Accessories\")", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = stdout;
	fprintf (_tmp3_, "Creating table 'customer'...\n");
	_tmp4_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp4_, "CREATE TABLE customer (id integer PRIMARY KEY AUTOINCREMENT," " name string UNIQUE," " city string DEFAULT \'New Yield\'," " company integer REFERENCES company (id) " "ON DELETE SET NULL ON UPDATE CASCADE)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp5_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp5_, "INSERT INTO customer (id, name, city, company) " "VALUES (1, \"Daniel\", \"Mexico\", 1)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp6_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp6_, "INSERT INTO customer (id, name, city) VALUES (2, " "\"Jhon\", \"Springfield\")", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp7_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp7_, "INSERT INTO customer (id, name) VALUES (3, \"Jack\")", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp8_ = stdout;
	fprintf (_tmp8_, "Creating table 'salary'...\n");
	_tmp9_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp9_, "CREATE TABLE salary (id integer PRIMARY KEY AUTOINCREMENT," " customer integer REFERENCES customer (id)" " ON DELETE CASCADE ON UPDATE CASCADE," " income float DEFAULT 10.0)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp10_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp10_, "INSERT INTO salary (id, customer, income) " "VALUES (1,1,55.0)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp11_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp11_, "INSERT INTO salary (id, customer, income) " "VALUES (2,2,65.0)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp12_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp12_, "INSERT INTO salary (customer) VALUES (3)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void
check_tests_init (CheckTests* self,
                  GError** error)
{
	FILE* _tmp0_;
	GdaDataTable* _tmp1_;
	FILE* _tmp2_;
	GdaDataDbTable* _tmp3_;
	GdaConnection* _tmp4_;
	FILE* _tmp5_;
	GdaDataDbTable* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\nCreating new table\n");
	_tmp1_ = gda_data_table_new ();
	_g_object_unref0 (self->table);
	self->table = (GdaDataDbTable*) _tmp1_;
	_tmp2_ = stdout;
	fprintf (_tmp2_, "Setting connection\n");
	_tmp3_ = self->table;
	_tmp4_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp3_, _tmp4_);
	_tmp5_ = stdout;
	fprintf (_tmp5_, "Setting name\n");
	_tmp6_ = self->table;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp6_, "customer");
}


gint
check_tests_update (CheckTests* self,
                    GError** error)
{
	gint result = 0;
	FILE* _tmp0_;
	gint fails = 0;
	FILE* _tmp1_;
	gint _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n\n\n>>>>>>>>>>>>>>> NEW TEST: GdaData.DbTable -- Update\n");
	fails = 0;
	_tmp1_ = stdout;
	fprintf (_tmp1_, ">>>>>> Updating meta information\n");
	{
		GdaDataDbTable* _tmp2_;
		GdaDataDbTable* _tmp3_;
		_tmp2_ = self->table;
		gda_data_db_object_set_update_meta ((GdaDataDbObject*) _tmp2_, TRUE);
		_tmp3_ = self->table;
		gda_data_db_object_update ((GdaDataDbObject*) _tmp3_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		gint _tmp4_;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = fails;
		fails = _tmp4_ + 1;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = g_strconcat ("Error on Updating: ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, "\n", NULL);
		_tmp11_ = _tmp10_;
		fprintf (_tmp5_, "%s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp12_ = -1;
		g_propagate_error (error, _inner_error_);
		return _tmp12_;
	}
	_tmp13_ = fails;
	if (_tmp13_ > 0) {
		FILE* _tmp14_;
		_tmp14_ = stdout;
		fprintf (_tmp14_, ">>>>>>>> FAIL <<<<<<<<<<<\n");
	} else {
		FILE* _tmp15_;
		_tmp15_ = stdout;
		fprintf (_tmp15_, ">>>>>>>> TEST PASS <<<<<<<<<<<\n");
	}
	result = fails;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


gint
check_tests_fields (CheckTests* self,
                    GError** error)
{
	gint result = 0;
	FILE* _tmp0_;
	gint fails = 0;
	GeeHashMap* f = NULL;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* f2 = NULL;
	GeeHashMap* _tmp25_;
	GeeHashMap* _tmp26_;
	GeeHashMap* _tmp27_;
	GeeHashMap* f3 = NULL;
	GeeHashMap* _tmp47_;
	GeeHashMap* _tmp48_;
	GeeHashMap* f4 = NULL;
	GeeHashMap* _tmp68_;
	GeeHashMap* _tmp69_;
	gint found = 0;
	GdaDataDbTable* _tmp128_;
	GdaConnection* _tmp129_;
	GdaConnection* _tmp130_;
	GdaServerProvider* _tmp131_;
	const gchar* _tmp132_;
	GdaDataFieldInfo* fl = NULL;
	GdaDataFieldInfo* _tmp134_;
	GdaDataFieldInfo* _tmp135_;
	GCompareFunc _tmp136_;
	GdaDataFieldInfo* _tmp137_;
	const gchar* _tmp138_;
	const gchar* _tmp139_;
	GdaDataFieldInfo* _tmp149_;
	GCompareFunc _tmp150_;
	GdaDataFieldInfo* _tmp151_;
	const gchar* _tmp152_;
	const gchar* _tmp153_;
	gint _tmp163_;
	gint _tmp166_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n\n\n>>>>>>>>>>>>>>> NEW TEST: Gda.DbTable - Fields...\n");
	fails = 0;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	f = _tmp1_;
	_tmp2_ = f;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, "id", (gpointer) ((gintptr) 0));
	_tmp3_ = f;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, "name", (gpointer) ((gintptr) 0));
	_tmp4_ = f;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, "city", (gpointer) ((gintptr) 0));
	_tmp5_ = f;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, "company", (gpointer) ((gintptr) 0));
	{
		GeeIterator* _fi_it = NULL;
		GdaDataDbTable* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp6_ = self->table;
		_tmp7_ = gda_data_db_table_get_fields (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_fi_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			GdaDataDbFieldInfo* fi = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			GeeHashMap* _tmp15_;
			GeeSet* _tmp16_;
			GeeSet* _tmp17_;
			GeeSet* _tmp18_;
			GdaDataDbFieldInfo* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gboolean _tmp22_;
			_tmp12_ = _fi_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _fi_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			fi = (GdaDataDbFieldInfo*) _tmp14_;
			_tmp15_ = f;
			_tmp16_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_;
			_tmp19_ = fi;
			_tmp20_ = gda_data_db_field_info_get_name (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = !gee_collection_contains ((GeeCollection*) _tmp18_, _tmp21_);
			_g_object_unref0 (_tmp18_);
			if (_tmp22_) {
				gint _tmp23_;
				FILE* _tmp24_;
				_tmp23_ = fails;
				fails = _tmp23_ + 1;
				_tmp24_ = stdout;
				fprintf (_tmp24_, ">>>>>>>> Check Fields names:  FAIL\n");
				_g_object_unref0 (fi);
				break;
			}
			_g_object_unref0 (fi);
		}
		_g_object_unref0 (_fi_it);
	}
	_tmp25_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	f2 = _tmp25_;
	_tmp26_ = f2;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, "id", (gpointer) ((gintptr) 0));
	_tmp27_ = f2;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, "name", (gpointer) ((gintptr) 0));
	{
		GeeIterator* _fi2_it = NULL;
		GdaDataDbTable* _tmp28_;
		GeeCollection* _tmp29_;
		GeeCollection* _tmp30_;
		GeeCollection* _tmp31_;
		GeeIterator* _tmp32_;
		GeeIterator* _tmp33_;
		_tmp28_ = self->table;
		_tmp29_ = gda_data_db_table_get_primary_keys (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_;
		_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
		_tmp33_ = _tmp32_;
		_g_object_unref0 (_tmp31_);
		_fi2_it = _tmp33_;
		while (TRUE) {
			GeeIterator* _tmp34_;
			GdaDataDbFieldInfo* fi2 = NULL;
			GeeIterator* _tmp35_;
			gpointer _tmp36_;
			GeeHashMap* _tmp37_;
			GeeSet* _tmp38_;
			GeeSet* _tmp39_;
			GeeSet* _tmp40_;
			GdaDataDbFieldInfo* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			gboolean _tmp44_;
			_tmp34_ = _fi2_it;
			if (!gee_iterator_next (_tmp34_)) {
				break;
			}
			_tmp35_ = _fi2_it;
			_tmp36_ = gee_iterator_get (_tmp35_);
			fi2 = (GdaDataDbFieldInfo*) _tmp36_;
			_tmp37_ = f2;
			_tmp38_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = _tmp39_;
			_tmp41_ = fi2;
			_tmp42_ = gda_data_db_field_info_get_name (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = !gee_collection_contains ((GeeCollection*) _tmp40_, _tmp43_);
			_g_object_unref0 (_tmp40_);
			if (_tmp44_) {
				FILE* _tmp45_;
				gint _tmp46_;
				_tmp45_ = stdout;
				fprintf (_tmp45_, ">>>>>>>> Check Primary Keys Fields:  FAIL\n");
				_tmp46_ = fails;
				fails = _tmp46_ + 1;
				_g_object_unref0 (fi2);
				break;
			}
			_g_object_unref0 (fi2);
		}
		_g_object_unref0 (_fi2_it);
	}
	_tmp47_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	f3 = _tmp47_;
	_tmp48_ = f3;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp48_, "company", (gpointer) ((gintptr) 0));
	{
		GeeIterator* _t_it = NULL;
		GdaDataDbTable* _tmp49_;
		GeeCollection* _tmp50_;
		GeeCollection* _tmp51_;
		GeeCollection* _tmp52_;
		GeeIterator* _tmp53_;
		GeeIterator* _tmp54_;
		_tmp49_ = self->table;
		_tmp50_ = gda_data_db_table_get_depends (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = _tmp51_;
		_tmp53_ = gee_iterable_iterator ((GeeIterable*) _tmp52_);
		_tmp54_ = _tmp53_;
		_g_object_unref0 (_tmp52_);
		_t_it = _tmp54_;
		while (TRUE) {
			GeeIterator* _tmp55_;
			GdaDataDbTable* t = NULL;
			GeeIterator* _tmp56_;
			gpointer _tmp57_;
			GeeHashMap* _tmp58_;
			GeeSet* _tmp59_;
			GeeSet* _tmp60_;
			GeeSet* _tmp61_;
			GdaDataDbTable* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			gboolean _tmp65_;
			_tmp55_ = _t_it;
			if (!gee_iterator_next (_tmp55_)) {
				break;
			}
			_tmp56_ = _t_it;
			_tmp57_ = gee_iterator_get (_tmp56_);
			t = (GdaDataDbTable*) _tmp57_;
			_tmp58_ = f3;
			_tmp59_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = _tmp60_;
			_tmp62_ = t;
			_tmp63_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = !gee_collection_contains ((GeeCollection*) _tmp61_, _tmp64_);
			_g_object_unref0 (_tmp61_);
			if (_tmp65_) {
				FILE* _tmp66_;
				gint _tmp67_;
				_tmp66_ = stdout;
				fprintf (_tmp66_, ">>>>>>>> Check Table Depends:  FAIL\n");
				_tmp67_ = fails;
				fails = _tmp67_ + 1;
				_g_object_unref0 (t);
				break;
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	_tmp68_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	f4 = _tmp68_;
	_tmp69_ = f4;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp69_, "salary", (gpointer) ((gintptr) 0));
	{
		GeeIterator* _t2_it = NULL;
		GdaDataDbTable* _tmp70_;
		GeeCollection* _tmp71_;
		GeeCollection* _tmp72_;
		GeeCollection* _tmp73_;
		GeeIterator* _tmp74_;
		GeeIterator* _tmp75_;
		_tmp70_ = self->table;
		_tmp71_ = gda_data_db_table_get_referenced (_tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = _tmp72_;
		_tmp74_ = gee_iterable_iterator ((GeeIterable*) _tmp73_);
		_tmp75_ = _tmp74_;
		_g_object_unref0 (_tmp73_);
		_t2_it = _tmp75_;
		while (TRUE) {
			GeeIterator* _tmp76_;
			GdaDataDbTable* t2 = NULL;
			GeeIterator* _tmp77_;
			gpointer _tmp78_;
			GeeHashMap* _tmp79_;
			GeeSet* _tmp80_;
			GeeSet* _tmp81_;
			GeeSet* _tmp82_;
			GdaDataDbTable* _tmp83_;
			const gchar* _tmp84_;
			const gchar* _tmp85_;
			gboolean _tmp86_;
			_tmp76_ = _t2_it;
			if (!gee_iterator_next (_tmp76_)) {
				break;
			}
			_tmp77_ = _t2_it;
			_tmp78_ = gee_iterator_get (_tmp77_);
			t2 = (GdaDataDbTable*) _tmp78_;
			_tmp79_ = f4;
			_tmp80_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = _tmp81_;
			_tmp83_ = t2;
			_tmp84_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp83_);
			_tmp85_ = _tmp84_;
			_tmp86_ = !gee_collection_contains ((GeeCollection*) _tmp82_, _tmp85_);
			_g_object_unref0 (_tmp82_);
			if (_tmp86_) {
				FILE* _tmp87_;
				gint _tmp88_;
				_tmp87_ = stdout;
				fprintf (_tmp87_, ">>>>>>>> Check Table Referenced by:  FAIL\n");
				_tmp88_ = fails;
				fails = _tmp88_ + 1;
				_g_object_unref0 (t2);
				break;
			}
			_g_object_unref0 (t2);
		}
		_g_object_unref0 (_t2_it);
	}
	found = 0;
	{
		GeeIterator* _fi3_it = NULL;
		GdaDataDbTable* _tmp89_;
		GeeCollection* _tmp90_;
		GeeCollection* _tmp91_;
		GeeCollection* _tmp92_;
		GeeIterator* _tmp93_;
		GeeIterator* _tmp94_;
		_tmp89_ = self->table;
		_tmp90_ = gda_data_db_table_get_fields (_tmp89_);
		_tmp91_ = _tmp90_;
		_tmp92_ = _tmp91_;
		_tmp93_ = gee_iterable_iterator ((GeeIterable*) _tmp92_);
		_tmp94_ = _tmp93_;
		_g_object_unref0 (_tmp92_);
		_fi3_it = _tmp94_;
		while (TRUE) {
			GeeIterator* _tmp95_;
			GdaDataDbFieldInfo* fi3 = NULL;
			GeeIterator* _tmp96_;
			gpointer _tmp97_;
			gboolean _tmp98_ = FALSE;
			GdaDataDbFieldInfo* _tmp99_;
			GdaDataDbFieldInfoAttribute _tmp100_;
			GdaDataDbFieldInfoAttribute _tmp101_;
			_tmp95_ = _fi3_it;
			if (!gee_iterator_next (_tmp95_)) {
				break;
			}
			_tmp96_ = _fi3_it;
			_tmp97_ = gee_iterator_get (_tmp96_);
			fi3 = (GdaDataDbFieldInfo*) _tmp97_;
			_tmp99_ = fi3;
			_tmp100_ = gda_data_db_field_info_get_attributes (_tmp99_);
			_tmp101_ = _tmp100_;
			if ((_tmp101_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT) {
				GdaDataDbFieldInfo* _tmp102_;
				const gchar* _tmp103_;
				const gchar* _tmp104_;
				_tmp102_ = fi3;
				_tmp103_ = gda_data_db_field_info_get_name (_tmp102_);
				_tmp104_ = _tmp103_;
				_tmp98_ = g_strcmp0 (_tmp104_, "city") == 0;
			} else {
				_tmp98_ = FALSE;
			}
			if (_tmp98_) {
				gint _tmp105_;
				GdaDataHandler* dh = NULL;
				GdaDataDbTable* _tmp106_;
				GdaConnection* _tmp107_;
				GdaConnection* _tmp108_;
				GdaServerProvider* _tmp109_;
				GdaDataDbTable* _tmp110_;
				GdaConnection* _tmp111_;
				GdaConnection* _tmp112_;
				GdaDataHandler* _tmp113_;
				GdaDataHandler* _tmp114_;
				GCompareFunc _tmp115_;
				GdaDataDbFieldInfo* _tmp116_;
				GValue* _tmp117_;
				GValue* _tmp118_;
				_tmp105_ = found;
				found = _tmp105_ + 1;
				_tmp106_ = self->table;
				_tmp107_ = gda_data_db_object_get_connection ((GdaDataDbObject*) _tmp106_);
				_tmp108_ = _tmp107_;
				_tmp109_ = gda_connection_get_provider (_tmp108_);
				_tmp110_ = self->table;
				_tmp111_ = gda_data_db_object_get_connection ((GdaDataDbObject*) _tmp110_);
				_tmp112_ = _tmp111_;
				_tmp113_ = gda_server_provider_get_data_handler_g_type (_tmp109_, _tmp112_, G_TYPE_STRING);
				_tmp114_ = _g_object_ref0 (_tmp113_);
				dh = _tmp114_;
				_tmp115_ = g_strcmp0;
				_tmp116_ = fi3;
				_tmp117_ = gda_data_db_field_info_get_default_value (_tmp116_);
				_tmp118_ = _tmp117_;
				if (_tmp115_ (g_value_get_string (_tmp118_), "New Yield") != 0) {
					gint _tmp119_;
					FILE* _tmp120_;
					GdaDataDbFieldInfo* _tmp121_;
					GValue* _tmp122_;
					GValue* _tmp123_;
					gchar* _tmp124_;
					gchar* _tmp125_;
					gchar* _tmp126_;
					gchar* _tmp127_;
					_tmp119_ = fails;
					fails = _tmp119_ + 1;
					_tmp120_ = stdout;
					_tmp121_ = fi3;
					_tmp122_ = gda_data_db_field_info_get_default_value (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = g_strconcat (">>>>>>>> Default Value No Match. Holded \'", g_value_get_string (_tmp123_), NULL);
					_tmp125_ = _tmp124_;
					_tmp126_ = g_strconcat (_tmp125_, "\' but Expected \'New Yield\' : FAIL\n", NULL);
					_tmp127_ = _tmp126_;
					fprintf (_tmp120_, "%s", _tmp127_);
					_g_free0 (_tmp127_);
					_g_free0 (_tmp125_);
				}
				_g_object_unref0 (dh);
				_g_object_unref0 (fi3);
				break;
			}
			_g_object_unref0 (fi3);
		}
		_g_object_unref0 (_fi3_it);
	}
	_tmp128_ = self->table;
	_tmp129_ = gda_data_db_object_get_connection ((GdaDataDbObject*) _tmp128_);
	_tmp130_ = _tmp129_;
	_tmp131_ = gda_connection_get_provider (_tmp130_);
	_tmp132_ = gda_server_provider_get_name (_tmp131_);
	if (g_strcmp0 (_tmp132_, "PostgreSQL") == 0) {
		gint _tmp133_;
		_tmp133_ = found;
		found = _tmp133_ + 1;
	}
	_tmp134_ = gda_data_field_info_new ();
	fl = _tmp134_;
	_tmp135_ = fl;
	gda_data_db_field_info_set_name ((GdaDataDbFieldInfo*) _tmp135_, "FieldName1");
	_tmp136_ = g_strcmp0;
	_tmp137_ = fl;
	_tmp138_ = gda_data_db_field_info_get_name ((GdaDataDbFieldInfo*) _tmp137_);
	_tmp139_ = _tmp138_;
	if (_tmp136_ (_tmp139_, "FieldName1") != 0) {
		gint _tmp140_;
		FILE* _tmp141_;
		GdaDataFieldInfo* _tmp142_;
		const gchar* _tmp143_;
		const gchar* _tmp144_;
		gchar* _tmp145_;
		gchar* _tmp146_;
		gchar* _tmp147_;
		gchar* _tmp148_;
		_tmp140_ = fails;
		fails = _tmp140_ + 1;
		_tmp141_ = stdout;
		_tmp142_ = fl;
		_tmp143_ = gda_data_db_field_info_get_name ((GdaDataDbFieldInfo*) _tmp142_);
		_tmp144_ = _tmp143_;
		_tmp145_ = g_strconcat (">>>>>>>> Default Value No Match. Holded \'", (const gchar*) _tmp144_, NULL);
		_tmp146_ = _tmp145_;
		_tmp147_ = g_strconcat (_tmp146_, "\' But Expected \"FieldName1\" : FAIL\n", NULL);
		_tmp148_ = _tmp147_;
		fprintf (_tmp141_, "%s", _tmp148_);
		_g_free0 (_tmp148_);
		_g_free0 (_tmp146_);
	}
	_tmp149_ = fl;
	gda_data_db_field_info_set_name ((GdaDataDbFieldInfo*) _tmp149_, "NewFieldName");
	_tmp150_ = g_strcmp0;
	_tmp151_ = fl;
	_tmp152_ = gda_data_db_field_info_get_name ((GdaDataDbFieldInfo*) _tmp151_);
	_tmp153_ = _tmp152_;
	if (_tmp150_ (_tmp153_, "NewFieldName") != 0) {
		gint _tmp154_;
		FILE* _tmp155_;
		GdaDataFieldInfo* _tmp156_;
		const gchar* _tmp157_;
		const gchar* _tmp158_;
		gchar* _tmp159_;
		gchar* _tmp160_;
		gchar* _tmp161_;
		gchar* _tmp162_;
		_tmp154_ = fails;
		fails = _tmp154_ + 1;
		_tmp155_ = stdout;
		_tmp156_ = fl;
		_tmp157_ = gda_data_db_field_info_get_name ((GdaDataDbFieldInfo*) _tmp156_);
		_tmp158_ = _tmp157_;
		_tmp159_ = g_strconcat (">>>>>>>> Default Value No Match. Holded \'", (const gchar*) _tmp158_, NULL);
		_tmp160_ = _tmp159_;
		_tmp161_ = g_strconcat (_tmp160_, "\' But Expected \"NewFieldName\" : FAIL\n", NULL);
		_tmp162_ = _tmp161_;
		fprintf (_tmp155_, "%s", _tmp162_);
		_g_free0 (_tmp162_);
		_g_free0 (_tmp160_);
	}
	_tmp163_ = found;
	if (_tmp163_ == 0) {
		FILE* _tmp164_;
		gint _tmp165_;
		_tmp164_ = stdout;
		fprintf (_tmp164_, ">>>>>>>> Check Default Values: FAIL\n");
		_tmp165_ = fails;
		fails = _tmp165_ + 1;
	}
	_tmp166_ = fails;
	if (_tmp166_ > 0) {
		FILE* _tmp167_;
		_tmp167_ = stdout;
		fprintf (_tmp167_, ">>>>>>>> FAIL <<<<<<<<<<<\n");
	} else {
		FILE* _tmp168_;
		_tmp168_ = stdout;
		fprintf (_tmp168_, ">>>>>>>> TEST PASS <<<<<<<<<<<\n");
	}
	result = fails;
	_g_object_unref0 (fl);
	_g_object_unref0 (f4);
	_g_object_unref0 (f3);
	_g_object_unref0 (f2);
	_g_object_unref0 (f);
	return result;
}


gint
check_tests_records (CheckTests* self,
                     GError** error)
{
	gint result = 0;
	FILE* _tmp0_;
	gint fails = 0;
	gint _tmp16_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n\n\n>>>>>>>>>>>>>>> NEW TEST: Gda.DbTable - Records...\n");
	fails = 0;
	{
		GeeIterator* _r_it = NULL;
		GdaDataDbTable* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->table;
		_tmp2_ = gda_data_db_table_get_records (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_r_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			GdaDataDbRecord* r = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			FILE* _tmp10_;
			GdaDataDbRecord* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp7_ = _r_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _r_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			r = (GdaDataDbRecord*) _tmp9_;
			_tmp10_ = stdout;
			_tmp11_ = r;
			_tmp12_ = gda_data_db_record_to_string (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat (_tmp13_, "\n", NULL);
			_tmp15_ = _tmp14_;
			fprintf (_tmp10_, "%s", _tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_it);
	}
	_tmp16_ = fails;
	if (_tmp16_ > 0) {
		FILE* _tmp17_;
		_tmp17_ = stdout;
		fprintf (_tmp17_, ">>>>>>>> FAIL <<<<<<<<<<<\n");
	} else {
		FILE* _tmp18_;
		_tmp18_ = stdout;
		fprintf (_tmp18_, ">>>>>>>> TEST PASS <<<<<<<<<<<\n");
	}
	result = fails;
	return result;
}


static void
_vala_GValue_free (GValue* self)
{
	g_value_unset (self);
	g_free (self);
}


static void
check_tests_create_table_definition (CheckTests* self,
                                     GdaDataDbTable* t,
                                     GError** error)
{
	GdaDataFieldInfo* field = NULL;
	GdaDataFieldInfo* _tmp0_;
	GdaDataFieldInfo* _tmp1_;
	GdaDataFieldInfo* _tmp2_;
	GdaDataFieldInfo* _tmp3_;
	GdaDataFieldInfo* _tmp4_;
	GdaDataFieldInfo* field1 = NULL;
	GdaDataFieldInfo* _tmp5_;
	GdaDataFieldInfo* _tmp6_;
	GdaDataFieldInfo* _tmp7_;
	GdaDataFieldInfo* _tmp8_;
	GdaDataFieldInfo* _tmp9_;
	GdaDataFieldInfo* field2 = NULL;
	GdaDataFieldInfo* _tmp10_;
	GdaDataFieldInfo* _tmp11_;
	GdaDataFieldInfo* _tmp12_;
	GdaDataFieldInfo* _tmp13_;
	GValue* _tmp14_ = NULL;
	GdaDataDbFieldInfoForeignKey* fk = NULL;
	GdaDataDbFieldInfoForeignKey* _tmp15_;
	GdaDataTable* rt = NULL;
	GdaDataTable* _tmp16_;
	GdaDataTable* _tmp17_;
	GdaDataDbFieldInfoForeignKey* _tmp18_;
	GdaDataTable* _tmp19_;
	GdaDataDbFieldInfoForeignKey* _tmp20_;
	GeeArrayList* _tmp21_;
	GeeArrayList* _tmp22_;
	GdaDataDbFieldInfoForeignKey* _tmp23_;
	GdaDataDbFieldInfoForeignKey* _tmp24_;
	GdaDataFieldInfo* _tmp25_;
	GdaDataDbFieldInfoForeignKey* _tmp26_;
	GdaDataFieldInfo* _tmp27_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = gda_data_field_info_new ();
	field = _tmp0_;
	_tmp1_ = field;
	gda_data_db_field_info_set_name ((GdaDataDbFieldInfo*) _tmp1_, "id");
	_tmp2_ = field;
	gda_data_db_field_info_set_value_type ((GdaDataDbFieldInfo*) _tmp2_, G_TYPE_INT);
	_tmp3_ = field;
	gda_data_db_field_info_set_attributes ((GdaDataDbFieldInfo*) _tmp3_, GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY | GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT);
	_tmp4_ = field;
	gda_data_db_table_set_field (t, (GdaDataDbFieldInfo*) _tmp4_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (field);
		return;
	}
	_tmp5_ = gda_data_field_info_new ();
	field1 = _tmp5_;
	_tmp6_ = field1;
	gda_data_db_field_info_set_name ((GdaDataDbFieldInfo*) _tmp6_, "name");
	_tmp7_ = field1;
	gda_data_db_field_info_set_value_type ((GdaDataDbFieldInfo*) _tmp7_, G_TYPE_STRING);
	_tmp8_ = field1;
	gda_data_db_field_info_set_attributes ((GdaDataDbFieldInfo*) _tmp8_, GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE);
	_tmp9_ = field1;
	gda_data_db_table_set_field (t, (GdaDataDbFieldInfo*) _tmp9_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (field1);
		_g_object_unref0 (field);
		return;
	}
	_tmp10_ = gda_data_field_info_new ();
	field2 = _tmp10_;
	_tmp11_ = field2;
	gda_data_db_field_info_set_name ((GdaDataDbFieldInfo*) _tmp11_, "company");
	_tmp12_ = field2;
	gda_data_db_field_info_set_value_type ((GdaDataDbFieldInfo*) _tmp12_, G_TYPE_INT);
	_tmp13_ = field2;
	_tmp14_ = g_new0 (GValue, 1);
	g_value_init (_tmp14_, G_TYPE_INT);
	g_value_set_int (_tmp14_, 1);
	gda_data_db_field_info_set_default_value ((GdaDataDbFieldInfo*) _tmp13_, _tmp14_);
	__vala_GValue_free0 (_tmp14_);
	_tmp15_ = gda_data_db_field_info_foreign_key_new ();
	fk = _tmp15_;
	_tmp16_ = gda_data_table_new ();
	rt = _tmp16_;
	_tmp17_ = rt;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp17_, "company");
	_tmp18_ = fk;
	_tmp19_ = rt;
	gda_data_db_field_info_foreign_key_set_reftable (_tmp18_, (GdaDataDbTable*) _tmp19_);
	_tmp20_ = fk;
	_tmp21_ = gda_data_db_field_info_foreign_key_get_refcol (_tmp20_);
	_tmp22_ = _tmp21_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, "id");
	_tmp23_ = fk;
	gda_data_db_field_info_foreign_key_set_update_rule (_tmp23_, GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_CASCADE);
	_tmp24_ = fk;
	gda_data_db_field_info_foreign_key_set_delete_rule (_tmp24_, GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_DEFAULT);
	_tmp25_ = field2;
	_tmp26_ = fk;
	gda_data_db_field_info_set_fkey ((GdaDataDbFieldInfo*) _tmp25_, _tmp26_);
	_tmp27_ = field2;
	gda_data_db_table_set_field (t, (GdaDataDbFieldInfo*) _tmp27_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rt);
		_gda_data_db_field_info_foreign_key_unref0 (fk);
		_g_object_unref0 (field2);
		_g_object_unref0 (field1);
		_g_object_unref0 (field);
		return;
	}
	_g_object_unref0 (rt);
	_gda_data_db_field_info_foreign_key_unref0 (fk);
	_g_object_unref0 (field2);
	_g_object_unref0 (field1);
	_g_object_unref0 (field);
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gint
check_tests_equivalent (CheckTests* self,
                        GError** error)
{
	gint result = 0;
	FILE* _tmp0_;
	GdaDataTable* t = NULL;
	GdaDataTable* _tmp1_;
	GdaDataTable* _tmp2_;
	GdaDataTable* _tmp3_;
	GdaDataTable* a = NULL;
	GdaDataTable* _tmp5_;
	GdaDataTable* _tmp6_;
	GdaDataTable* _tmp7_;
	GdaConnection* _tmp8_;
	GdaDataTable* _tmp9_;
	GdaDataTable* _tmp10_;
	FILE* _tmp12_;
	GdaDataTable* _tmp13_;
	GdaConnection* _tmp14_;
	GdaConnection* _tmp15_;
	GdaServerProvider* _tmp16_;
	const gchar* _tmp17_;
	GdaDataTable* _tmp63_;
	GdaDataTable* _tmp64_;
	FILE* _tmp110_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n\n\n>>>>>>>>>>>>>>> NEW TEST: Gda.DbTable - equivalent...\n");
	_tmp1_ = gda_data_table_new ();
	t = _tmp1_;
	_tmp2_ = t;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp2_, "created_table");
	_tmp3_ = t;
	check_tests_create_table_definition (self, (GdaDataDbTable*) _tmp3_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp4_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return _tmp4_;
	}
	_tmp5_ = gda_data_table_new ();
	a = _tmp5_;
	_tmp6_ = a;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp6_, "created_table");
	_tmp7_ = a;
	_tmp8_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp7_, _tmp8_);
	_tmp9_ = a;
	gda_data_db_object_set_update_meta ((GdaDataDbObject*) _tmp9_, TRUE);
	_tmp10_ = a;
	gda_data_db_object_update ((GdaDataDbObject*) _tmp10_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp11_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (a);
		_g_object_unref0 (t);
		return _tmp11_;
	}
	_tmp12_ = stdout;
	_tmp13_ = a;
	_tmp14_ = gda_data_db_object_get_connection ((GdaDataDbObject*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = gda_connection_get_provider (_tmp15_);
	_tmp17_ = gda_server_provider_get_name (_tmp16_);
	fprintf (_tmp12_, "Current Provider: %s", _tmp17_);
	{
		GeeCollection* rs = NULL;
		GdaDataTable* _tmp18_;
		GeeCollection* _tmp19_;
		GeeCollection* _tmp20_;
		FILE* _tmp21_;
		GdaDataTable* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		FILE* _tmp39_;
		GdaDataTable* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp18_ = a;
		_tmp19_ = gda_data_db_table_get_records ((GdaDataDbTable*) _tmp18_);
		_tmp20_ = _tmp19_;
		rs = _tmp20_;
		_tmp21_ = stdout;
		_tmp22_ = a;
		_tmp23_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat ("Records in DATABASE table: ", _tmp25_, "\n", NULL);
		_tmp27_ = _tmp26_;
		fprintf (_tmp21_, "%s", _tmp27_);
		_g_free0 (_tmp27_);
		{
			GeeIterator* _r_it = NULL;
			GeeCollection* _tmp28_;
			GeeIterator* _tmp29_;
			_tmp28_ = rs;
			_tmp29_ = gee_iterable_iterator ((GeeIterable*) _tmp28_);
			_r_it = _tmp29_;
			while (TRUE) {
				GeeIterator* _tmp30_;
				GdaDataDbRecord* r = NULL;
				GeeIterator* _tmp31_;
				gpointer _tmp32_;
				FILE* _tmp33_;
				GdaDataDbRecord* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp30_ = _r_it;
				if (!gee_iterator_next (_tmp30_)) {
					break;
				}
				_tmp31_ = _r_it;
				_tmp32_ = gee_iterator_get (_tmp31_);
				r = (GdaDataDbRecord*) _tmp32_;
				_tmp33_ = stdout;
				_tmp34_ = r;
				_tmp35_ = gda_data_db_record_to_string (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_strconcat (_tmp36_, "\n", NULL);
				_tmp38_ = _tmp37_;
				fprintf (_tmp33_, "%s", _tmp38_);
				_g_free0 (_tmp38_);
				_g_free0 (_tmp36_);
				_g_object_unref0 (r);
			}
			_g_object_unref0 (_r_it);
		}
		_tmp39_ = stdout;
		_tmp40_ = a;
		_tmp41_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = string_to_string (_tmp42_);
		_tmp44_ = g_strconcat ("Fields in DATABASE table: ", _tmp43_, "\n", NULL);
		_tmp45_ = _tmp44_;
		fprintf (_tmp39_, "%s", _tmp45_);
		_g_free0 (_tmp45_);
		{
			GeeIterator* _f2_it = NULL;
			GdaDataTable* _tmp46_;
			GeeCollection* _tmp47_;
			GeeCollection* _tmp48_;
			GeeCollection* _tmp49_;
			GeeIterator* _tmp50_;
			GeeIterator* _tmp51_;
			_tmp46_ = a;
			_tmp47_ = gda_data_db_table_get_fields ((GdaDataDbTable*) _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _tmp48_;
			_tmp50_ = gee_iterable_iterator ((GeeIterable*) _tmp49_);
			_tmp51_ = _tmp50_;
			_g_object_unref0 (_tmp49_);
			_f2_it = _tmp51_;
			while (TRUE) {
				GeeIterator* _tmp52_;
				GdaDataDbFieldInfo* f2 = NULL;
				GeeIterator* _tmp53_;
				gpointer _tmp54_;
				FILE* _tmp55_;
				GdaDataDbFieldInfo* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				_tmp52_ = _f2_it;
				if (!gee_iterator_next (_tmp52_)) {
					break;
				}
				_tmp53_ = _f2_it;
				_tmp54_ = gee_iterator_get (_tmp53_);
				f2 = (GdaDataDbFieldInfo*) _tmp54_;
				_tmp55_ = stdout;
				_tmp56_ = f2;
				_tmp57_ = gda_data_db_field_info_to_string (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = g_strconcat (_tmp58_, "\n", NULL);
				_tmp60_ = _tmp59_;
				fprintf (_tmp55_, "%s", _tmp60_);
				_g_free0 (_tmp60_);
				_g_free0 (_tmp58_);
				_g_object_unref0 (f2);
			}
			_g_object_unref0 (_f2_it);
		}
		_g_object_unref0 (rs);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		FILE* _tmp61_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp61_ = stdout;
		fprintf (_tmp61_, "%s", "Can't access to database " "table: $(a.name) : ERROR: $(e.message)\n");
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp62_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (a);
		_g_object_unref0 (t);
		return _tmp62_;
	}
	_tmp63_ = t;
	_tmp64_ = a;
	if (!gda_data_db_table_equivalent ((GdaDataDbTable*) _tmp63_, (GdaDataDbTable*) _tmp64_)) {
		FILE* _tmp65_;
		GdaDataTable* _tmp66_;
		const gchar* _tmp67_;
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		FILE* _tmp87_;
		GdaDataTable* _tmp88_;
		const gchar* _tmp89_;
		const gchar* _tmp90_;
		const gchar* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		FILE* _tmp109_;
		_tmp65_ = stdout;
		_tmp66_ = t;
		_tmp67_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = string_to_string (_tmp68_);
		_tmp70_ = g_strconcat ("Fields in PRE-DEFINED table: ", _tmp69_, "\n", NULL);
		_tmp71_ = _tmp70_;
		fprintf (_tmp65_, "%s", _tmp71_);
		_g_free0 (_tmp71_);
		{
			GeeIterator* _f_it = NULL;
			GdaDataTable* _tmp72_;
			GeeCollection* _tmp73_;
			GeeCollection* _tmp74_;
			GeeCollection* _tmp75_;
			GeeIterator* _tmp76_;
			GeeIterator* _tmp77_;
			_tmp72_ = t;
			_tmp73_ = gda_data_db_table_get_fields ((GdaDataDbTable*) _tmp72_);
			_tmp74_ = _tmp73_;
			_tmp75_ = _tmp74_;
			_tmp76_ = gee_iterable_iterator ((GeeIterable*) _tmp75_);
			_tmp77_ = _tmp76_;
			_g_object_unref0 (_tmp75_);
			_f_it = _tmp77_;
			while (TRUE) {
				GeeIterator* _tmp78_;
				GdaDataDbFieldInfo* f = NULL;
				GeeIterator* _tmp79_;
				gpointer _tmp80_;
				FILE* _tmp81_;
				GdaDataDbFieldInfo* _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				_tmp78_ = _f_it;
				if (!gee_iterator_next (_tmp78_)) {
					break;
				}
				_tmp79_ = _f_it;
				_tmp80_ = gee_iterator_get (_tmp79_);
				f = (GdaDataDbFieldInfo*) _tmp80_;
				_tmp81_ = stdout;
				_tmp82_ = f;
				_tmp83_ = gda_data_db_field_info_to_string (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = g_strconcat (_tmp84_, "\n", NULL);
				_tmp86_ = _tmp85_;
				fprintf (_tmp81_, "%s", _tmp86_);
				_g_free0 (_tmp86_);
				_g_free0 (_tmp84_);
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_it);
		}
		_tmp87_ = stdout;
		_tmp88_ = a;
		_tmp89_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp88_);
		_tmp90_ = _tmp89_;
		_tmp91_ = string_to_string (_tmp90_);
		_tmp92_ = g_strconcat ("\nFields in DATABASE table: ", _tmp91_, "\n", NULL);
		_tmp93_ = _tmp92_;
		fprintf (_tmp87_, "%s", _tmp93_);
		_g_free0 (_tmp93_);
		{
			GeeIterator* _f2_it = NULL;
			GdaDataTable* _tmp94_;
			GeeCollection* _tmp95_;
			GeeCollection* _tmp96_;
			GeeCollection* _tmp97_;
			GeeIterator* _tmp98_;
			GeeIterator* _tmp99_;
			_tmp94_ = a;
			_tmp95_ = gda_data_db_table_get_fields ((GdaDataDbTable*) _tmp94_);
			_tmp96_ = _tmp95_;
			_tmp97_ = _tmp96_;
			_tmp98_ = gee_iterable_iterator ((GeeIterable*) _tmp97_);
			_tmp99_ = _tmp98_;
			_g_object_unref0 (_tmp97_);
			_f2_it = _tmp99_;
			while (TRUE) {
				GeeIterator* _tmp100_;
				GdaDataDbFieldInfo* f2 = NULL;
				GeeIterator* _tmp101_;
				gpointer _tmp102_;
				FILE* _tmp103_;
				GdaDataDbFieldInfo* _tmp104_;
				gchar* _tmp105_;
				gchar* _tmp106_;
				gchar* _tmp107_;
				gchar* _tmp108_;
				_tmp100_ = _f2_it;
				if (!gee_iterator_next (_tmp100_)) {
					break;
				}
				_tmp101_ = _f2_it;
				_tmp102_ = gee_iterator_get (_tmp101_);
				f2 = (GdaDataDbFieldInfo*) _tmp102_;
				_tmp103_ = stdout;
				_tmp104_ = f2;
				_tmp105_ = gda_data_db_field_info_to_string (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = g_strconcat (_tmp106_, "\n", NULL);
				_tmp108_ = _tmp107_;
				fprintf (_tmp103_, "%s", _tmp108_);
				_g_free0 (_tmp108_);
				_g_free0 (_tmp106_);
				_g_object_unref0 (f2);
			}
			_g_object_unref0 (_f2_it);
		}
		_tmp109_ = stdout;
		fprintf (_tmp109_, ">>>>>>>> FAIL <<<<<<<<<<<\n");
		result = 1;
		_g_object_unref0 (a);
		_g_object_unref0 (t);
		return result;
	}
	_tmp110_ = stdout;
	fprintf (_tmp110_, ">>>>>>>> TEST PASS <<<<<<<<<<<\n");
	result = 0;
	_g_object_unref0 (a);
	_g_object_unref0 (t);
	return result;
}


gint
check_tests_compatible (CheckTests* self,
                        GError** error)
{
	gint result = 0;
	FILE* _tmp0_;
	GdaDataTable* t = NULL;
	GdaDataTable* _tmp1_;
	GdaDataTable* _tmp2_;
	GdaDataTable* _tmp3_;
	GdaDataTable* a = NULL;
	GdaDataTable* _tmp5_;
	GdaDataTable* _tmp6_;
	GdaDataTable* _tmp7_;
	GdaConnection* _tmp8_;
	GdaDataTable* _tmp9_;
	GdaDataTable* _tmp10_;
	GdaDataTable* _tmp57_;
	GdaDataTable* _tmp58_;
	FILE* _tmp104_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n\n\n>>>>>>>>>>>>>>> NEW TEST: Gda.DbTable - compatible...\n");
	_tmp1_ = gda_data_table_new ();
	t = _tmp1_;
	_tmp2_ = t;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp2_, "created_table");
	_tmp3_ = t;
	check_tests_create_table_definition (self, (GdaDataDbTable*) _tmp3_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp4_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return _tmp4_;
	}
	_tmp5_ = gda_data_table_new ();
	a = _tmp5_;
	_tmp6_ = a;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp6_, "created_table");
	_tmp7_ = a;
	_tmp8_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp7_, _tmp8_);
	_tmp9_ = a;
	gda_data_db_object_set_update_meta ((GdaDataDbObject*) _tmp9_, TRUE);
	_tmp10_ = a;
	gda_data_db_object_update ((GdaDataDbObject*) _tmp10_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp11_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (a);
		_g_object_unref0 (t);
		return _tmp11_;
	}
	{
		GeeCollection* rs = NULL;
		GdaDataTable* _tmp12_;
		GeeCollection* _tmp13_;
		GeeCollection* _tmp14_;
		FILE* _tmp15_;
		GdaDataTable* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		FILE* _tmp33_;
		GdaDataTable* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp12_ = a;
		_tmp13_ = gda_data_db_table_get_records ((GdaDataDbTable*) _tmp12_);
		_tmp14_ = _tmp13_;
		rs = _tmp14_;
		_tmp15_ = stdout;
		_tmp16_ = a;
		_tmp17_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = string_to_string (_tmp18_);
		_tmp20_ = g_strconcat ("Records in DATABASE table: ", _tmp19_, "\n", NULL);
		_tmp21_ = _tmp20_;
		fprintf (_tmp15_, "%s", _tmp21_);
		_g_free0 (_tmp21_);
		{
			GeeIterator* _r_it = NULL;
			GeeCollection* _tmp22_;
			GeeIterator* _tmp23_;
			_tmp22_ = rs;
			_tmp23_ = gee_iterable_iterator ((GeeIterable*) _tmp22_);
			_r_it = _tmp23_;
			while (TRUE) {
				GeeIterator* _tmp24_;
				GdaDataDbRecord* r = NULL;
				GeeIterator* _tmp25_;
				gpointer _tmp26_;
				FILE* _tmp27_;
				GdaDataDbRecord* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				_tmp24_ = _r_it;
				if (!gee_iterator_next (_tmp24_)) {
					break;
				}
				_tmp25_ = _r_it;
				_tmp26_ = gee_iterator_get (_tmp25_);
				r = (GdaDataDbRecord*) _tmp26_;
				_tmp27_ = stdout;
				_tmp28_ = r;
				_tmp29_ = gda_data_db_record_to_string (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strconcat (_tmp30_, "\n", NULL);
				_tmp32_ = _tmp31_;
				fprintf (_tmp27_, "%s", _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				_g_object_unref0 (r);
			}
			_g_object_unref0 (_r_it);
		}
		_tmp33_ = stdout;
		_tmp34_ = a;
		_tmp35_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = string_to_string (_tmp36_);
		_tmp38_ = g_strconcat ("Fields in DATABASE table: ", _tmp37_, "\n", NULL);
		_tmp39_ = _tmp38_;
		fprintf (_tmp33_, "%s", _tmp39_);
		_g_free0 (_tmp39_);
		{
			GeeIterator* _f2_it = NULL;
			GdaDataTable* _tmp40_;
			GeeCollection* _tmp41_;
			GeeCollection* _tmp42_;
			GeeCollection* _tmp43_;
			GeeIterator* _tmp44_;
			GeeIterator* _tmp45_;
			_tmp40_ = a;
			_tmp41_ = gda_data_db_table_get_fields ((GdaDataDbTable*) _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = _tmp42_;
			_tmp44_ = gee_iterable_iterator ((GeeIterable*) _tmp43_);
			_tmp45_ = _tmp44_;
			_g_object_unref0 (_tmp43_);
			_f2_it = _tmp45_;
			while (TRUE) {
				GeeIterator* _tmp46_;
				GdaDataDbFieldInfo* f2 = NULL;
				GeeIterator* _tmp47_;
				gpointer _tmp48_;
				FILE* _tmp49_;
				GdaDataDbFieldInfo* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp46_ = _f2_it;
				if (!gee_iterator_next (_tmp46_)) {
					break;
				}
				_tmp47_ = _f2_it;
				_tmp48_ = gee_iterator_get (_tmp47_);
				f2 = (GdaDataDbFieldInfo*) _tmp48_;
				_tmp49_ = stdout;
				_tmp50_ = f2;
				_tmp51_ = gda_data_db_field_info_to_string (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = g_strconcat (_tmp52_, "\n", NULL);
				_tmp54_ = _tmp53_;
				fprintf (_tmp49_, "%s", _tmp54_);
				_g_free0 (_tmp54_);
				_g_free0 (_tmp52_);
				_g_object_unref0 (f2);
			}
			_g_object_unref0 (_f2_it);
		}
		_g_object_unref0 (rs);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		FILE* _tmp55_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp55_ = stdout;
		fprintf (_tmp55_, "%s", "Can't access to database " "table: $(a.name) : ERROR: $(e.message)\n");
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp56_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (a);
		_g_object_unref0 (t);
		return _tmp56_;
	}
	_tmp57_ = t;
	_tmp58_ = a;
	if (!gda_data_db_table_compatible ((GdaDataDbTable*) _tmp57_, (GdaDataDbTable*) _tmp58_)) {
		FILE* _tmp59_;
		GdaDataTable* _tmp60_;
		const gchar* _tmp61_;
		const gchar* _tmp62_;
		const gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		FILE* _tmp81_;
		GdaDataTable* _tmp82_;
		const gchar* _tmp83_;
		const gchar* _tmp84_;
		const gchar* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		FILE* _tmp103_;
		_tmp59_ = stdout;
		_tmp60_ = t;
		_tmp61_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = string_to_string (_tmp62_);
		_tmp64_ = g_strconcat ("Fields in PRE-DEFINED table: ", _tmp63_, "\n", NULL);
		_tmp65_ = _tmp64_;
		fprintf (_tmp59_, "%s", _tmp65_);
		_g_free0 (_tmp65_);
		{
			GeeIterator* _f_it = NULL;
			GdaDataTable* _tmp66_;
			GeeCollection* _tmp67_;
			GeeCollection* _tmp68_;
			GeeCollection* _tmp69_;
			GeeIterator* _tmp70_;
			GeeIterator* _tmp71_;
			_tmp66_ = t;
			_tmp67_ = gda_data_db_table_get_fields ((GdaDataDbTable*) _tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = _tmp68_;
			_tmp70_ = gee_iterable_iterator ((GeeIterable*) _tmp69_);
			_tmp71_ = _tmp70_;
			_g_object_unref0 (_tmp69_);
			_f_it = _tmp71_;
			while (TRUE) {
				GeeIterator* _tmp72_;
				GdaDataDbFieldInfo* f = NULL;
				GeeIterator* _tmp73_;
				gpointer _tmp74_;
				FILE* _tmp75_;
				GdaDataDbFieldInfo* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				_tmp72_ = _f_it;
				if (!gee_iterator_next (_tmp72_)) {
					break;
				}
				_tmp73_ = _f_it;
				_tmp74_ = gee_iterator_get (_tmp73_);
				f = (GdaDataDbFieldInfo*) _tmp74_;
				_tmp75_ = stdout;
				_tmp76_ = f;
				_tmp77_ = gda_data_db_field_info_to_string (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = g_strconcat (_tmp78_, "\n", NULL);
				_tmp80_ = _tmp79_;
				fprintf (_tmp75_, "%s", _tmp80_);
				_g_free0 (_tmp80_);
				_g_free0 (_tmp78_);
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_it);
		}
		_tmp81_ = stdout;
		_tmp82_ = a;
		_tmp83_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp82_);
		_tmp84_ = _tmp83_;
		_tmp85_ = string_to_string (_tmp84_);
		_tmp86_ = g_strconcat ("\nFields in DATABASE table: ", _tmp85_, "\n", NULL);
		_tmp87_ = _tmp86_;
		fprintf (_tmp81_, "%s", _tmp87_);
		_g_free0 (_tmp87_);
		{
			GeeIterator* _f2_it = NULL;
			GdaDataTable* _tmp88_;
			GeeCollection* _tmp89_;
			GeeCollection* _tmp90_;
			GeeCollection* _tmp91_;
			GeeIterator* _tmp92_;
			GeeIterator* _tmp93_;
			_tmp88_ = a;
			_tmp89_ = gda_data_db_table_get_fields ((GdaDataDbTable*) _tmp88_);
			_tmp90_ = _tmp89_;
			_tmp91_ = _tmp90_;
			_tmp92_ = gee_iterable_iterator ((GeeIterable*) _tmp91_);
			_tmp93_ = _tmp92_;
			_g_object_unref0 (_tmp91_);
			_f2_it = _tmp93_;
			while (TRUE) {
				GeeIterator* _tmp94_;
				GdaDataDbFieldInfo* f2 = NULL;
				GeeIterator* _tmp95_;
				gpointer _tmp96_;
				FILE* _tmp97_;
				GdaDataDbFieldInfo* _tmp98_;
				gchar* _tmp99_;
				gchar* _tmp100_;
				gchar* _tmp101_;
				gchar* _tmp102_;
				_tmp94_ = _f2_it;
				if (!gee_iterator_next (_tmp94_)) {
					break;
				}
				_tmp95_ = _f2_it;
				_tmp96_ = gee_iterator_get (_tmp95_);
				f2 = (GdaDataDbFieldInfo*) _tmp96_;
				_tmp97_ = stdout;
				_tmp98_ = f2;
				_tmp99_ = gda_data_db_field_info_to_string (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = g_strconcat (_tmp100_, "\n", NULL);
				_tmp102_ = _tmp101_;
				fprintf (_tmp97_, "%s", _tmp102_);
				_g_free0 (_tmp102_);
				_g_free0 (_tmp100_);
				_g_object_unref0 (f2);
			}
			_g_object_unref0 (_f2_it);
		}
		_tmp103_ = stdout;
		fprintf (_tmp103_, ">>>>>>>> FAIL <<<<<<<<<<<\n");
		result = 1;
		_g_object_unref0 (a);
		_g_object_unref0 (t);
		return result;
	}
	_tmp104_ = stdout;
	fprintf (_tmp104_, ">>>>>>>> TEST PASS <<<<<<<<<<<\n");
	result = 0;
	_g_object_unref0 (a);
	_g_object_unref0 (t);
	return result;
}


gint
check_tests_append (CheckTests* self,
                    GError** error)
{
	gint result = 0;
	FILE* _tmp0_;
	gint fails = 0;
	GdaDataTable* t = NULL;
	GdaDataTable* _tmp1_;
	GdaDataTable* _tmp2_;
	GdaDataTable* _tmp3_;
	GdaConnection* _tmp4_;
	GdaDataTable* _tmp25_;
	FILE* _tmp27_;
	GdaDataTable* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gboolean f = FALSE;
	gint _tmp137_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n\n\n>>>>>>>>>>>>>>> NEW TEST: Gda.DbTable - Append...\n");
	fails = 0;
	_tmp1_ = gda_data_table_new ();
	t = _tmp1_;
	_tmp2_ = t;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp2_, "created_table");
	_tmp3_ = t;
	_tmp4_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp3_, _tmp4_);
	{
		FILE* _tmp5_;
		GdaDataTable* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gboolean _tmp12_;
		_tmp5_ = stdout;
		fprintf (_tmp5_, "If the table doesn't exists this will warn...\n");
		_tmp6_ = t;
		_tmp7_ = gda_data_db_table_get_records ((GdaDataDbTable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_collection_get_size (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_ > 0;
		_g_object_unref0 (_tmp9_);
		if (_tmp12_) {
			FILE* _tmp13_;
			GdaDataTable* _tmp14_;
			_tmp13_ = stdout;
			fprintf (_tmp13_, "Table exists and is not empty. Deleting it!!\n");
			_tmp14_ = t;
			gda_data_db_object_drop ((GdaDataDbObject*) _tmp14_, FALSE, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch11_g_error;
			}
		} else {
			FILE* _tmp15_;
			_tmp15_ = stdout;
			fprintf (_tmp15_, "Table doesn't exist continue...\n");
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		FILE* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gint _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = stdout;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		_tmp19_ = g_strconcat ("Error on dropping table with error message: ", _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, "\n", NULL);
		_tmp22_ = _tmp21_;
		fprintf (_tmp16_, "%s", _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_tmp23_ = fails;
		fails = _tmp23_ + 1;
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp24_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return _tmp24_;
	}
	_tmp25_ = t;
	check_tests_create_table_definition (self, (GdaDataDbTable*) _tmp25_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp26_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return _tmp26_;
	}
	_tmp27_ = stdout;
	_tmp28_ = t;
	_tmp29_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = string_to_string (_tmp30_);
	_tmp32_ = g_strconcat ("Table NEW '", _tmp31_, "' definition:\n", NULL);
	_tmp33_ = _tmp32_;
	fprintf (_tmp27_, "%s", _tmp33_);
	_g_free0 (_tmp33_);
	{
		GeeIterator* _f_it = NULL;
		GdaDataTable* _tmp34_;
		GeeCollection* _tmp35_;
		GeeCollection* _tmp36_;
		GeeCollection* _tmp37_;
		GeeIterator* _tmp38_;
		GeeIterator* _tmp39_;
		_tmp34_ = t;
		_tmp35_ = gda_data_db_table_get_fields ((GdaDataDbTable*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = _tmp36_;
		_tmp38_ = gee_iterable_iterator ((GeeIterable*) _tmp37_);
		_tmp39_ = _tmp38_;
		_g_object_unref0 (_tmp37_);
		_f_it = _tmp39_;
		while (TRUE) {
			GeeIterator* _tmp40_;
			GdaDataDbFieldInfo* f = NULL;
			GeeIterator* _tmp41_;
			gpointer _tmp42_;
			FILE* _tmp43_;
			GdaDataDbFieldInfo* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			_tmp40_ = _f_it;
			if (!gee_iterator_next (_tmp40_)) {
				break;
			}
			_tmp41_ = _f_it;
			_tmp42_ = gee_iterator_get (_tmp41_);
			f = (GdaDataDbFieldInfo*) _tmp42_;
			_tmp43_ = stdout;
			_tmp44_ = f;
			_tmp45_ = gda_data_db_field_info_to_string (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strconcat (_tmp46_, "\n", NULL);
			_tmp48_ = _tmp47_;
			fprintf (_tmp43_, "%s", _tmp48_);
			_g_free0 (_tmp48_);
			_g_free0 (_tmp46_);
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	f = FALSE;
	{
		GdaDataTable* _tmp49_;
		_tmp49_ = t;
		gda_data_db_object_append ((GdaDataDbObject*) _tmp49_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		FILE* _tmp50_;
		GError* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp50_ = stdout;
		_tmp51_ = e;
		_tmp52_ = _tmp51_->message;
		_tmp53_ = string_to_string (_tmp52_);
		_tmp54_ = g_strconcat ("ERROR on APPEND: ", _tmp53_, "\n", NULL);
		_tmp55_ = _tmp54_;
		fprintf (_tmp50_, "%s", _tmp55_);
		_g_free0 (_tmp55_);
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp56_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return _tmp56_;
	}
	{
		GdaDataModel* m = NULL;
		GdaConnection* _tmp57_;
		GdaDataModel* _tmp58_;
		FILE* _tmp59_;
		GdaDataModel* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		const gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		GdaDataModel* _tmp68_;
		GdaDataModel* _tmp69_;
		GdaDataModel* _tmp70_;
		gboolean _tmp71_;
		_tmp57_ = self->priv->_connection;
		_tmp58_ = gda_connection_execute_select_command (_tmp57_, "SELECT * FROM created_table", &_inner_error_);
		m = _tmp58_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch13_g_error;
		}
		_tmp59_ = stdout;
		_tmp60_ = m;
		_tmp61_ = gda_data_model_dump_as_string (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = string_to_string (_tmp62_);
		_tmp64_ = g_strconcat ("\nContents\n", _tmp63_, "\n", NULL);
		_tmp65_ = _tmp64_;
		_tmp66_ = g_strconcat ("Table was appended succeeded", _tmp65_, NULL);
		_tmp67_ = _tmp66_;
		fprintf (_tmp59_, "%s", _tmp67_);
		_g_free0 (_tmp67_);
		_g_free0 (_tmp65_);
		_g_free0 (_tmp62_);
		_tmp68_ = m;
		if (gda_data_model_get_column_index (_tmp68_, "id") != 0) {
			f = TRUE;
		}
		_tmp69_ = m;
		if (gda_data_model_get_column_index (_tmp69_, "name") != 1) {
			f = TRUE;
		}
		_tmp70_ = m;
		if (gda_data_model_get_column_index (_tmp70_, "company") != 2) {
			f = TRUE;
		}
		_tmp71_ = f;
		if (_tmp71_) {
			gint _tmp72_;
			FILE* _tmp73_;
			_tmp72_ = fails;
			fails = _tmp72_ + 1;
			_tmp73_ = stdout;
			fprintf (_tmp73_, "Check Ordinal position: FAILED\n");
		}
		_g_object_unref0 (m);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		FILE* _tmp74_;
		GdaDataTable* _tmp75_;
		const gchar* _tmp76_;
		const gchar* _tmp77_;
		const gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		GError* _tmp83_;
		const gchar* _tmp84_;
		const gchar* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gint _tmp90_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp74_ = stdout;
		_tmp75_ = t;
		_tmp76_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = string_to_string (_tmp77_);
		_tmp79_ = g_strconcat ("for new table ", _tmp78_, ". ", NULL);
		_tmp80_ = _tmp79_;
		_tmp81_ = g_strconcat ("Error on calling SELECT query ", _tmp80_, NULL);
		_tmp82_ = _tmp81_;
		_tmp83_ = e;
		_tmp84_ = _tmp83_->message;
		_tmp85_ = string_to_string (_tmp84_);
		_tmp86_ = g_strconcat ("ERROR: ", _tmp85_, "\n", NULL);
		_tmp87_ = _tmp86_;
		_tmp88_ = g_strconcat (_tmp82_, _tmp87_, NULL);
		_tmp89_ = _tmp88_;
		fprintf (_tmp74_, "%s", _tmp89_);
		_g_free0 (_tmp89_);
		_g_free0 (_tmp87_);
		_g_free0 (_tmp82_);
		_g_free0 (_tmp80_);
		_tmp90_ = fails;
		fails = _tmp90_ + 1;
		_g_error_free0 (e);
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp91_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return _tmp91_;
	}
	{
		GdaDataRecord* r = NULL;
		GdaDataRecord* _tmp92_;
		GdaDataRecord* _tmp93_;
		GdaConnection* _tmp94_;
		GdaDataTable* nt = NULL;
		GdaDataTable* _tmp95_;
		GdaDataTable* _tmp96_;
		GdaDataRecord* _tmp97_;
		GdaDataTable* _tmp98_;
		GdaDataRecord* _tmp99_;
		GValue* _tmp100_ = NULL;
		GdaDataRecord* _tmp101_;
		_tmp92_ = gda_data_record_new ();
		r = _tmp92_;
		_tmp93_ = r;
		_tmp94_ = self->priv->_connection;
		gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp93_, _tmp94_);
		_tmp95_ = gda_data_table_new ();
		nt = _tmp95_;
		_tmp96_ = nt;
		gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp96_, "created_table");
		_tmp97_ = r;
		_tmp98_ = nt;
		gda_data_db_record_set_table ((GdaDataDbRecord*) _tmp97_, (GdaDataDbTable*) _tmp98_);
		_tmp99_ = r;
		_tmp100_ = g_new0 (GValue, 1);
		g_value_init (_tmp100_, G_TYPE_STRING);
		g_value_set_string (_tmp100_, "Nancy");
		gda_data_db_record_set_field_value ((GdaDataDbRecord*) _tmp99_, "name", _tmp100_, &_inner_error_);
		__vala_GValue_free0 (_tmp100_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (nt);
			_g_object_unref0 (r);
			goto __catch14_g_error;
		}
		_tmp101_ = r;
		gda_data_db_object_append ((GdaDataDbObject*) _tmp101_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (nt);
			_g_object_unref0 (r);
			goto __catch14_g_error;
		}
		_g_object_unref0 (nt);
		_g_object_unref0 (r);
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		FILE* _tmp102_;
		GError* _tmp103_;
		const gchar* _tmp104_;
		const gchar* _tmp105_;
		gchar* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp102_ = stdout;
		_tmp103_ = e;
		_tmp104_ = _tmp103_->message;
		_tmp105_ = string_to_string (_tmp104_);
		_tmp106_ = g_strconcat ("Values: ", _tmp105_, "\n", NULL);
		_tmp107_ = _tmp106_;
		_tmp108_ = g_strconcat ("ERROR on appending ", _tmp107_, NULL);
		_tmp109_ = _tmp108_;
		fprintf (_tmp102_, "%s", _tmp109_);
		_g_free0 (_tmp109_);
		_g_free0 (_tmp107_);
		_g_error_free0 (e);
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp110_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return _tmp110_;
	}
	{
		GdaDataModel* m2 = NULL;
		GdaConnection* _tmp111_;
		GdaDataModel* _tmp112_;
		gboolean f2 = FALSE;
		GdaDataModel* _tmp113_;
		GValue* _tmp114_ = NULL;
		GdaDataModel* _tmp115_;
		gint id = 0;
		gint _tmp116_;
		GValue* _tmp117_ = NULL;
		GdaDataModel* _tmp118_;
		gchar* name = NULL;
		gchar* _tmp119_;
		GCompareFunc _tmp120_;
		const gchar* _tmp121_;
		GValue* _tmp122_ = NULL;
		GdaDataModel* _tmp123_;
		gint company = 0;
		gint _tmp124_;
		gboolean _tmp125_;
		_tmp111_ = self->priv->_connection;
		_tmp112_ = gda_connection_execute_select_command (_tmp111_, "SELECT * FROM created_table", &_inner_error_);
		m2 = _tmp112_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch15_g_error;
		}
		f2 = FALSE;
		_tmp113_ = m2;
		if (gda_data_model_get_n_rows (_tmp113_) != 1) {
			f2 = TRUE;
		}
		_tmp115_ = m2;
		_tmp114_ = gda_data_model_get_value_at (_tmp115_, 0, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (m2);
			goto __catch15_g_error;
		}
		id = g_value_get_int (_tmp114_);
		_tmp116_ = id;
		if (_tmp116_ != 1) {
			f2 = TRUE;
		}
		_tmp118_ = m2;
		_tmp117_ = gda_data_model_get_value_at (_tmp118_, 1, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (m2);
			goto __catch15_g_error;
		}
		_tmp119_ = g_strdup (g_value_get_string (_tmp117_));
		name = _tmp119_;
		_tmp120_ = g_strcmp0;
		_tmp121_ = name;
		if (_tmp120_ (_tmp121_, "Nancy") != 0) {
			f2 = TRUE;
		}
		_tmp123_ = m2;
		_tmp122_ = gda_data_model_get_value_at (_tmp123_, 2, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (name);
			_g_object_unref0 (m2);
			goto __catch15_g_error;
		}
		company = g_value_get_int (_tmp122_);
		_tmp124_ = company;
		if (_tmp124_ != 1) {
			f2 = TRUE;
		}
		_tmp125_ = f;
		if (_tmp125_) {
			gint _tmp126_;
			FILE* _tmp127_;
			_tmp126_ = fails;
			fails = _tmp126_ + 1;
			_tmp127_ = stdout;
			fprintf (_tmp127_, "Check Table Values: FAILED\n");
		}
		_g_free0 (name);
		_g_object_unref0 (m2);
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		FILE* _tmp128_;
		GError* _tmp129_;
		const gchar* _tmp130_;
		const gchar* _tmp131_;
		gchar* _tmp132_;
		gchar* _tmp133_;
		gchar* _tmp134_;
		gchar* _tmp135_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp128_ = stdout;
		_tmp129_ = e;
		_tmp130_ = _tmp129_->message;
		_tmp131_ = string_to_string (_tmp130_);
		_tmp132_ = g_strconcat ("form new table: ", _tmp131_, "\n", NULL);
		_tmp133_ = _tmp132_;
		_tmp134_ = g_strconcat ("ERROR on getting data ", _tmp133_, NULL);
		_tmp135_ = _tmp134_;
		fprintf (_tmp128_, "%s", _tmp135_);
		_g_free0 (_tmp135_);
		_g_free0 (_tmp133_);
		_g_error_free0 (e);
	}
	__finally15:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp136_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return _tmp136_;
	}
	_tmp137_ = fails;
	if (_tmp137_ > 0) {
		FILE* _tmp138_;
		_tmp138_ = stdout;
		fprintf (_tmp138_, ">>>>>>>> FAIL <<<<<<<<<<<\n");
	} else {
		FILE* _tmp139_;
		_tmp139_ = stdout;
		fprintf (_tmp139_, ">>>>>>>> TEST PASS <<<<<<<<<<<\n");
	}
	result = fails;
	_g_object_unref0 (t);
	return result;
}


gint
check_tests_drop (CheckTests* self,
                  GError** error)
{
	gint result = 0;
	FILE* _tmp0_;
	GdaDataTable* t = NULL;
	GdaDataTable* _tmp1_;
	GdaDataTable* _tmp2_;
	GdaDataTable* _tmp3_;
	GdaConnection* _tmp4_;
	FILE* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n\n\n>>>>>>>>>>>>>>> NEW TEST: Gda.DbTable - Drop...\n");
	_tmp1_ = gda_data_table_new ();
	t = _tmp1_;
	_tmp2_ = t;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp2_, "created_table");
	_tmp3_ = t;
	_tmp4_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp3_, _tmp4_);
	{
		GdaDataTable* _tmp5_;
		_tmp5_ = t;
		gda_data_db_object_drop ((GdaDataDbObject*) _tmp5_, FALSE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		FILE* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stdout;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = g_strconcat ("Dropping table Fails: ", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, "\n", NULL);
		_tmp12_ = _tmp11_;
		fprintf (_tmp6_, "%s", _tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_tmp13_ = stdout;
		fprintf (_tmp13_, ">>>>>>>> FAIL <<<<<<<<<<<\n");
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (t);
		return result;
	}
	__finally16:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp14_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return _tmp14_;
	}
	_tmp15_ = stdout;
	fprintf (_tmp15_, ">>>>>>>> TEST PASS <<<<<<<<<<<\n");
	result = 0;
	_g_object_unref0 (t);
	return result;
}


gint
check_tests_save (CheckTests* self,
                  GError** error)
{
	gint result = 0;
	FILE* _tmp0_;
	gint fails = 0;
	GdaDataTable* t = NULL;
	GdaDataTable* _tmp1_;
	GdaConnection* _tmp2_;
	gint _tmp25_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n\n\n>>>>>>>>>>>>>>> NEW TEST: Gda.DbTable - Rename ...\n");
	fails = 0;
	_tmp1_ = gda_data_table_new ();
	t = _tmp1_;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) t, "customer");
	_tmp2_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) t, _tmp2_);
	{
		FILE* _tmp3_;
		gint _tmp4_;
		gda_data_db_object_save ((GdaDataDbObject*) t, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch17_g_error;
		}
		_tmp3_ = stdout;
		fprintf (_tmp3_, "Table save() method should throws Error: FAIL\n");
		_tmp4_ = fails;
		fails = _tmp4_ + 1;
	}
	goto __finally17;
	__catch17_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally17:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp5_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return _tmp5_;
	}
	{
		gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) t, "customer2");
		gda_data_db_object_save ((GdaDataDbObject*) t, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gint _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stdout;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = g_strconcat ("Table rename fails. Message: ", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, "\n", NULL);
		_tmp12_ = _tmp11_;
		fprintf (_tmp6_, "%s", _tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_tmp13_ = fails;
		fails = _tmp13_ + 1;
		_g_error_free0 (e);
	}
	__finally18:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp14_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return _tmp14_;
	}
	{
		GdaDataModel* m = NULL;
		GdaConnection* _tmp15_;
		GdaDataModel* _tmp16_;
		FILE* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp15_ = self->priv->_connection;
		_tmp16_ = gda_connection_execute_select_command (_tmp15_, "SELECT * FROM customer2", &_inner_error_);
		m = _tmp16_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch19_g_error;
		}
		_tmp17_ = stdout;
		_tmp18_ = gda_data_model_dump_as_string (m);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat ("Data from customer2:\n", _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		fprintf (_tmp17_, "%s", _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_object_unref0 (m);
	}
	goto __finally19;
	__catch19_g_error:
	{
		gint _tmp22_;
		FILE* _tmp23_;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp22_ = fails;
		fails = _tmp22_ + 1;
		_tmp23_ = stdout;
		fprintf (_tmp23_, "Table rename: FAIL\n");
	}
	__finally19:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp24_ = -1;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return _tmp24_;
	}
	_tmp25_ = fails;
	if (_tmp25_ > 0) {
		FILE* _tmp26_;
		_tmp26_ = stdout;
		fprintf (_tmp26_, ">>>>>>>> FAIL <<<<<<<<<<<\n");
	} else {
		FILE* _tmp27_;
		_tmp27_ = stdout;
		fprintf (_tmp27_, ">>>>>>>> TEST PASS <<<<<<<<<<<\n");
	}
	result = fails;
	_g_object_unref0 (t);
	return result;
}


gint
check_tests_main (gchar** args,
                  int args_length1)
{
	gint result = 0;
	FILE* _tmp0_;
	gint failures = 0;
	CheckTests* app = NULL;
	CheckTests* _tmp1_;
	gint _tmp32_ = 0;
	gint _tmp33_;
	GError * _inner_error_ = NULL;
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", "\n\n\n>>>>>>>>>>>>>>>> NEW TEST: " "Checking GdaData.DbTable implementation..." " <<<<<<<<<< \n");
	failures = 0;
	_tmp1_ = check_tests_new ();
	app = _tmp1_;
	{
		CheckTests* _tmp2_;
		gint _tmp3_ = 0;
		CheckTests* _tmp4_;
		gint _tmp5_;
		gint _tmp6_ = 0;
		CheckTests* _tmp7_;
		gint _tmp8_;
		gint _tmp9_ = 0;
		CheckTests* _tmp10_;
		gint _tmp11_;
		gint _tmp12_ = 0;
		CheckTests* _tmp13_;
		gint _tmp14_;
		gint _tmp15_ = 0;
		CheckTests* _tmp16_;
		gint _tmp17_;
		gint _tmp18_ = 0;
		CheckTests* _tmp19_;
		gint _tmp20_;
		gint _tmp21_ = 0;
		CheckTests* _tmp22_;
		gint _tmp23_;
		_tmp2_ = app;
		check_tests_init (_tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp4_ = app;
		_tmp3_ = check_tests_update (_tmp4_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp5_ = failures;
		failures = _tmp5_ + _tmp3_;
		_tmp7_ = app;
		_tmp6_ = check_tests_fields (_tmp7_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp8_ = failures;
		failures = _tmp8_ + _tmp6_;
		_tmp10_ = app;
		_tmp9_ = check_tests_records (_tmp10_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp11_ = failures;
		failures = _tmp11_ + _tmp9_;
		_tmp13_ = app;
		_tmp12_ = check_tests_append (_tmp13_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp14_ = failures;
		failures = _tmp14_ + _tmp12_;
		_tmp16_ = app;
		_tmp15_ = check_tests_equivalent (_tmp16_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp17_ = failures;
		failures = _tmp17_ + _tmp15_;
		_tmp19_ = app;
		_tmp18_ = check_tests_compatible (_tmp19_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp20_ = failures;
		failures = _tmp20_ + _tmp18_;
		_tmp22_ = app;
		_tmp21_ = check_tests_drop (_tmp22_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp23_ = failures;
		failures = _tmp23_ + _tmp21_;
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		FILE* _tmp24_;
		GError* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = stdout;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		_tmp27_ = g_strconcat ("ERROR: ", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strconcat (_tmp28_, "\n", NULL);
		_tmp30_ = _tmp29_;
		fprintf (_tmp24_, "%s", _tmp30_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (app);
		return result;
	}
	__finally20:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp31_ = -1;
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp31_;
	}
	_tmp33_ = failures;
	if (_tmp33_ != 0) {
		_tmp32_ = 1;
	} else {
		_tmp32_ = 0;
	}
	result = _tmp32_;
	_g_object_unref0 (app);
	return result;
}


int
main (int argc,
      char ** argv)
{
	return check_tests_main (argv, argc);
}


GdaConnection*
check_tests_get_connection (CheckTests* self)
{
	GdaConnection* result;
	GdaConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}


void
check_tests_set_connection (CheckTests* self,
                            GdaConnection* value)
{
	g_return_if_fail (self != NULL);
	if (check_tests_get_connection (self) != value) {
		GdaConnection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_connection);
		self->priv->_connection = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, check_tests_properties[CHECK_TESTS_CONNECTION_PROPERTY]);
	}
}


static void
check_tests_class_init (CheckTestsClass * klass)
{
	check_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheckTestsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_check_tests_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_check_tests_set_property;
	G_OBJECT_CLASS (klass)->finalize = check_tests_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHECK_TESTS_CONNECTION_PROPERTY, check_tests_properties[CHECK_TESTS_CONNECTION_PROPERTY] = g_param_spec_object ("connection", "connection", "connection", gda_connection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
check_tests_instance_init (CheckTests * self)
{
	self->priv = CHECK_TESTS_GET_PRIVATE (self);
}


static void
check_tests_finalize (GObject * obj)
{
	CheckTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHECK_TYPE_TESTS, CheckTests);
	_g_object_unref0 (self->priv->_connection);
	_g_object_unref0 (self->table);
	G_OBJECT_CLASS (check_tests_parent_class)->finalize (obj);
}


GType
check_tests_get_type (void)
{
	static volatile gsize check_tests_type_id__volatile = 0;
	if (g_once_init_enter (&check_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) check_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckTests), 0, (GInstanceInitFunc) check_tests_instance_init, NULL };
		GType check_tests_type_id;
		check_tests_type_id = g_type_register_static (G_TYPE_OBJECT, "CheckTests", &g_define_type_info, 0);
		g_once_init_leave (&check_tests_type_id__volatile, check_tests_type_id);
	}
	return check_tests_type_id__volatile;
}


static void
_vala_check_tests_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	CheckTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CHECK_TYPE_TESTS, CheckTests);
	switch (property_id) {
		case CHECK_TESTS_CONNECTION_PROPERTY:
		g_value_set_object (value, check_tests_get_connection (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_check_tests_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	CheckTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CHECK_TYPE_TESTS, CheckTests);
	switch (property_id) {
		case CHECK_TESTS_CONNECTION_PROPERTY:
		check_tests_set_connection (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



