/* CheckDataModelIterator.c generated by valac 0.40.8.18-c87af, the Vala compiler
 * generated from CheckDataModelIterator.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata Unit Tests
 * Copyright (C) Daniel Espinosa Ortiz 2011 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <libgda/libgda.h>
#include <libgda/data/libgdadata.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define CHECK_TYPE_TESTS (check_tests_get_type ())
#define CHECK_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECK_TYPE_TESTS, CheckTests))
#define CHECK_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECK_TYPE_TESTS, CheckTestsClass))
#define CHECK_IS_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECK_TYPE_TESTS))
#define CHECK_IS_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECK_TYPE_TESTS))
#define CHECK_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECK_TYPE_TESTS, CheckTestsClass))

typedef struct _CheckTests CheckTests;
typedef struct _CheckTestsClass CheckTestsClass;
typedef struct _CheckTestsPrivate CheckTestsPrivate;
enum  {
	CHECK_TESTS_0_PROPERTY,
	CHECK_TESTS_NUM_PROPERTIES
};
static GParamSpec* check_tests_properties[CHECK_TESTS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gee_lazy_unref0(var) ((var == NULL) ? NULL : (var = (gee_lazy_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _CheckTests {
	GObject parent_instance;
	CheckTestsPrivate * priv;
};

struct _CheckTestsClass {
	GObjectClass parent_class;
};

struct _CheckTestsPrivate {
	GdaConnection* connection;
	GdaDataDbRecordCollection* itermodel;
};

struct _Block1Data {
	int _ref_count_;
	CheckTests* self;
	gchar* ts;
};


static gpointer check_tests_parent_class = NULL;

GType check_tests_get_type (void) G_GNUC_CONST;
#define CHECK_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHECK_TYPE_TESTS, CheckTestsPrivate))
static CheckTests* check_tests_new (void);
static CheckTests* check_tests_construct (GType object_type);
gint check_tests_iterating (CheckTests* self,
                            GError** error);
gint check_tests_choping (CheckTests* self);
gint check_tests_filtering (CheckTests* self);
static gboolean __lambda4_ (CheckTests* self,
                     GdaDataDbRecord* g);
static gboolean ___lambda4__gee_predicate (gconstpointer g,
                                    gpointer self);
gint check_tests_streaming (CheckTests* self);
static GeeTraversableStream __lambda5_ (CheckTests* self,
                                 GeeTraversableStream state,
                                 GeeLazy* g,
                                 GeeLazy* * lazy);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gchar* ______lambda6_ (Block1Data* _data1_);
static gpointer _______lambda6__gee_lazy_func (gpointer self);
static GeeTraversableStream ___lambda5__gee_stream_func (GeeTraversableStream state,
                                                  GeeLazy* g,
                                                  GeeLazy* * lazy,
                                                  gpointer self);
gint check_tests_InitIter (CheckTests* self,
                           GError** error);
gint check_tests_main (gchar** args,
                       int args_length1);
static void check_tests_finalize (GObject * obj);


static CheckTests*
check_tests_construct (GType object_type)
{
	CheckTests * self = NULL;
	GError * _inner_error_ = NULL;
	self = (CheckTests*) g_object_new (object_type, NULL);
	{
		FILE* _tmp0_;
		GdaConnection* _tmp1_ = NULL;
		GdaConnection* _tmp2_;
		GdaConnection* _tmp3_;
		FILE* _tmp4_;
		GdaConnection* _tmp5_;
		GdaConnection* _tmp6_;
		GdaConnection* _tmp7_;
		GdaConnection* _tmp8_;
		GdaConnection* _tmp9_;
		GdaConnection* _tmp10_;
		GdaConnection* _tmp11_;
		GdaConnection* _tmp12_;
		g_unlink ("datamodeliterator.db");
		_tmp0_ = stdout;
		fprintf (_tmp0_, "Creating Database...\n");
		_tmp2_ = gda_connection_open_from_string ("SQLite", "DB_DIR=.;DB_NAME=datamodeliterator", NULL, GDA_CONNECTION_OPTIONS_NONE, &_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->connection);
		self->priv->connection = _tmp3_;
		_tmp4_ = stdout;
		fprintf (_tmp4_, "Creating table 'user'...\n");
		_tmp5_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp5_, "CREATE TABLE user (id int PRIMARY KEY, name string, city string)", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp6_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp6_, "INSERT INTO user (id, name, city) VALUES (1, \"Daniel\", \"Mexico\")", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp7_, "INSERT INTO user (id, name, city) VALUES (2, \"Jhon\", \"USA\")", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp8_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp8_, "INSERT INTO user (id, name, city) VALUES (3, \"James\", \"Germany\")", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp9_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp9_, "INSERT INTO user (id, name, city) VALUES (4, \"Jack\", \"United Kindom" \
"\")", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp10_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp10_, "INSERT INTO user (id, name, city) VALUES (5, \"Elsy\", \"España\")", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp11_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp11_, "INSERT INTO user (id, name, city) VALUES (6, \"Mayo\", \"Mexico\")", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp12_ = self->priv->connection;
		gda_connection_update_meta_store (_tmp12_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = stdout;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		fprintf (_tmp13_, "Couln't create temporary database...\nERROR: %s\n", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static CheckTests*
check_tests_new (void)
{
	return check_tests_construct (CHECK_TYPE_TESTS);
}


gint
check_tests_iterating (CheckTests* self,
                       GError** error)
{
	gint result = 0;
	gint fails = 0;
	FILE* _tmp0_;
	gint i = 0;
	FILE* _tmp1_;
	GeeIterator* iter = NULL;
	GdaDataDbRecordCollection* _tmp2_;
	GeeIterator* _tmp3_;
	GeeIterator* _tmp4_;
	gboolean _tmp27_ = FALSE;
	gint _tmp28_;
	FILE* _tmp39_;
	gboolean _tmp54_ = FALSE;
	gint _tmp55_;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Iterating over all Records in DataModel using foreach...\n");
	i = 0;
	_tmp1_ = stdout;
	fprintf (_tmp1_, "Iterating using a Gee.Iterator...\n");
	i = 0;
	_tmp2_ = self->priv->itermodel;
	_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
	iter = _tmp3_;
	_tmp4_ = iter;
	if (_tmp4_ == NULL) {
		FILE* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp5_ = stdout;
		_tmp6_ = fails;
		fails = _tmp6_ + 1;
		_tmp7_ = fails;
		_tmp8_ = g_strdup_printf ("%i", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("----- FAIL ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
		_tmp13_ = _tmp12_;
		fprintf (_tmp5_, "%s", _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
	while (TRUE) {
		GeeIterator* _tmp14_;
		gchar* t2 = NULL;
		GeeIterator* _tmp15_;
		gpointer _tmp16_;
		GdaDataDbRecord* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp14_ = iter;
		if (!gee_iterator_next (_tmp14_)) {
			break;
		}
		_tmp15_ = iter;
		_tmp16_ = gee_iterator_get (_tmp15_);
		_tmp17_ = (GdaDataDbRecord*) _tmp16_;
		_tmp18_ = gda_data_db_record_to_string (_tmp17_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		t2 = _tmp19_;
		_tmp20_ = t2;
		if (_tmp20_ == NULL) {
			gint _tmp21_;
			_tmp21_ = fails;
			fails = _tmp21_ + 1;
			_g_free0 (t2);
			break;
		} else {
			FILE* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gint _tmp26_;
			_tmp22_ = stdout;
			_tmp23_ = t2;
			_tmp24_ = g_strconcat (_tmp23_, "\n", NULL);
			_tmp25_ = _tmp24_;
			fprintf (_tmp22_, "%s", _tmp25_);
			_g_free0 (_tmp25_);
			_tmp26_ = i;
			i = _tmp26_ + 1;
		}
		_g_free0 (t2);
	}
	_tmp28_ = fails;
	if (_tmp28_ > 0) {
		_tmp27_ = TRUE;
	} else {
		gint _tmp29_;
		_tmp29_ = i;
		_tmp27_ = _tmp29_ != 6;
	}
	if (_tmp27_) {
		FILE* _tmp30_;
		gint _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp30_ = stdout;
		_tmp31_ = fails;
		_tmp32_ = g_strdup_printf ("%i", _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strconcat ("----- FAIL ", _tmp33_, NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat (_tmp35_, "\n", NULL);
		_tmp37_ = _tmp36_;
		fprintf (_tmp30_, "%s", _tmp37_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp33_);
	} else {
		FILE* _tmp38_;
		_tmp38_ = stdout;
		fprintf (_tmp38_, "+++++ PASS\n");
	}
	_tmp39_ = stdout;
	fprintf (_tmp39_, "Iterating using foreach instruction...\n");
	i = 0;
	{
		GeeIterator* _r_it = NULL;
		GdaDataDbRecordCollection* _tmp40_;
		GeeIterator* _tmp41_;
		_tmp40_ = self->priv->itermodel;
		_tmp41_ = gee_iterable_iterator ((GeeIterable*) _tmp40_);
		_r_it = _tmp41_;
		while (TRUE) {
			GeeIterator* _tmp42_;
			GdaDataDbRecord* r = NULL;
			GeeIterator* _tmp43_;
			gpointer _tmp44_;
			gchar* t = NULL;
			GdaDataDbRecord* _tmp45_;
			gchar* _tmp46_;
			const gchar* _tmp47_;
			gint _tmp49_;
			FILE* _tmp50_;
			const gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			_tmp42_ = _r_it;
			if (!gee_iterator_next (_tmp42_)) {
				break;
			}
			_tmp43_ = _r_it;
			_tmp44_ = gee_iterator_get (_tmp43_);
			r = (GdaDataDbRecord*) _tmp44_;
			_tmp45_ = r;
			_tmp46_ = gda_data_db_record_to_string (_tmp45_);
			t = _tmp46_;
			_tmp47_ = t;
			if (_tmp47_ == NULL) {
				gint _tmp48_;
				_tmp48_ = fails;
				fails = _tmp48_ + 1;
				_g_free0 (t);
				_g_object_unref0 (r);
				break;
			}
			_tmp49_ = i;
			i = _tmp49_ + 1;
			_tmp50_ = stdout;
			_tmp51_ = t;
			_tmp52_ = g_strconcat (_tmp51_, "\n", NULL);
			_tmp53_ = _tmp52_;
			fprintf (_tmp50_, "%s", _tmp53_);
			_g_free0 (_tmp53_);
			_g_free0 (t);
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_it);
	}
	_tmp55_ = fails;
	if (_tmp55_ > 0) {
		_tmp54_ = TRUE;
	} else {
		gint _tmp56_;
		_tmp56_ = i;
		_tmp54_ = _tmp56_ != 6;
	}
	if (_tmp54_) {
		FILE* _tmp57_;
		gint _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		_tmp57_ = stdout;
		_tmp58_ = fails;
		_tmp59_ = g_strdup_printf ("%i", _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = g_strconcat ("----- FAIL ", _tmp60_, NULL);
		_tmp62_ = _tmp61_;
		_tmp63_ = g_strconcat (_tmp62_, "\n", NULL);
		_tmp64_ = _tmp63_;
		fprintf (_tmp57_, "%s", _tmp64_);
		_g_free0 (_tmp64_);
		_g_free0 (_tmp62_);
		_g_free0 (_tmp60_);
	} else {
		FILE* _tmp65_;
		_tmp65_ = stdout;
		fprintf (_tmp65_, "+++++ PASS\n");
	}
	result = fails;
	_g_object_unref0 (iter);
	return result;
}


gint
check_tests_choping (CheckTests* self)
{
	gint result = 0;
	gint fails = 0;
	FILE* _tmp0_;
	FILE* _tmp1_;
	GeeIterator* iter = NULL;
	GdaDataDbRecordCollection* _tmp2_;
	GeeIterator* _tmp3_;
	gint i = 0;
	gboolean _tmp32_ = FALSE;
	gint _tmp33_;
	FILE* _tmp45_;
	GeeIterator* iter2 = NULL;
	GdaDataDbRecordCollection* _tmp46_;
	GeeIterator* _tmp47_;
	gint _tmp89_;
	FILE* _tmp101_;
	GeeIterator* iter3 = NULL;
	GdaDataDbRecordCollection* _tmp102_;
	GeeIterator* _tmp103_;
	GeeIterator* _tmp104_;
	FILE* _tmp126_;
	GeeIterator* iter4 = NULL;
	GdaDataDbRecordCollection* _tmp127_;
	GeeIterator* _tmp128_;
	GeeIterator* _tmp129_;
	FILE* _tmp151_;
	GeeIterator* iter5 = NULL;
	GdaDataDbRecordCollection* _tmp152_;
	GeeIterator* _tmp153_;
	GeeIterator* _tmp154_;
	gint _tmp176_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Chopping...\n");
	_tmp1_ = stdout;
	fprintf (_tmp1_, " to get from the 2nd DbRecord to the 6th...\n");
	_tmp2_ = self->priv->itermodel;
	_tmp3_ = gee_traversable_chop ((GeeTraversable*) _tmp2_, 1, -1);
	iter = _tmp3_;
	i = 0;
	while (TRUE) {
		GeeIterator* _tmp4_;
		FILE* _tmp5_;
		GeeIterator* _tmp6_;
		gpointer _tmp7_;
		GdaDataDbRecord* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gint _tmp13_;
		GValue* _tmp14_ = NULL;
		GeeIterator* _tmp15_;
		gpointer _tmp16_;
		GdaDataDbRecord* _tmp17_;
		GValue* _tmp18_;
		gchar* name = NULL;
		gchar* _tmp20_;
		gint _tmp21_;
		_tmp4_ = iter;
		if (!gee_iterator_next (_tmp4_)) {
			break;
		}
		_tmp5_ = stdout;
		_tmp6_ = iter;
		_tmp7_ = gee_iterator_get (_tmp6_);
		_tmp8_ = (GdaDataDbRecord*) _tmp7_;
		_tmp9_ = gda_data_db_record_to_string (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, "\n", NULL);
		_tmp12_ = _tmp11_;
		fprintf (_tmp5_, "%s", _tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_object_unref0 (_tmp8_);
		_tmp13_ = i;
		i = _tmp13_ + 1;
		_tmp15_ = iter;
		_tmp16_ = gee_iterator_get (_tmp15_);
		_tmp17_ = (GdaDataDbRecord*) _tmp16_;
		_tmp18_ = gda_data_db_record_get_value (_tmp17_, "name", &_inner_error_);
		_g_object_unref0 (_tmp17_);
		_tmp14_ = _tmp18_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp19_ = -1;
			_g_object_unref0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp19_;
		}
		_tmp20_ = g_strdup (g_value_get_string (_tmp14_));
		name = _tmp20_;
		_tmp21_ = i;
		switch (_tmp21_) {
			case 1:
			{
				const gchar* _tmp22_;
				_tmp22_ = name;
				if (g_strcmp0 (_tmp22_, "Jhon") != 0) {
					gint _tmp23_;
					_tmp23_ = fails;
					fails = _tmp23_ + 1;
				}
				break;
			}
			case 2:
			{
				const gchar* _tmp24_;
				_tmp24_ = name;
				if (g_strcmp0 (_tmp24_, "James") != 0) {
					gint _tmp25_;
					_tmp25_ = fails;
					fails = _tmp25_ + 1;
				}
				break;
			}
			case 3:
			{
				const gchar* _tmp26_;
				_tmp26_ = name;
				if (g_strcmp0 (_tmp26_, "Jack") != 0) {
					gint _tmp27_;
					_tmp27_ = fails;
					fails = _tmp27_ + 1;
				}
				break;
			}
			case 4:
			{
				const gchar* _tmp28_;
				_tmp28_ = name;
				if (g_strcmp0 (_tmp28_, "Elsy") != 0) {
					gint _tmp29_;
					_tmp29_ = fails;
					fails = _tmp29_ + 1;
				}
				break;
			}
			case 5:
			{
				const gchar* _tmp30_;
				_tmp30_ = name;
				if (g_strcmp0 (_tmp30_, "Mayo") != 0) {
					gint _tmp31_;
					_tmp31_ = fails;
					fails = _tmp31_ + 1;
				}
				break;
			}
			default:
			break;
		}
		_g_free0 (name);
	}
	_tmp33_ = fails;
	if (_tmp33_ != 0) {
		_tmp32_ = TRUE;
	} else {
		gint _tmp34_;
		_tmp34_ = i;
		_tmp32_ = _tmp34_ != 5;
	}
	if (_tmp32_) {
		FILE* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		_tmp35_ = stdout;
		_tmp36_ = fails;
		fails = _tmp36_ + 1;
		_tmp37_ = fails;
		_tmp38_ = g_strdup_printf ("%i", _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat ("----- FAIL: ", _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strconcat (_tmp41_, "\n", NULL);
		_tmp43_ = _tmp42_;
		fprintf (_tmp35_, "%s", _tmp43_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
	} else {
		FILE* _tmp44_;
		_tmp44_ = stdout;
		fprintf (_tmp44_, "+++++ PASS\n");
	}
	_tmp45_ = stdout;
	fprintf (_tmp45_, "Choping to get the 4th to 5th DbRecords...\n");
	_tmp46_ = self->priv->itermodel;
	_tmp47_ = gee_traversable_chop ((GeeTraversable*) _tmp46_, 3, 2);
	iter2 = _tmp47_;
	i = 0;
	while (TRUE) {
		GeeIterator* _tmp48_;
		gint _tmp49_;
		FILE* _tmp50_;
		GeeIterator* _tmp51_;
		gpointer _tmp52_;
		GdaDataDbRecord* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		GValue* _tmp58_ = NULL;
		GeeIterator* _tmp59_;
		gpointer _tmp60_;
		GdaDataDbRecord* _tmp61_;
		GValue* _tmp62_;
		gchar* name2 = NULL;
		gchar* _tmp64_;
		gint _tmp65_;
		gint _tmp77_;
		_tmp48_ = iter2;
		if (!gee_iterator_next (_tmp48_)) {
			break;
		}
		_tmp49_ = i;
		i = _tmp49_ + 1;
		_tmp50_ = stdout;
		_tmp51_ = iter2;
		_tmp52_ = gee_iterator_get (_tmp51_);
		_tmp53_ = (GdaDataDbRecord*) _tmp52_;
		_tmp54_ = gda_data_db_record_to_string (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_strconcat (_tmp55_, "\n", NULL);
		_tmp57_ = _tmp56_;
		fprintf (_tmp50_, "%s", _tmp57_);
		_g_free0 (_tmp57_);
		_g_free0 (_tmp55_);
		_g_object_unref0 (_tmp53_);
		_tmp59_ = iter2;
		_tmp60_ = gee_iterator_get (_tmp59_);
		_tmp61_ = (GdaDataDbRecord*) _tmp60_;
		_tmp62_ = gda_data_db_record_get_value (_tmp61_, "name", &_inner_error_);
		_g_object_unref0 (_tmp61_);
		_tmp58_ = _tmp62_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp63_ = -1;
			_g_object_unref0 (iter2);
			_g_object_unref0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp63_;
		}
		_tmp64_ = g_strdup (g_value_get_string (_tmp58_));
		name2 = _tmp64_;
		_tmp65_ = i;
		if (_tmp65_ == 1) {
			const gchar* _tmp66_;
			_tmp66_ = name2;
			if (g_strcmp0 (_tmp66_, "Jack") != 0) {
				gint _tmp67_;
				FILE* _tmp68_;
				gint _tmp69_;
				gint _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				_tmp67_ = fails;
				fails = _tmp67_ + 1;
				_tmp68_ = stdout;
				_tmp69_ = fails;
				fails = _tmp69_ + 1;
				_tmp70_ = fails;
				_tmp71_ = g_strdup_printf ("%i", _tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = g_strconcat ("----- FAIL: ", _tmp72_, NULL);
				_tmp74_ = _tmp73_;
				_tmp75_ = g_strconcat (_tmp74_, "\n", NULL);
				_tmp76_ = _tmp75_;
				fprintf (_tmp68_, "%s", _tmp76_);
				_g_free0 (_tmp76_);
				_g_free0 (_tmp74_);
				_g_free0 (_tmp72_);
				_g_free0 (name2);
				break;
			}
		}
		_tmp77_ = i;
		if (_tmp77_ == 2) {
			const gchar* _tmp78_;
			_tmp78_ = name2;
			if (g_strcmp0 (_tmp78_, "Elsy") != 0) {
				gint _tmp79_;
				FILE* _tmp80_;
				gint _tmp81_;
				gint _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				_tmp79_ = fails;
				fails = _tmp79_ + 1;
				_tmp80_ = stdout;
				_tmp81_ = fails;
				fails = _tmp81_ + 1;
				_tmp82_ = fails;
				_tmp83_ = g_strdup_printf ("%i", _tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = g_strconcat ("----- FAIL: ", _tmp84_, NULL);
				_tmp86_ = _tmp85_;
				_tmp87_ = g_strconcat (_tmp86_, "\n", NULL);
				_tmp88_ = _tmp87_;
				fprintf (_tmp80_, "%s", _tmp88_);
				_g_free0 (_tmp88_);
				_g_free0 (_tmp86_);
				_g_free0 (_tmp84_);
				_g_free0 (name2);
				break;
			}
		}
		_g_free0 (name2);
	}
	_tmp89_ = i;
	if (_tmp89_ != 2) {
		gint _tmp90_;
		FILE* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		gchar* _tmp99_;
		_tmp90_ = fails;
		fails = _tmp90_ + 1;
		_tmp91_ = stdout;
		_tmp92_ = fails;
		fails = _tmp92_ + 1;
		_tmp93_ = fails;
		_tmp94_ = g_strdup_printf ("%i", _tmp93_);
		_tmp95_ = _tmp94_;
		_tmp96_ = g_strconcat ("----- FAIL: ", _tmp95_, NULL);
		_tmp97_ = _tmp96_;
		_tmp98_ = g_strconcat (_tmp97_, "\n", NULL);
		_tmp99_ = _tmp98_;
		fprintf (_tmp91_, "%s", _tmp99_);
		_g_free0 (_tmp99_);
		_g_free0 (_tmp97_);
		_g_free0 (_tmp95_);
	} else {
		FILE* _tmp100_;
		_tmp100_ = stdout;
		fprintf (_tmp100_, "+++++ PASS\n");
	}
	_tmp101_ = stdout;
	fprintf (_tmp101_, "Choping offset = 7 must fail...\n");
	_tmp102_ = self->priv->itermodel;
	_tmp103_ = gee_traversable_chop ((GeeTraversable*) _tmp102_, 7, -1);
	iter3 = _tmp103_;
	_tmp104_ = iter3;
	if (gee_iterator_has_next (_tmp104_)) {
		FILE* _tmp105_;
		gint _tmp106_;
		gint _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		gchar* _tmp110_;
		gchar* _tmp111_;
		gchar* _tmp112_;
		gchar* _tmp113_;
		_tmp105_ = stdout;
		_tmp106_ = fails;
		fails = _tmp106_ + 1;
		_tmp107_ = fails;
		_tmp108_ = g_strdup_printf ("%i", _tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = g_strconcat ("----- FAIL: ", _tmp109_, NULL);
		_tmp111_ = _tmp110_;
		_tmp112_ = g_strconcat (_tmp111_, "\n", NULL);
		_tmp113_ = _tmp112_;
		fprintf (_tmp105_, "%s", _tmp113_);
		_g_free0 (_tmp113_);
		_g_free0 (_tmp111_);
		_g_free0 (_tmp109_);
	} else {
		GeeIterator* _tmp114_;
		gint _tmp124_;
		_tmp114_ = iter3;
		if (gee_iterator_next (_tmp114_)) {
			FILE* _tmp115_;
			gint _tmp116_;
			gint _tmp117_;
			gchar* _tmp118_;
			gchar* _tmp119_;
			gchar* _tmp120_;
			gchar* _tmp121_;
			gchar* _tmp122_;
			gchar* _tmp123_;
			_tmp115_ = stdout;
			_tmp116_ = fails;
			fails = _tmp116_ + 1;
			_tmp117_ = fails;
			_tmp118_ = g_strdup_printf ("%i", _tmp117_);
			_tmp119_ = _tmp118_;
			_tmp120_ = g_strconcat ("----- FAIL: ", _tmp119_, NULL);
			_tmp121_ = _tmp120_;
			_tmp122_ = g_strconcat (_tmp121_, "\n", NULL);
			_tmp123_ = _tmp122_;
			fprintf (_tmp115_, "%s", _tmp123_);
			_g_free0 (_tmp123_);
			_g_free0 (_tmp121_);
			_g_free0 (_tmp119_);
		}
		_tmp124_ = fails;
		if (_tmp124_ == 0) {
			FILE* _tmp125_;
			_tmp125_ = stdout;
			fprintf (_tmp125_, "+++++ PASS\n");
		}
	}
	_tmp126_ = stdout;
	fprintf (_tmp126_, "Choping offset = 6 length = 0 must fail...\n");
	_tmp127_ = self->priv->itermodel;
	_tmp128_ = gee_traversable_chop ((GeeTraversable*) _tmp127_, 6, 0);
	iter4 = _tmp128_;
	_tmp129_ = iter4;
	if (gee_iterator_has_next (_tmp129_)) {
		FILE* _tmp130_;
		gint _tmp131_;
		gint _tmp132_;
		gchar* _tmp133_;
		gchar* _tmp134_;
		gchar* _tmp135_;
		gchar* _tmp136_;
		gchar* _tmp137_;
		gchar* _tmp138_;
		_tmp130_ = stdout;
		_tmp131_ = fails;
		fails = _tmp131_ + 1;
		_tmp132_ = fails;
		_tmp133_ = g_strdup_printf ("%i", _tmp132_);
		_tmp134_ = _tmp133_;
		_tmp135_ = g_strconcat ("----- FAIL: ", _tmp134_, NULL);
		_tmp136_ = _tmp135_;
		_tmp137_ = g_strconcat (_tmp136_, "\n", NULL);
		_tmp138_ = _tmp137_;
		fprintf (_tmp130_, "%s", _tmp138_);
		_g_free0 (_tmp138_);
		_g_free0 (_tmp136_);
		_g_free0 (_tmp134_);
	} else {
		GeeIterator* _tmp139_;
		gint _tmp149_;
		_tmp139_ = iter4;
		if (gee_iterator_next (_tmp139_)) {
			FILE* _tmp140_;
			gint _tmp141_;
			gint _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			_tmp140_ = stdout;
			_tmp141_ = fails;
			fails = _tmp141_ + 1;
			_tmp142_ = fails;
			_tmp143_ = g_strdup_printf ("%i", _tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = g_strconcat ("----- FAIL: ", _tmp144_, NULL);
			_tmp146_ = _tmp145_;
			_tmp147_ = g_strconcat (_tmp146_, "\n", NULL);
			_tmp148_ = _tmp147_;
			fprintf (_tmp140_, "%s", _tmp148_);
			_g_free0 (_tmp148_);
			_g_free0 (_tmp146_);
			_g_free0 (_tmp144_);
		}
		_tmp149_ = fails;
		if (_tmp149_ == 0) {
			FILE* _tmp150_;
			_tmp150_ = stdout;
			fprintf (_tmp150_, "+++++ PASS\n");
		}
	}
	_tmp151_ = stdout;
	fprintf (_tmp151_, "Choping offset = 5 length = 1...\n");
	_tmp152_ = self->priv->itermodel;
	_tmp153_ = gee_traversable_chop ((GeeTraversable*) _tmp152_, 5, 1);
	iter5 = _tmp153_;
	_tmp154_ = iter5;
	if (!gee_iterator_next (_tmp154_)) {
		FILE* _tmp155_;
		gint _tmp156_;
		gint _tmp157_;
		gchar* _tmp158_;
		gchar* _tmp159_;
		gchar* _tmp160_;
		gchar* _tmp161_;
		gchar* _tmp162_;
		gchar* _tmp163_;
		_tmp155_ = stdout;
		_tmp156_ = fails;
		fails = _tmp156_ + 1;
		_tmp157_ = fails;
		_tmp158_ = g_strdup_printf ("%i", _tmp157_);
		_tmp159_ = _tmp158_;
		_tmp160_ = g_strconcat ("----- FAIL: ", _tmp159_, NULL);
		_tmp161_ = _tmp160_;
		_tmp162_ = g_strconcat (_tmp161_, "\n", NULL);
		_tmp163_ = _tmp162_;
		fprintf (_tmp155_, "%s", _tmp163_);
		_g_free0 (_tmp163_);
		_g_free0 (_tmp161_);
		_g_free0 (_tmp159_);
	} else {
		GeeIterator* _tmp164_;
		gint _tmp174_;
		_tmp164_ = iter5;
		if (gee_iterator_next (_tmp164_)) {
			FILE* _tmp165_;
			gint _tmp166_;
			gint _tmp167_;
			gchar* _tmp168_;
			gchar* _tmp169_;
			gchar* _tmp170_;
			gchar* _tmp171_;
			gchar* _tmp172_;
			gchar* _tmp173_;
			_tmp165_ = stdout;
			_tmp166_ = fails;
			fails = _tmp166_ + 1;
			_tmp167_ = fails;
			_tmp168_ = g_strdup_printf ("%i", _tmp167_);
			_tmp169_ = _tmp168_;
			_tmp170_ = g_strconcat ("----- FAIL: ", _tmp169_, NULL);
			_tmp171_ = _tmp170_;
			_tmp172_ = g_strconcat (_tmp171_, "\n", NULL);
			_tmp173_ = _tmp172_;
			fprintf (_tmp165_, "%s", _tmp173_);
			_g_free0 (_tmp173_);
			_g_free0 (_tmp171_);
			_g_free0 (_tmp169_);
		}
		_tmp174_ = fails;
		if (_tmp174_ == 0) {
			FILE* _tmp175_;
			_tmp175_ = stdout;
			fprintf (_tmp175_, "+++++ PASS\n");
		}
	}
	_tmp176_ = fails;
	if (_tmp176_ == 0) {
		FILE* _tmp177_;
		_tmp177_ = stdout;
		fprintf (_tmp177_, "%s", "+++++ PASS: " "\n");
	}
	result = fails;
	_g_object_unref0 (iter5);
	_g_object_unref0 (iter4);
	_g_object_unref0 (iter3);
	_g_object_unref0 (iter2);
	_g_object_unref0 (iter);
	return result;
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gboolean
__lambda4_ (CheckTests* self,
            GdaDataDbRecord* g)
{
	gboolean result = FALSE;
	gboolean ret = FALSE;
	gboolean _tmp20_;
	g_return_val_if_fail (g != NULL, FALSE);
	ret = FALSE;
	{
		GeeIterator* _fl_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gda_data_db_record_get_fields (g);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_fl_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			GdaDataDbField* fl = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			gchar* t = NULL;
			GdaDataDbField* _tmp8_;
			GValue* _tmp9_;
			GValue* _tmp10_;
			GValue _tmp11_;
			gchar* _tmp12_;
			FILE* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp5_ = _fl_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _fl_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			fl = (GdaDataDbField*) _tmp7_;
			_tmp8_ = fl;
			_tmp9_ = gda_data_db_field_get_value (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = *_tmp10_;
			_tmp12_ = gda_value_stringify (&_tmp11_);
			t = _tmp12_;
			_tmp13_ = stdout;
			_tmp14_ = t;
			_tmp15_ = g_strconcat ("Value to check: ", _tmp14_, NULL);
			_tmp16_ = _tmp15_;
			fprintf (_tmp13_, "%s", _tmp16_);
			_g_free0 (_tmp16_);
			_tmp17_ = t;
			if (string_contains (_tmp17_, "J")) {
				FILE* _tmp18_;
				ret = TRUE;
				_tmp18_ = stdout;
				fprintf (_tmp18_, "...SELECTED\n");
				_g_free0 (t);
				_g_object_unref0 (fl);
				break;
			} else {
				FILE* _tmp19_;
				ret = FALSE;
				_tmp19_ = stdout;
				fprintf (_tmp19_, "...REJECTED\n");
			}
			_g_free0 (t);
			_g_object_unref0 (fl);
		}
		_g_object_unref0 (_fl_it);
	}
	_tmp20_ = ret;
	if (_tmp20_) {
		FILE* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp21_ = stdout;
		_tmp22_ = gda_data_db_record_to_string (g);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat ("SELECTED ROW: \n", _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp25_, "\n", NULL);
		_tmp27_ = _tmp26_;
		fprintf (_tmp21_, "%s", _tmp27_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
	}
	result = ret;
	return result;
}


static gboolean
___lambda4__gee_predicate (gconstpointer g,
                           gpointer self)
{
	gboolean result;
	result = __lambda4_ ((CheckTests*) self, (GdaDataDbRecord*) g);
	return result;
}


gint
check_tests_filtering (CheckTests* self)
{
	gint result = 0;
	gint fails = 0;
	FILE* _tmp0_;
	GeeIterator* iter = NULL;
	GdaDataDbRecordCollection* _tmp1_;
	GeeIterator* _tmp2_;
	FILE* _tmp3_;
	gint i = 0;
	gint _tmp23_;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Filtering Records: Any field type STRING with a letter 'J" \
"'...\n");
	_tmp1_ = self->priv->itermodel;
	_tmp2_ = gee_traversable_filter ((GeeTraversable*) _tmp1_, ___lambda4__gee_predicate, g_object_ref (self), g_object_unref);
	iter = _tmp2_;
	_tmp3_ = stdout;
	fprintf (_tmp3_, "\nPrinting Filtered Values...\n");
	i = 0;
	while (TRUE) {
		GeeIterator* _tmp4_;
		FILE* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GeeIterator* _tmp14_;
		gpointer _tmp15_;
		GdaDataDbRecord* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp4_ = iter;
		if (!gee_iterator_next (_tmp4_)) {
			break;
		}
		_tmp5_ = stdout;
		_tmp6_ = i;
		i = _tmp6_ + 1;
		_tmp7_ = i;
		_tmp8_ = g_strdup_printf ("%i", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("Row", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, ":\n", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = iter;
		_tmp15_ = gee_iterator_get (_tmp14_);
		_tmp16_ = (GdaDataDbRecord*) _tmp15_;
		_tmp17_ = gda_data_db_record_to_string (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp13_, _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, "\n", NULL);
		_tmp22_ = _tmp21_;
		fprintf (_tmp5_, "%s", _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_object_unref0 (_tmp16_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
	_tmp23_ = i;
	if (_tmp23_ != 3) {
		FILE* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp24_ = stdout;
		_tmp25_ = fails;
		fails = _tmp25_ + 1;
		_tmp26_ = fails;
		_tmp27_ = g_strdup_printf ("%i", _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strconcat ("----- FAIL", _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat (_tmp30_, "\n", NULL);
		_tmp32_ = _tmp31_;
		fprintf (_tmp24_, "%s", _tmp32_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
	} else {
		FILE* _tmp33_;
		_tmp33_ = stdout;
		fprintf (_tmp33_, "+++++ PASS\n");
	}
	result = fails;
	_g_object_unref0 (iter);
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CheckTests* self;
		self = _data1_->self;
		_g_free0 (_data1_->ts);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gchar*
______lambda6_ (Block1Data* _data1_)
{
	CheckTests* self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = _data1_->self;
	_tmp0_ = _data1_->ts;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gpointer
_______lambda6__gee_lazy_func (gpointer self)
{
	gpointer result;
	result = ______lambda6_ (self);
	return result;
}


static GeeTraversableStream
__lambda5_ (CheckTests* self,
            GeeTraversableStream state,
            GeeLazy* g,
            GeeLazy* * lazy)
{
	GeeLazy* _vala_lazy = NULL;
	GeeTraversableStream result = 0;
	switch (state) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			_gee_lazy_unref0 (_vala_lazy);
			_vala_lazy = NULL;
			result = GEE_TRAVERSABLE_STREAM_CONTINUE;
			_gee_lazy_unref0 (g);
			if (lazy) {
				*lazy = _vala_lazy;
			} else {
				_gee_lazy_unref0 (_vala_lazy);
			}
			return result;
			break;
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			GdaDataDbRecord* r = NULL;
			gconstpointer _tmp0_;
			GdaDataDbRecord* _tmp1_;
			GdaDataDbRecord* _tmp2_;
			_tmp0_ = gee_lazy_get_value (g);
			_tmp1_ = _tmp0_;
			_tmp2_ = _g_object_ref0 ((GdaDataDbRecord*) _tmp1_);
			r = _tmp2_;
			{
				GeeIterator* _f_it = NULL;
				GdaDataDbRecord* _tmp3_;
				GeeCollection* _tmp4_;
				GeeCollection* _tmp5_;
				GeeCollection* _tmp6_;
				GeeIterator* _tmp7_;
				GeeIterator* _tmp8_;
				_tmp3_ = r;
				_tmp4_ = gda_data_db_record_get_fields (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = _tmp5_;
				_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp6_);
				_f_it = _tmp8_;
				while (TRUE) {
					GeeIterator* _tmp9_;
					GdaDataDbField* f = NULL;
					GeeIterator* _tmp10_;
					gpointer _tmp11_;
					GdaDataDbField* _tmp12_;
					GValue* _tmp13_;
					GValue* _tmp14_;
					_tmp9_ = _f_it;
					if (!gee_iterator_next (_tmp9_)) {
						break;
					}
					_tmp10_ = _f_it;
					_tmp11_ = gee_iterator_get (_tmp10_);
					f = (GdaDataDbField*) _tmp11_;
					_tmp12_ = f;
					_tmp13_ = gda_data_db_field_get_value (_tmp12_);
					_tmp14_ = _tmp13_;
					if (G_VALUE_TYPE (_tmp14_) == G_TYPE_STRING) {
						Block1Data* _data1_;
						FILE* _tmp15_;
						GdaDataDbField* _tmp16_;
						const gchar* _tmp17_;
						const gchar* _tmp18_;
						GdaDataDbField* _tmp19_;
						GValue* _tmp20_;
						GValue* _tmp21_;
						GValue _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						GdaDataDbField* _tmp25_;
						GValue* _tmp26_;
						GValue* _tmp27_;
						GValue _tmp28_;
						gchar* _tmp29_;
						GeeLazy* _tmp30_;
						_data1_ = g_slice_new0 (Block1Data);
						_data1_->_ref_count_ = 1;
						_data1_->self = g_object_ref (self);
						_tmp15_ = stdout;
						_tmp16_ = f;
						_tmp17_ = gda_data_db_field_get_name (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp19_ = f;
						_tmp20_ = gda_data_db_field_get_value (_tmp19_);
						_tmp21_ = _tmp20_;
						_tmp22_ = *_tmp21_;
						_tmp23_ = gda_value_stringify (&_tmp22_);
						_tmp24_ = _tmp23_;
						fprintf (_tmp15_, "Field (%s) =  %s\n", _tmp18_, _tmp24_);
						_g_free0 (_tmp24_);
						_tmp25_ = f;
						_tmp26_ = gda_data_db_field_get_value (_tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = *_tmp27_;
						_tmp29_ = gda_value_stringify (&_tmp28_);
						_data1_->ts = _tmp29_;
						_tmp30_ = gee_lazy_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _______lambda6__gee_lazy_func, block1_data_ref (_data1_), block1_data_unref);
						_gee_lazy_unref0 (_vala_lazy);
						_vala_lazy = _tmp30_;
						block1_data_unref (_data1_);
						_data1_ = NULL;
					}
					_g_object_unref0 (f);
				}
				_g_object_unref0 (_f_it);
			}
			result = GEE_TRAVERSABLE_STREAM_YIELD;
			_g_object_unref0 (r);
			_gee_lazy_unref0 (g);
			if (lazy) {
				*lazy = _vala_lazy;
			} else {
				_gee_lazy_unref0 (_vala_lazy);
			}
			return result;
			_g_object_unref0 (r);
			break;
		}
		default:
		break;
	}
	result = GEE_TRAVERSABLE_STREAM_END;
	_gee_lazy_unref0 (g);
	if (lazy) {
		*lazy = _vala_lazy;
	} else {
		_gee_lazy_unref0 (_vala_lazy);
	}
	return result;
}


static GeeTraversableStream
___lambda5__gee_stream_func (GeeTraversableStream state,
                             GeeLazy* g,
                             GeeLazy* * lazy,
                             gpointer self)
{
	GeeTraversableStream result;
	result = __lambda5_ ((CheckTests*) self, state, g, lazy);
	return result;
}


gint
check_tests_streaming (CheckTests* self)
{
	gint result = 0;
	gint fails = 0;
	FILE* _tmp0_;
	GeeIterator* iter = NULL;
	GdaDataDbRecordCollection* _tmp1_;
	GeeIterator* _tmp2_;
	FILE* _tmp3_;
	GeeArrayList* l = NULL;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp18_;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp22_;
	gint _tmp24_;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Streaming Values: First DbRecord's field type STRING will" \
" be YIELDED...\n");
	_tmp1_ = self->priv->itermodel;
	_tmp2_ = gee_traversable_stream ((GeeTraversable*) _tmp1_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, ___lambda5__gee_stream_func, g_object_ref (self), g_object_unref);
	iter = _tmp2_;
	_tmp3_ = stdout;
	fprintf (_tmp3_, "Printing Streamed Values...\n");
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	l = _tmp4_;
	while (TRUE) {
		GeeIterator* _tmp5_;
		gchar* v = NULL;
		GeeIterator* _tmp6_;
		gpointer _tmp7_;
		GeeArrayList* _tmp8_;
		const gchar* _tmp9_;
		FILE* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp5_ = iter;
		if (!gee_iterator_next (_tmp5_)) {
			break;
		}
		_tmp6_ = iter;
		_tmp7_ = gee_iterator_get (_tmp6_);
		v = (gchar*) _tmp7_;
		_tmp8_ = l;
		_tmp9_ = v;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
		_tmp10_ = stdout;
		_tmp11_ = v;
		_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
		_tmp13_ = _tmp12_;
		fprintf (_tmp10_, "%s", _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (v);
	}
	_tmp14_ = l;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp14_, "Daniel")) {
		gint _tmp15_;
		_tmp15_ = fails;
		fails = _tmp15_ + 1;
	}
	_tmp16_ = l;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp16_, "Jhon")) {
		gint _tmp17_;
		_tmp17_ = fails;
		fails = _tmp17_ + 1;
	}
	_tmp18_ = l;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp18_, "Jack")) {
		gint _tmp19_;
		_tmp19_ = fails;
		fails = _tmp19_ + 1;
	}
	_tmp20_ = l;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp20_, "Elsy")) {
		gint _tmp21_;
		_tmp21_ = fails;
		fails = _tmp21_ + 1;
	}
	_tmp22_ = l;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp22_, "Mayo")) {
		gint _tmp23_;
		_tmp23_ = fails;
		fails = _tmp23_ + 1;
	}
	_tmp24_ = fails;
	if (_tmp24_ > 0) {
		FILE* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp25_ = stdout;
		_tmp26_ = fails;
		fails = _tmp26_ + 1;
		_tmp27_ = fails;
		_tmp28_ = g_strdup_printf ("%i", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat ("----- FAIL", _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp31_, "\n", NULL);
		_tmp33_ = _tmp32_;
		fprintf (_tmp25_, "%s", _tmp33_);
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
	} else {
		FILE* _tmp34_;
		_tmp34_ = stdout;
		fprintf (_tmp34_, "+++++ PASS\n");
	}
	result = fails;
	_g_object_unref0 (l);
	_g_object_unref0 (iter);
	return result;
}


gint
check_tests_InitIter (CheckTests* self,
                      GError** error)
{
	gint result = 0;
	FILE* _tmp0_;
	gint fails = 0;
	GdaDataModel* model = NULL;
	GdaConnection* _tmp1_;
	GdaDataModel* _tmp2_;
	FILE* _tmp4_;
	GdaDataTable* t = NULL;
	GdaDataTable* _tmp5_;
	GdaDataTable* _tmp6_;
	GdaConnection* _tmp7_;
	GdaDataTable* _tmp8_;
	FILE* _tmp9_;
	FILE* _tmp10_;
	GdaDataTable* _tmp11_;
	GdaDataRecordCollection* _tmp12_;
	FILE* _tmp13_;
	FILE* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> INITIALIZING: DbRecordCollection/RecordCollection\n");
	fails = 0;
	_tmp1_ = self->priv->connection;
	_tmp2_ = gda_connection_execute_select_command (_tmp1_, "SELECT * FROM user ORDER BY id", &_inner_error_);
	model = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp3_ = -1;
		g_propagate_error (error, _inner_error_);
		return _tmp3_;
	}
	_tmp4_ = stdout;
	fprintf (_tmp4_, "Setting up Table...");
	_tmp5_ = gda_data_table_new ();
	t = _tmp5_;
	_tmp6_ = t;
	_tmp7_ = self->priv->connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp6_, _tmp7_);
	_tmp8_ = t;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp8_, "user");
	_tmp9_ = stdout;
	fprintf (_tmp9_, "+++++ PASS\n");
	_tmp10_ = stdout;
	fprintf (_tmp10_, "Setting up DbRecordCollection...");
	_tmp11_ = t;
	_tmp12_ = gda_data_record_collection_new (model, (GdaDataDbTable*) _tmp11_);
	_g_object_unref0 (self->priv->itermodel);
	self->priv->itermodel = (GdaDataDbRecordCollection*) _tmp12_;
	_tmp13_ = stdout;
	fprintf (_tmp13_, "+++++ PASS\n");
	_tmp14_ = stdout;
	_tmp15_ = gda_data_model_dump_as_string (model);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat ("DataModel rows:\n", _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	fprintf (_tmp14_, "%s", _tmp18_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	result = fails;
	_g_object_unref0 (t);
	_g_object_unref0 (model);
	return result;
}


gint
check_tests_main (gchar** args,
                  int args_length1)
{
	gint result = 0;
	FILE* _tmp0_;
	gint failures = 0;
	CheckTests* app = NULL;
	CheckTests* _tmp1_;
	gint _tmp2_ = 0;
	CheckTests* _tmp3_;
	gint _tmp5_;
	gint _tmp6_ = 0;
	CheckTests* _tmp7_;
	gint _tmp9_;
	gint _tmp10_ = 0;
	gint _tmp11_;
	GError * _inner_error_ = NULL;
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Checking Gda.DataModelIterator implementation...\n");
	failures = 0;
	_tmp1_ = check_tests_new ();
	app = _tmp1_;
	_tmp3_ = app;
	_tmp2_ = check_tests_InitIter (_tmp3_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp4_ = -1;
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp4_;
	}
	_tmp5_ = failures;
	failures = _tmp5_ + _tmp2_;
	_tmp7_ = app;
	_tmp6_ = check_tests_iterating (_tmp7_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp8_ = -1;
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp8_;
	}
	_tmp9_ = failures;
	failures = _tmp9_ + _tmp6_;
	_tmp11_ = failures;
	if (_tmp11_ != 0) {
		_tmp10_ = 1;
	} else {
		_tmp10_ = 0;
	}
	result = _tmp10_;
	_g_object_unref0 (app);
	return result;
}


int
main (int argc,
      char ** argv)
{
	return check_tests_main (argv, argc);
}


static void
check_tests_class_init (CheckTestsClass * klass)
{
	check_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheckTestsPrivate));
	G_OBJECT_CLASS (klass)->finalize = check_tests_finalize;
}


static void
check_tests_instance_init (CheckTests * self)
{
	self->priv = CHECK_TESTS_GET_PRIVATE (self);
}


static void
check_tests_finalize (GObject * obj)
{
	CheckTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHECK_TYPE_TESTS, CheckTests);
	_g_object_unref0 (self->priv->connection);
	_g_object_unref0 (self->priv->itermodel);
	G_OBJECT_CLASS (check_tests_parent_class)->finalize (obj);
}


GType
check_tests_get_type (void)
{
	static volatile gsize check_tests_type_id__volatile = 0;
	if (g_once_init_enter (&check_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) check_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckTests), 0, (GInstanceInitFunc) check_tests_instance_init, NULL };
		GType check_tests_type_id;
		check_tests_type_id = g_type_register_static (G_TYPE_OBJECT, "CheckTests", &g_define_type_info, 0);
		g_once_init_leave (&check_tests_type_id__volatile, check_tests_type_id);
	}
	return check_tests_type_id__volatile;
}



